function obtenerSeguimientoDiario(idSeguimiento)
{
	$('.sinSombra').removeClass('fuenteNaranja');
	$('#filaSeguimiento'+idSeguimiento).addClass('fuenteNaranja');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerSeguimientoDiario').html('<img src="'+ img_loader +'"/>Obteniendo seguimiento');
		},
		type:"POST",
		url:base_url+'clientes/obtenerSeguimientoDiario',
		data:
		{
			"idSeguimiento":	idSeguimiento,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#obtenerSeguimientoDiario').html(data)
		},
		error:function(datos)
		{
			$('#obtenerSeguimientoDiario').html('');
			notify('Error al obtener el registro',500,5000,'error',0,0);
		}
	});		
}

function registrarDetalleSeguimientoFecha()
{
	var mensaje="";
	
	if(!camposVacios($("#txtComentarios").val()) || !camposVacios($("#txtFechaCierreEditar").val()) || !camposVacios($("#txtHoraCierre").val()) || !camposVacios($("#txtHoraCierreFin").val()) )
	{
		notify('Todos los datos son requeridos',500,5000,'error',30,5);
		return;
	}

	if(!confirm('¿Realmente desea continuar el registro?')) return;

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#editandoCrm').html('<img src="'+ img_loader +'"/>Procesando registro...');
		},
		type:"POST",
		url:base_url+"clientes/registrarDetalleSeguimientoFecha",
		data:
		{
			"observaciones":	$("#txtComentarios").val(),
			"fechaSeguimiento":	$('#txtFechaCierreEditar').val(),
			"idSeguimiento":	$('#txtIdSeguimiento').val(),
			//"idEstatus":		$("#selectEstatus").val(),
			"horaInicial":		$("#txtHoraCierre").val(),
			"horaFinal":		$("#txtHoraCierreFin").val(),
			"alerta":			document.getElementById('chkAlertaSeguimiento').checked?'1':'0',
			
			"idPrograma":		$("#selectProgramas").val(),
			"venta":			$("#txtVenta").val(),
			"idCliente":		$("#txtClienteId").val(),
			"idPromotor":		$("#txtIdPromotor").val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoCrm').html('');
			
			switch(data)
			{
				case "0":
					notify('¡Sin cambios en el registro!',500,5000,'error',30,5);
				break;
				
				case "1":
					notify('El registro fue exitoso',500,5000,'',30,5);
					
					obtenerSeguimientoDiario($('#txtIdSeguimiento').val());
				break;
				
			}//switch
		},
		error:function(datos)
		{
			$('#editandoCrm').html('')
			notify('Error en el registro',500,5000,'error',0,0);
		}
	});					  	  
}

function editarDatosGenerales()
{
	var mensaje="";

	if(!confirm('¿Realmente desea editar el registro?')) return;

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#editandoCrm').html('<img src="'+ img_loader +'"/>Se esta editando el registro...');
		},
		type:"POST",
		url:base_url+"clientes/editarDatosGenerales",
		data:
		{
			"nombre":			$("#txtNombreCliente").val(),
			"paterno":			$('#txtPaterno').val(),
			"materno":			$("#txtMaterno").val(),
			"fechaNacimiento":	$("#txtFechaNacimiento").val(),
			"idCliente":		$("#txtClienteId").val(),
			"idCampana":		$("#selectCampanas").val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoCrm').html('');
			
			switch(data)
			{
				case "0":
					notify('¡Sin cambios en el registro!',500,5000,'error',0,0);
				break;
				
				case "1":
					notify('El registro fue editado correctamente',500,5000,'',0,0);
				break;
				
			}//switch
		},
		error:function(datos)
		{
			$('#editandoCrm').html('')
			notify('Error al editar el seguimiento',500,5000,'error',0,0);
		}
	});					  	  
}


function definirTabSeguimiento(tab)
{
	$('.tabsSeguimiento').removeClass('activado');
	$('.tabsTabla').fadeOut(1);
	$('#'+tab).addClass('activado');
	$('#tabla-'+tab).fadeIn(1);
}


//ENVIAR IMPORTE
$(document).ready(function()
{
	$("#ventanaEnviarImporte").dialog(
	{
		autoOpen:false,
		show: { effect: "scale", duration: 600 },
		height:230,
		width:600,
		modal:true,
		resizable:false,
		buttons: 
		{
			'Enviar': function() 
			{
				
			}
		},
		close: function()
		{
			$("#formularioEnviarImporte").html('');
		}
	});
});

function formularioEnviarImporte(idCliente)
{
	$('#ventanaEnviarImporte').dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioEnviarImporte').html('<img src="'+ img_loader +'"/>Preparando el formulario...');
		},
		type:"POST",
		url:base_url+'crm/formularioEnviarImporte',
		data:
		{
			"idCliente":	idCliente,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#formularioEnviarImporte').html(data)
		},
		error:function(datos)
		{
			$('#formularioEnviarImporte').html('');
			notify('Error al obtener el formulario',500,5000,'error',0,0);
		}
	});		
}

function registrarClienteIexe()
{
	var mensaje="";
	
	if(!camposVacios($("#txtNombreClienteRegistro").val()) || !camposVacios($("#txtPaternoRegistro").val()))
	{
		notify('Todos los datos son requeridos',500,5000,'error',30,5);
		return;
	}

	if(!confirm('¿Realmente desea continuar el registro?')) return;

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#editandoCrm').html('<img src="'+ img_loader +'"/>Procesando registro...');
		},
		type:"POST",
		url:base_url+"crm/registrarClienteIexe",
		data:
		{
			"nombre":		$("#txtNombreClienteRegistro").val(),
			"apaterno":		$('#txtPaternoRegistro').val(),
			"amaterno":		$('#txtMaternoRegistro').val(),
			"telefono":		$("#txtTelefonoRegistro").val(),
			"email":		$("#txtEmailRegistro").val(),
			
			"fnacimiento":	$("#txtFechaNacimientoRegistro").val(),
			"promotor":		$("#txtPromotorSeguimiento").val(),
			
			"idCliente":	$("#txtClienteId").val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoCrm').html('');
			
			switch(data)
			{
				case "0":
					notify('¡Sin cambios en el registro!',500,5000,'error',30,5);
				break;
				
				case "1":
					notify('El registro fue exitoso',500,5000,'',30,5);
					
					obtenerSeguimientoDiario($('#txtIdSeguimiento').val());
				break;
				
			}//switch
		},
		error:function(datos)
		{
			$('#editandoCrm').html('')
			notify('Error en el registro',500,5000,'error',0,0);
		}
	});					  	  
}