function formularioFacturaGlobal()
{
	$('#ventanaFacturaGlobal').dialog('open');
	
	$.ajax(
	{
		async:false,
		beforeSend:function(objeto){$('#formularioFacturaGlobal').html('<img src="'+ img_loader +'"/>Obteniendo detalles para la factura, por favor espere...');},
		type:"POST",
		url:base_url+'facturacion/formularioFacturaGlobal',
		data:
		{
			//"idCuenta": idCuenta,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioFacturaGlobal").html(data);
		},
		error:function(datos)
		{
			$("#formularioFacturaGlobal").html('');
			notify('Error al obtener los datos para la factura',500,5000,'error',30,3);
		}
	});				  	  
}

$(document).ready(function()
{
	$("#ventanaFacturaGlobal").dialog(
	{
		autoOpen:false,
		height:500,
		width:900,
		modal:true,
		resizable:false,
		buttons: 
		{
			Cancelar: function() 
			{
				$(this).dialog('close');				 
			},
			'Aceptar': function() 
			{
				registrarFacturaGlobal();
			},
		},
		close: function() 
		{
			$("#formularioFacturaGlobal").html('');
		}
	});
});

function rangoDatos()
{
	if($('#selectTipoRango').val()=="Fechas")
	{
		$('#filaRangoFechas').fadeIn();
		$('#filaRangoNotas').fadeOut();
	}
	
	if($('#selectTipoRango').val()=="Folios")
	{
		$('#filaRangoNotas').fadeIn();
		$('#filaRangoFechas').fadeOut();
		
		$('#txtFolioInicial').focus();
	}
	
	setTimeout(function() 
	{
		obtenerTotalesFactura()
	}, 500);
	
	
}

function obtenerTotalesFactura()
{
	if($('#selectTipoRango').val()=="Folios")
	{
		inicio	= obtenerNumeros($('#txtFolioInicial').val());
		fin		= obtenerNumeros($('#txtFolioFinal').val());
		
		if(inicio>fin)
		{
			notify('Configure correctamente el folio de inicio y el folio final',500,1000,'error',30,3);
			
			$("#txtTotalesFacturaGlobal").val(0);
			$("#lblSubTotal,#lblIva,#lblTotal").html('$0.00')
			
			return;
		}
	}
	
	$.ajax(
	{
		async:false,
		beforeSend:function(objeto){$('#obtenerTotalesFactura').html('<img src="'+ img_loader +'"/>Obteniendo detalles para la factura, por favor espere...');},
		type:"POST",
		url:base_url+'facturacion/obtenerTotalesFactura',
		data:
		{
			"inicio": 	$('#selectTipoRango').val()=="Fechas"?$('#txtInicio').val():$('#txtFolioInicial').val(),
			"fin": 		$('#selectTipoRango').val()=="Fechas"?$('#txtFin').val():$('#txtFolioFinal').val(),
			"tipo":		$('#selectTipoRango').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerTotalesFactura").html(data);
		},
		error:function(datos)
		{
			$("#obtenerTotalesFactura").html('');
			notify('Error al obtener los datos para la factura',500,5000,'error',30,3);
		}
	});				  	  
}

function calcularTotalesFactura() //Calcular los importes por conceptos
{
	subTotal	= 0;
	iva			= 0;
	total		= 0;
	
	for(i=1;i<=fila;i++)
	{
		if(!isNaN($('#txtIdConcepto'+i).val()))
		{
			cantidad	=obtenerNumero($('#txtCantidadFactura'+i).val());
			precio		=obtenerNumero($('#txtPrecioFactura'+i).val());

			i/*f(isNaN(cantidad) || cantidad==0 || Solo_Numerico(cantidad)=="")
			{
				cantidad=0;
			}
			
			if(isNaN(precio) || precio==0 || Solo_Numerico(precio)=="")
			{
				precio=0;
			}*/
			
			subTotal+=precio*cantidad;
			
			$('#txtImporteFactura'+i).val(redondear(precio*cantidad))
		}
	}

	iva		= obtenerNumero($('#selectIva').val())/100;
	iva		= iva*subTotal;
	total	= subTotal+iva;
	
	$('#txtSubTotal').val(redondear(subTotal))
	$('#txtIva').val(redondear(iva))
	$('#txtTotal').val(redondear(total))
	
	$('#lblSubTotal').html('$'+redondear(subTotal))
	$('#lblIva').html('$'+redondear(iva))
	$('#lblTotal').html('$'+redondear(total))
	
}

function registrarFacturaGlobal()
{
	/*if($('#txtFoliosActivos').val()=="0")
	{
		notify('Los folios se han terminado, por favor consulte con el administrador',500,5000,'error',30,5);
		return;
	}*/
	
	var mensaje="";
	
	if($("#selectEmisoresGlobal").val()=="0")
	{
		mensaje+="Seleccione el emisor <br />";										
	}
	
	if($("#txtIdClienteGlobal").val()=="0")
	{
		mensaje+="Seleccione el cliente <br />";										
	}
	
	if(parseFloat($("#txtTotalesFacturaGlobal").val())=="0")
	{
		mensaje+="El importe de la factura es incorrecto <br />";										
	}
	
	/*if(!camposVacios($("#txtConceptoGlobal").val()))
	{
		mensaje+="El concepto es incorrecto <br />";										
	}*/
	
	b=1;
	
	
	if(mensaje.length>0)
	{
		notify(mensaje,500,5000,'error',30,0);
		return;
	}
	
	if(!confirm('¿Realmente desea registrar la factura?')) return;

	$.ajax(
	{
		async:false,
		beforeSend:function(objeto){$('#registrandoFacturaGlobal').html('<img src="'+ img_loader +'"/>Se esta creando la factura, por favor espere...');},
		type:"POST",
		url:base_url+"facturacion/registrarFacturaGlobal",
		data:
		//$('#frmFacturacion').serialize(),
		$('#frmFacturacion').serialize()+'&metodoPagoTexto='+$("#txtMetodoPago option:selected").text()+'&formaPagoTexto='+$("#txtFormaPago option:selected").text()+'&usoCfdiTexto='+$("#selectUsoCfdi option:selected").text(),
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#registrandoFacturaGlobal").html('');
			data=eval(data);
			
			switch(data[0])
			{
				case "0":
					notify(data[1],500,5000,'error',30,5);
				break;
				case "1":
					$('#ventanaFacturaGlobal').dialog('close');
					notify('La factura se ha registrado corractamente',500,5000,'error',30,5);
					obtenerFacturas();
				break;
				
			}
		},
		error:function(datos)
		{
			$("#registrandoFacturaGlobal").html('');
			notify('Error al realizar la factura',500,5000,'error',30,3);
		}
	});		
}


