detalleCita	= false;

$(document).ready(function ()
{
	obtenerRegistros()

	$("#ventanaDetallesSeguimientoTablero").dialog(
	{
		autoOpen:false,
		height:450,
		width:900,
		modal:true,
		resizable:false,
		buttons: 
		{
			Registrar: function() 
			{
				formularioSeguimientoDetalle($("#txtIdSeguimiento").val())		 
			},
			Cancelar: function() 
			{
				$(this).dialog("close"); 
			},
		},
		close: function() 
		{
			$("#obtenerDetalleSeguimientoTablero").html('');
			detalleCita	= false;
		}
	});

	$("#ventanaRegistrarSeguimientoTablero").dialog(
	{
		autoOpen:false,
		height:450,
		width:900,
		modal:true,
		resizable:false,
		buttons: 
		{
			
			Cancelar: function() 
			{
				$(this).dialog("close"); 
			},
			Aceptar: function() 
			{
				registrarSeguimientoTablero();		 
			},
		},
		close: function() 
		{
			$("#formularioSeguimientoTablero").html('');
			detalleCita	= false;
		}
	});
})

function obtenerRegistros()
{
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerRegistros').html('<img src="'+ img_loader +'"/>Obteniendo registros...');
		},
		type:"POST",
		url:base_url+'dashboard/obtenerRegistros',
		data:
		{
			'fecha': 			$('#txtFechaActual').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#obtenerRegistros').html(data);
		},
		error:function(datos)
		{
			$('#obtenerRegistros').html('')
		}
	});		
}

function cambiarFechaActual(fecha)
{
	$('#txtFechaActual').val(fecha);
	obtenerRegistros();
}

function obtenerDetalleSeguimientoTablero(idDetalle)
{
	detalleCita	= true;

	$('#ventanaDetallesSeguimientoTablero').dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerDetalleSeguimientoTablero').html('<label><img src="'+base_url+'img/ajax-loader.gif"/> Preparando el formulario</label>');
		},
		type:"POST",
		url:base_url+'dashboard/obtenerDetalleSeguimiento',
		data:
		{
			idDetalle:idDetalle
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#obtenerDetalleSeguimientoTablero').html(data);
		},
		error:function(datos)
		{
			$('#obtenerDetalleSeguimientoTablero').html('');
			notify("Error al obtener los datos para registrar la factura",500,4000,"error"); 
		}
	});	
}

function formularioSeguimientoTablero(fecha,hora)
{
	if(detalleCita)
	{
		return;	
	}
	
	$('#ventanaRegistrarSeguimientoTablero').dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioSeguimientoTablero').html('<label><img class="loader" src="'+base_url+'img/loader.gif"/> Preparando el formulario</label>');
		},
		type:"POST",
		url:base_url+'dashboard/formularioSeguimientoTablero',
		data:
		{
			fecha:	fecha,
			hora:	hora,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#formularioSeguimientoTablero').html(data)
		},
		error:function(datos)
		{
			$('#formularioSeguimientoTablero').html('');
		}
	});	
}

function registrarSeguimientoTablero()
{
	var mensaje = "";

	if ($('#txtIdCliente').val() == "0") {
		mensaje += 'Seleccione el prospecto <br />';
	}

	if ($('#txtComentarios').val() == "") {
		mensaje += 'Los comentarios son requeridos <br />';
	}
	
	if($('#txtFechaSeguimiento').val()=="")
	{
		mensaje+='Debe seleccionar una fecha <br />';
	}


	if(mensaje.length>0)
	{
		notify(mensaje,500,5000,'error',30,5);
		return;
	}
	
	if(!confirm('¿Realmente desea agregar el seguimiento?')) return;

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#procesandoRegistroTablero').html('<img src="'+ img_loader +'"/>Procesando el registro...');
		},
		type:"POST",
		url:base_url+"clientes/registrarSeguimiento",
		data:
		{
			"comentarios":			$("#txtComentarios").val(),
			"bitacora":				'',
			"fecha":				$('#txtFechaSeguimiento').val() + ' ' + $('#txtHoraSeguimiento').val(),
			"idCliente":			$('#txtIdCliente').val(),
			"idStatus":				$('#selectStatus').val(),
			"idStatusIgual":		0,
			"idServicio":			0,
			"idResponsable":		$('#selectResponsable').val(),
			"fechaCierre":			$('#txtFechaCierre').val() + ' ' + $('#txtHoraCierre').val(),
			"lugar":				'',
			"email":				'',
			"idTiempo":				0,
			"idContacto":			$("#txtIdContacto").val(),		
			"idCotizacion":			0,
			"idVenta":				0,
			"idEstatus":			$("#selectEstatus").val(),
			tipo: 					'1',
			"horaInicial":			$("#txtHoraCierre").val(),
			"horaCierreFin":		$("#txtHoraCierreFin").val(),
			"alerta":				'0',
			"idConcepto":			0,
			"importe":				obtenerNumeros($("#txtImporte").val()),
			
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#procesandoRegistroTablero').html('');
			
			data=eval(data);
			
			switch(data[0])
			{
				case "0":
					notify(data[1],500,5000,'error',30,5);
				break;
				
				case "1":
					notify('El seguimiento se ha registrado correctamente', 500, 5000, '', 30, 5);
					obtenerRegistros();
					$('#ventanaRegistrarSeguimientoTablero').dialog('close');
				break;
				
			}//switch
		},
		error:function(datos)
		{
			$('#procesandoRegistroTablero').html('')
			notify('Error al registrar el seguimiento',500,5000,'error',0,0);
		}
	});				
}
