//EDITAR FECHA
$(document).ready(function()
{
	$("#ventanaEditarFechaContacto").dialog(
	{
		autoOpen:false,
		show: { effect: "scale", duration: 600 },
		height:200,
		width:700,
		modal:true,
		resizable:false,
		buttons: 
		{
			'Editar': function() 
			{
				editarFechaContacto()
			}
		},
		close: function()
		{
			$("#formularioFechaContacto").html('');
		}
	});
});

function formularioFechaContacto(idDetalle)
{
	$('#ventanaEditarFechaContacto').dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioFechaContacto').html('<img src="'+ img_loader +'"/>Preparando el formulario...');
		},
		type:"POST",
		url:base_url+'crm/formularioFechaContacto',
		data:
		{
			"idDetalle":	idDetalle,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#formularioFechaContacto').html(data)
			$('#txtHoraInicial').focus();
		},
		error:function(datos)
		{
			$('#formularioFechaContacto').html('');
			notify('Error al obtener el formulario',500,5000,'error',0,0);
		}
	});		
}

function editarFechaContacto()
{
	if(!confirm('¿Realmente desea editar el registro?')) return;

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#editandoFechaContacto').html('<img src="'+ img_loader +'"/>Procesando registro...');
		},
		type:"POST",
		url:base_url+"crm/editarFechaContacto",
		data:
		{
			"fechaSeguimiento":			$("#txtFechaProximo").val(),
			"horaInicial":				$('#txtHoraInicial').val(),
			"horaFinal":				$('#txtHoraFinal').val(),
			"idDetalle":				$('#txtIdDetalleEditar').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoFechaContacto').html('');
			
			switch(data)
			{
				case "0":
					notify('¡Sin cambios en el registro!',500,5000,'error',30,5);
				break;
				
				case "1":
					notify('El registro fue exitoso',500,5000,'',30,5);
					
					obtenerSeguimientoDiario($('#txtIdSeguimiento').val());
					$('#ventanaEditarFechaContacto').dialog('close');
				break;
				
			}//switch
		},
		error:function(datos)
		{
			$('#editandoFechaContacto').html('')
			notify('Error en el registro',500,5000,'error',0,0);
		}
	});					  	  
}