//=====================================================================================================//
//===================================FUNCIONES DE MATERIA PRIMA========================================//
//=====================================================================================================//

$(document).ready(function()
{
	obtenerRegistrosEstatus()
	
	$("#ventanaRegistroEstatus").dialog(
	{
		autoOpen:false,
		height:200,
		width:850,
		modal:true,
		resizable:false,
		show: { effect: "scale", duration: 500 },
		buttons: 
		[
		 	{
                text: "Cancelar",
                click: function() 
				{
                    $( this ).dialog( "close" );
                }
            },
            {
                text: "Registrar",
                click: $.noop,
                type: "submit",
                form: "frmRegistroEstatus",
				
            },
        ],
		close: function() 
		{
			$("#formularioRegistroEstatus").html('');
		}
	});
	
	$("#txtBuscarRegistroEstatus").keyup(function() 
	{
		clearTimeout(tiempoRetraso);
		milisegundos 	= 500; // milliseconds
		tiempoRetraso 	= setTimeout(function() 
		{
			obtenerRegistrosEstatus();
		}, milisegundos);
	});
	
	$(document).on("click", ".ajax-pagRegistrosEstatus > li a", function(eve)
	{
		eve.preventDefault();
		var element 	= "#obtenerRegistroEstatus";
		var link 		= $(this).attr('href');
		
		$.ajax(
		{
			url:link,
			type:"POST",
			data:
			{
				"criterio":	$('#txtBuscarRegistroEstatus').val(),
			},
			dataType:"html",
			beforeSend:function()
			{
				$('#obtenerRegistroEstatus').html('<img src="'+ img_loader +'"/>Obteniendo registros..');
			},
			success:function(html,textStatus)
			{
				setTimeout(function()
				{
					$(element).html(html);},300);
				},
				error:function(datos){$(element).html('Error '+ datos).show('slow');
			}
		});
	});
});

function obtenerRegistrosEstatus()
{
	if(ejecutar && ejecutar.readystate != 4)
	{
		ejecutar.abort();
	}

	ejecutar=$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerRegistrosEstatus').html('<img src="'+ img_loader +'"/> Obteniendo registros...');
		},
		type:"POST",
		url:base_url+"estatus/obtenerRegistros",
		data:
		{
			"criterio":	$('#txtBuscarRegistroEstatus').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#obtenerRegistrosEstatus').html(data);
			
		},
		error:function(datos)
		{
			//notify('Error al obtener los registros',500,5000,'error',30,5)
			$("#obtenerRegistrosEstatus").html('');	
		}
	});
}

function formularioRegistroEstatus()
{
	$('#ventanaRegistroEstatus').dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioRegistroEstatus').html('<img src="'+ img_loader +'"/> Preparando el formulario...');
		},
		type:"POST",
		url:base_url+"estatus/formularioRegistro",
		data:
		{
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#formularioRegistroEstatus').html(data);
			$('#txtNombre').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3)
			$("#formularioRegistroEstatus").html('');	
		}
	});
}


function registrarFormularioEstatus()
{
	$.ajax(
	{
		async:false,
		beforeSend:function(objeto)
		{
			$('#registrandoInformacionEstatus').html('<img src="'+ img_loader +'"/> Registrando, por favor espere...');
		},
		type:"POST",
		url:base_url+"estatus/registrarFormulario",
		data: $('#frmRegistroEstatus').serialize(),
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoInformacionEstatus').html('');
			data	= eval(data);
			
			switch(data[0])
			{
				case "0":
					notify(data[1],500,5000,'error',30,3);
				break;
				
				case "1":
					notify(data[1],500,5000,'',30,5)
					$('#ventanaRegistroEstatus').dialog('close');
					obtenerRegistrosEstatus();
					$('#txtEstatusEditado').val(1);
				break;
			}
		},
		error:function(datos)
		{
			$('#registrandoInformacionEstatus').html('');
			notify('Error al registrar',500,5000,'error',30,3);	
		}
	});
}
/*--------------------------------EDITAR MATERIALES-------------------------------------*/

function obtenerRegistroEstatus(idEstatusCobranza)
{
	$('#ventanaEditarRegistroEstatus').dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerRegistroEstatus').html('<img src="'+ img_loader +'"/> Obteniendo el registro');
		},
		type:"POST",
		url:base_url+"estatus/obtenerRegistro",
		data:
		{
			"idEstatusCobranza":idEstatusCobranza,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#obtenerRegistroEstatus').html(data);
		},
		error:function(datos)
		{
			$("#obtenerRegistroEstatus").html('');	
		}
	});//Ajax	
}

$(document).ready(function()
{
	$("#ventanaEditarRegistroEstatus").dialog(
	{
		autoOpen:false,
		show: { effect: "scale", duration: 600 },
		height:200,
		width:850,
		modal:true,
		resizable:false,
		buttons: 
		[
		 	{
                text: "Cancelar",
                click: function() 
				{
                    $( this ).dialog( "close" );
                }
            },
            {
                text: "Editar",
                click: $.noop,
                type: "submit",
                form: "frmEditarEstatus",
				
            },
        ],
		close: function() 
		{
			$("#obtenerRegistroEstatus").html('');
		}
	});
});

function editarFormularioEstatus()
{
	if(!confirm('¿Realmente desea editar el registro?')) return;
	
	$.ajax(
	{
		async:false,
		beforeSend:function(objeto)
		{
			$('#editandoInformacionEstatus').html('<img src="'+ img_loader +'"/> Se esta editando el registro, por favor espere...');
		},
		type:"POST",
		url:base_url+"estatus/editarFormulario",
		data: $('#frmEditarEstatus').serialize(),
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoInformacionEstatus').html('');
			
			data	= eval(data);
			
			switch(data[0])
			{
				case "0":
					notify(data[1],500,5000,'error',30,5);
				break;
				case "1":
					notify(data[1],500,5000,'',30,5)
					$("#ventanaEditarRegistroEstatus").dialog('close');
					obtenerRegistrosEstatus();
					$('#txtEstatusEditado').val(1);
				break;
			}
		},
		error:function(datos)
		{
			$('#editandoInformacionEstatus').html('');
			notify('Error al editar el registro',500,5000,'error',30,3);
		}
	});				
}

function borrarRegistroEstatus(idEstatusCobranza)
{
	if(!confirm('¿Realmente desea borrar el registro?')) return;
	
	$.ajax(
	{
		async:false,
		beforeSend:function(objeto)
		{
			$('#procesandoInformacionEstatus').html('<img src="'+ img_loader +'"/> Borrando registro, por favor espere...');
		},
		type:"POST",
		url:base_url+"estatus/borrarRegistro",
		data:
		{
			"idEstatusCobranza":		idEstatusCobranza,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#procesandoInformacionEstatus').html('');
			
			data	= eval(data);
			
			switch(data[0])
			{
				case "0":
					notify('Error al borrar el registro',500,5000,'error',30,3);
				break;
				
				case "1":
					notify('El registro se ha borrado correctamente',500,5000,'',30,5);
					obtenerRegistrosEstatus();
					$('#txtEstatusEditado').val(1);
				break;
			}
		},
		error:function(datos)
		{
			$('#procesandoInformacionEstatus').html('');
			notify('Error al borrar el registro',500,5000,'error',30,3);	
		}
	});
}