//PARA NIVEL 1
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
$(document).ready(function()
{
	obtenerPropuestas();

	$('#txtBuscarPropuesta').keypress(function(e)
	 {
		if(e.which == 13) 
		{
			obtenerPropuestas();
		}
	});
	
	$("#ventanaRegistrarPropuestas").dialog(
	{
		autoOpen:false,
		height:300,
		width:700,
		modal:true,
		resizable:false,
		buttons: 
		[
		 	{
                text: "Cancelar",
                click: function() 
				{
                    $( this ).dialog( "close" );
                }
            },
            {
                text: "Registrar",
                click: $.noop,
                type: "submit",
				form: "frmRegistro",
				
            },
        ],
		close: function() 
		{
			$("#formularioPropuestas").html('');
		}
	});

});

function obtenerPropuestas()
{
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerPropuestas').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo registros');
		},
		type:"POST",
			url: base_url +'catalogos/obtenerPropuestas',
		data:
		{
			criterio:		$('#txtBuscarPropuesta').val(),
			idSeguimiento:	$('#txtIdSeguimiento').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerPropuestas").html(data);
		},
		error:function(datos)
		{
			notify('Error al obtener los registros',500,5000,'error',30,3);
			$("#obtenerPropuestas").html('');
		}
	});		
}

function formularioPropuestas()
{
	$("#ventanaRegistrarPropuestas").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioPropuestas').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo el formulario');
		},
		type:"POST",
			url: base_url +'catalogos/formularioPropuestas',
		data:
		{
			//idUsuario:idUsuario
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioPropuestas").html(data);
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3);
			$("#formularioPropuestas").html('');
		}
	});		
}


function registrarPropuesta()
{
	if (!confirm("¿Realmente desea continuar el registro?")) return;

	var formData = new FormData($('#frmRegistro')[0]);
	formData.append('idSeguimiento', $('#txtIdSeguimiento').val());

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoPropuesta').html('<img src="'+base_url+'img/ajax-loader.gif"/> Registrando');
		},
		type:"POST",
		url:base_url+'catalogos/registrarPropuesta',
		cache: false,
		contentType: false,
		processData: false,
		data: formData,
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoPropuesta').html('');
			
			switch(eval(data)[0])
			{
				case "0":
					notify('Error en el registro',500,5000,'error',30,3);
				break;
	
				case "1":
					notify('El registro ha sido correcto',500,5000,'',30,3);
					obtenerPropuestas();
					$("#ventanaRegistrarPropuestas").dialog('close');
				break;
			}
		},
		error:function(datos)
		{
			notify('Error en el registro',500,5000,'error',30,3);
			$("#registrandoPropuesta").html('');
		}
	});		
}

function obtenerPropuesta(idPropuesta)
{
	$("#ventanaRegistrarPropuestas").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioPropuestas').html('<img src="'+base_url+'img/ajax-loader.gif"/> Preparando el formulario');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerPropuesta',
		data:
		{
			idPropuesta: idPropuesta
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioPropuestas").html(data);
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3);
			$("#formularioPropuestas").html('');
		}
	});		
}

function editarPropuesta()
{
	if(!confirm("¿Realmente desea continuar el registro?")) return;

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoPropuesta').html('<img src="'+base_url+'img/ajax-loader.gif"/> Registrando');
		},
		type:"POST",
		url:base_url+'catalogos/editarPropuesta',
		data:$("#frmRegistro").serialize(),
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoPropuesta').html('');
			
			switch(eval(data)[0])
			{
				case "0":
					notify('Error en el registro',500,5000,'error',30,3);
				break;
	
				case "1":
					notify('El registro ha sido correcto',500,5000,'',30,3);
					obtenerPropuestas();
					$("#ventanaRegistrarPropuestas").dialog('close');
				break;
			}
		},
		error:function(datos)
		{
			notify('Error en el registro',500,5000,'error',30,3);
			$("#registrandoPropuesta").html('');
		}
	});		
}

function borrarPropuesta(idPropuesta)
{
	if(!confirm('¿Realmente desea borrar el registro?'))return;
		
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#procesandoPropuestas').html('<img src="'+base_url+'img/ajax-loader.gif"/> Borrando el registro');
		},
		type:"POST",
		url:base_url+"catalogos/borrarPropuesta",
		data:
		{
			"idPropuesta": idPropuesta,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#procesandoPropuestas').html('');
			
			switch(eval(data)[0])
			{
				case "0":
					notify('Error al borrar el registro',500,5000,'error',30,3);
				break;
				
				case "1":
					obtenerPropuestas();
					notify('El registro se ha borrado correctamente',500,5000,'',30,3);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al borrar el registro',500,5000,'error',30,3);
			$('#procesandoPropuestas').html('');
		}
	});				  	  
}