//ARCHIVOS
$(document).ready(function()
{
	$("#ventanaArchivosPropuesta").dialog(
	{
		autoOpen:false,
		show: { effect: "scale", duration: 600 },
		height:500,
		width:900,
		modal:true,
		resizable:false,
		
		buttons: 
		{
			'Cerrar': function() 
			{
				$(this).dialog('close');				 
			},
		},
		close: function()
		{
			$("#obtenerArchivosPropuesta").html('');
		}
	});
});

function obtenerArchivosPropuesta(idPropuesta)
{
	$('#ventanaArchivosPropuesta').dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerArchivosPropuesta').html('<img src="'+ img_loader +'"/> Obteniendo archivos, por favor espere...');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerArchivosPropuesta',
		data:
		{
			"idPropuesta": idPropuesta,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#obtenerArchivosPropuesta').html(data);
		},
		error:function(datos)
		{
			$('#obtenerArchivosPropuesta').html('');
			notify('Error al obtener los archivos',500,5000,'error',0,0);
		}
	});		
}

function borrarArchivoPropuesta(idArchivo)
{
	if(!confirm('¿Realmente desea borrar el archivo?'))return;
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoArchivosPropuesta').html('<img src="'+ img_loader +'"/> Borrando archivo, por favor espere...');
		},
		type:"POST",
		url:base_url+'catalogos/borrarArchivoPropuesta',
		data:
		{
			"idArchivo":idArchivo,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoArchivosPropuesta').html('')
			
			switch(data)
			{
				case "0":
				notify('¡Error al borrar el archivo!',500,5000,'error',0,0);
				break;
				
				case "1":
				notify('¡El archivo se ha borrado correctamente!',500,5000,'',0,0);
				obtenerArchivosPropuesta($('#txtIdPropuesta').val());
				break;
				
			}//switch
		},
		error:function(datos)
		{
			$('#registrandoArchivosPropuesta').html('');
			notify('¡Error al borrar el fichero!',500,5000,'error',0,0);
		}
	});		
}