//PARA NIVEL 1
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
$(document).ready(function()
{
	$('#txtBuscarPae').keypress(function(e)
	 {
		if(e.which == 13) 
		{
			obtenerPae();
		}
	});
	
	$("#ventanaRegistrarPae").dialog(
	{
		autoOpen:false,
		height:300,
		width:750,
		modal:true,
		resizable:false,
		buttons: 
		[
			{
                text: "Cancelar",
                click: function() 
				{
                    $( this ).dialog( "close" );
                }
            },
            {
                text: "Registrar",
                click: $.noop,
                type: "submit",
                form: "frmPae",
				
            },
		],
		close: function() 
		{
			$('#formularioPae').html('');
		}
	});
	
	$("#ventanaEditarPae").dialog(
	{
		autoOpen:false,
		height:300,
		width:750,
		modal:true,
		resizable:false,
		buttons: 
		[
			{
                text: "Cancelar",
                click: function() 
				{
                    $( this ).dialog( "close" );
                }
            },
            {
                text: "Editar",
                click: $.noop,
                type: "submit",
                form: "frmPae",
				
            },
		],
		close: function() 
		{
			$('#obtenerRegistroPae').html('');
		}
	});
	
	$(document).on("click", ".ajax-pagPae > li a", function(eve)
	{
		eve.preventDefault();
		var element = "#obtenerPae";
		var link = $(this).attr('href');
		
		$.ajax(
		{
			url:link,
			type:"POST",
			data:
			{
				criterio:	$('#txtBuscarPae').val(),
			},
			dataType:"html",
			beforeSend:function(){$(element).html('<img src="'+ img_loader +'"/> Obteniendo registros...');},
			success:function(html,textStatus)
			{
				setTimeout(function()
				{
					$(element).html(html);},300);
				},
				error:function(datos){$(element).html('Error '+ datos).show('slow');
			}
		});
	});
});

function obtenerPae()
{
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerPae').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo registros');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerPae',
		data:
		{
			criterio:	$('#txtBuscarPae').val(),
			idCliente:	$('#txtIdClientePae').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerPae").html(data);
		},
		error:function(datos)
		{
			notify('Error al obtener los registros',500,5000,'error',30,3);
			$("#obtenerPae").html('');
		}
	});		
}

function formularioPae()
{
	$("#ventanaRegistrarPae").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioPae').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo el formulario');
		},
		type:"POST",
		url:base_url+'catalogos/formularioPae',
		data:
		{
			//idUsuario:idUsuario
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioPae").html(data);
			$('#txtPae').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3);
			$("#formularioPae").html('');
		}
	});		
}


function registrarPae()
{
	if(!confirm('¿Realmente desea continuar el registro?'))return
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoPae').html('<img src="'+base_url+'img/ajax-loader.gif"/> Registrando');
		},
		type:"POST",
		url:base_url+'catalogos/registrarPae',
		data: $('#frmPae').serialize()+'&idCliente='+$('#txtIdClientePae').val(),
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoPae').html('');
			
			switch(data)
			{
				case "0":
					notify('Error en el registro',500,5000,'error',30,3);
				break;
	
				case "1":
					notify('El registro ha sido correcto',500,5000,'',30,3);
					obtenerPae();
					$("#ventanaRegistrarPae").dialog('close');
					$("#txtRegistrosPae").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error en el registro',500,5000,'error',30,3);
			$("#registrandoPae").html('');
		}
	});		
}

function obtenerRegistroPae(idPae)
{
	$("#ventanaEditarPae").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerRegistroPae').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo la variable');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerRegistroPae',
		data:
		{
			idPae:idPae
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerRegistroPae").html(data);
			$('#txtPae').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener la variable',500,5000,'error',30,3);
			$("#obtenerRegistroPae").html('');
		}
	});		
}

function editarPae()
{
	if(!confirm('¿Realmente desea editar el registro?'))return
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#editandoPae').html('<img src="'+base_url+'img/ajax-loader.gif"/> Editando el registro');
		},
		type:"POST",
		url:base_url+'catalogos/editarPae',
		data: $('#frmPae').serialize(),
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoPae').html('');
			
			switch(data)
			{
				case "0":
					notify('Error al editar o no hubo cambios en el registro',500,5000,'error',30,3);
				
				break;
				case "1":
					notify('El registro se ha editado correctamente',500,5000,'',30,3);
					obtenerPae();
					$("#ventanaEditarPae").dialog('close');
					$("#txtRegistrosPae").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al editar el registro',500,5000,'error',30,3);
			$("#editandoPae").html('');
		}
	});		
}

function borrarPae(idPae)
{
	if(!confirm('¿Realmente desea borrar el registro?'))return;
		
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#procesandoPae').html('<img src="'+base_url+'img/ajax-loader.gif"/> Borrando el registro');
		},
		type:"POST",
		url:base_url+"catalogos/borrarPae",
		data:
		{
			"idPae":	idPae,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#procesandoPae').html('');
			
			switch(data)
			{
				case "0":
					notify('Error al borrar el registro',500,5000,'error',30,3);
				break;
				
				case "1":
					obtenerPae();
					notify('El registro se ha borrado correctamente',500,5000,'',30,3);
					$("#txtRegistrosPae").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al borrar el registro',500,5000,'error',30,3);
			$('#procesandoPae').html('');
		}
	});				  	  
}

function calcularPae()
{
	numero	= obtenerNumeros($('#txtNumeroEvaluaciones').val());
	precio	= obtenerNumeros($('#txtPrecioEstimado').val());
	
	total	= precio*numero;
	
	total	= redondear(total);
	
	$('#lblPrecioTotalEstimado').html('$'+total)
	$('#txtPrecioTotalEstimado').val(total)
}