//PARA NIVEL 1
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
$(document).ready(function()
{
	obtenerFuentes();

	$('#txtBuscarFuente').keypress(function(e)
	 {
		if(e.which == 13) 
		{
			obtenerFuentes();
		}
	});
	
	$("#ventanaRegistrarFuentes").dialog(
	{
		autoOpen:false,
		height:200,
		width:700,
		modal:true,
		resizable:false,
		buttons: 
		[
		 	{
                text: "Cancelar",
                click: function() 
				{
                    $( this ).dialog( "close" );
                }
            },
            {
                text: "Registrar",
                click: $.noop,
                type: "submit",
                form: "frmFuentes",
				
            },
        ],
		close: function() 
		{
			$("#formularioFuentes").html('');
		}
	});

	
	$(document).on("click", ".ajax-pagFuentes > li a", function(eve)
	{
		eve.preventDefault();
		var element = "#obtenerFuentes";
		var link = $(this).attr('href');
		
		$.ajax(
		{
			url:link,
			type:"POST",
			data:
			{
				criterio:	$('#txtBuscarFuente').val(),
			},
			dataType:"html",
			beforeSend:function(){$(element).html('<img src="'+ img_loader +'"/> Obteniendo registros...');},
			success:function(html,textStatus)
			{
				setTimeout(function()
				{
					$(element).html(html);},300);
				},
				error:function(datos){$(element).html('Error '+ datos).show('slow');
			}
		});
	});
});

function obtenerFuentes()
{
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerFuentes').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo registros');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerFuentes',
		data:
		{
			criterio:	$('#txtBuscarFuente').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerFuentes").html(data);
		},
		error:function(datos)
		{
			notify('Error al obtener los registros',500,5000,'error',30,3);
			$("#obtenerFuentes").html('');
		}
	});		
}

function formularioFuentes()
{
	$("#ventanaRegistrarFuentes").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioFuentes').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo el formulario');
		},
		type:"POST",
		url:base_url+'catalogos/formularioFuentes',
		data:
		{
			//idUsuario:idUsuario
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioFuentes").html(data);
			$('#txtDependencia').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3);
			$("#formularioFuentes").html('');
		}
	});		
}


function registrarFuente()
{
	if (!confirm("¿Realmente desea continuar el registro?")) return;

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoFuentes').html('<img src="'+base_url+'img/ajax-loader.gif"/> Registrando');
		},
		type:"POST",
		url:base_url+'catalogos/registrarFuente',
		data:$("#frmFuentes").serialize(),
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoFuentes').html('');
			
			switch(eval(data)[0])
			{
				case "0":
					notify('Error en el registro',500,5000,'error',30,3);
				break;
	
				case "1":
					notify('El registro ha sido correcto',500,5000,'',30,3);
					obtenerFuentes();
					$("#ventanaRegistrarFuentes").dialog('close');
					$("#txtRegistrosFuentes").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error en el registro',500,5000,'error',30,3);
			$("#registrandoFuentes").html('');
		}
	});		
}

function obtenerFuente(idFuente)
{
	$("#ventanaRegistrarFuentes").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioFuentes').html('<img src="'+base_url+'img/ajax-loader.gif"/> Preparando el formulario');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerFuente',
		data:
		{
			idFuente:idFuente
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioFuentes").html(data);
			$('#txtNombreFuente').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3);
			$("#formularioFuentes").html('');
		}
	});		
}

function editarFuente()
{
	if(!confirm("¿Realmente desea continuar el registro?")) return;

	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoFuentes').html('<img src="'+base_url+'img/ajax-loader.gif"/> Registrando');
		},
		type:"POST",
		url:base_url+'catalogos/editarFuente',
		data:$("#frmFuentes").serialize(),
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoFuentes').html('');
			
			switch(eval(data)[0])
			{
				case "0":
					notify('Error en el registro',500,5000,'error',30,3);
				break;
	
				case "1":
					notify('El registro ha sido correcto',500,5000,'',30,3);
					obtenerFuentes();
					$("#ventanaRegistrarFuentes").dialog('close');
					$("#txtRegistrosFuentes").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error en el registro',500,5000,'error',30,3);
			$("#registrandoFuentes").html('');
		}
	});		
}

function borrarFuente(idFuente)
{
	if(!confirm('¿Realmente desea borrar el registro?'))return;
		
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#procesandoFuentes').html('<img src="'+base_url+'img/ajax-loader.gif"/> Borrando el registro');
		},
		type:"POST",
		url:base_url+"catalogos/borrarFuente",
		data:
		{
			"idFuente":	idFuente,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#procesandoFuentes').html('');
			
			switch(eval(data)[0])
			{
				case "0":
					notify('Error al borrar el registro',500,5000,'error',30,3);
				break;
				
				case "1":
					obtenerFuentes();
					notify('El registro se ha borrado correctamente',500,5000,'',30,3);
					$("#txtRegistrosFuentes").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al borrar el registro',500,5000,'error',30,3);
			$('#procesandoFuentes').html('');
		}
	});				  	  
}