//PARA NIVEL 1
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
$(document).ready(function()
{
	$('#txtBuscarDependencia').keypress(function(e)
	 {
		if(e.which == 13) 
		{
			obtenerDependencias();
		}
	});
	
	$("#ventanaRegistrarDependencia").dialog(
	{
		autoOpen:false,
		height:200,
		width:750,
		modal:true,
		resizable:false,
		buttons: 
		{
			Cancelar: function() 
			{
				$(this).dialog('close');				 
			},
			'Registrar': function() 
			{
				registrarDependencia();
			},
		},
		close: function() 
		{
			$('#formularioDependencias').html('');
		}
	});
	
	$("#ventanaEditarDependencia").dialog(
	{
		autoOpen:false,
		height:200,
		width:750,
		modal:true,
		resizable:false,
		buttons: 
		{
			Cancelar: function() 
			{
				$(this).dialog('close');				 
			},
			'Editar': function() 
			{
				editarDependencia();
			},
		},
		close: function() 
		{
			$('#obtenerDependencia').html('');
		}
	});
	
	$(document).on("click", ".ajax-pagDependencias > li a", function(eve)
	{
		eve.preventDefault();
		var element = "#obtenerDependencias";
		var link = $(this).attr('href');
		
		$.ajax(
		{
			url:link,
			type:"POST",
			data:
			{
				criterio:	$('#txtBuscarDependencia').val(),
			},
			dataType:"html",
			beforeSend:function(){$(element).html('<img src="'+ img_loader +'"/> Obteniendo registros...');},
			success:function(html,textStatus)
			{
				setTimeout(function()
				{
					$(element).html(html);},300);
				},
				error:function(datos){$(element).html('Error '+ datos).show('slow');
			}
		});
	});
});

function obtenerDependencias()
{
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerDependencias').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo registros');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerDependencias',
		data:
		{
			criterio:	$('#txtBuscarDependencia').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerDependencias").html(data);
		},
		error:function(datos)
		{
			notify('Error al obtener los registros',500,5000,'error',30,3);
			$("#obtenerDependencias").html('');
		}
	});		
}

function formularioDependencias()
{
	$("#ventanaRegistrarDependencia").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioDependencias').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo el formulario');
		},
		type:"POST",
		url:base_url+'catalogos/formularioDependencias',
		data:
		{
			//idUsuario:idUsuario
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioDependencias").html(data);
			$('#txtDependencia').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3);
			$("#formularioDependencias").html('');
		}
	});		
}


function registrarDependencia()
{
	if(!camposVacios($('#txtDependencia').val()))
	{
		notify('El nombre es incorrecto',500,5000,'error',30,3);
		return;
	}
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoDependencia').html('<img src="'+base_url+'img/ajax-loader.gif"/> Registrando');
		},
		type:"POST",
		url:base_url+'catalogos/registrarDependencia',
		data:
		{
			nombre:	$('#txtDependencia').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoDependencia').html('');
			
			switch(data)
			{
				case "0":
					notify('Error en el registro',500,5000,'error',30,3);
				break;
	
				case "1":
					notify('El registro ha sido correcto',500,5000,'',30,3);
					obtenerDependencias();
					$("#ventanaRegistrarDependencia").dialog('close');
					$("#txtRegistrosDependencias").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error en el registro',500,5000,'error',30,3);
			$("#registrandoDependencia").html('');
		}
	});		
}

function obtenerDependencia(idDependencia)
{
	$("#ventanaEditarDependencia").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerDependencia').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo la variable');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerDependencia',
		data:
		{
			idDependencia:idDependencia
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerDependencia").html(data);
			$('#txtDependencia').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener la variable',500,5000,'error',30,3);
			$("#obtenerDependencia").html('');
		}
	});		
}

function editarDependencia()
{
	if(!camposVacios($('#txtDependencia').val()))
	{
		notify('El nombre es incorrecto',500,5000,'error',30,3);
		return;
	}
	
	if(!confirm('¿Realmente desea editar el registro?'))return
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#editandoDependencia').html('<img src="'+base_url+'img/ajax-loader.gif"/> Editando el registro');
		},
		type:"POST",
		url:base_url+'catalogos/editarDependencia',
		data:
		{
			nombre:		$('#txtDependencia').val(),
			idDependencia:	$('#txtIdDependencia').val()
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoDependencia').html('');
			
			switch(data)
			{
				case "0":
					notify('Error al editar o no hubo cambios en el registro',500,5000,'error',30,3);
				
				break;
				case "1":
					notify('El registro se ha editado correctamente',500,5000,'',30,3);
					obtenerDependencias();
					$("#ventanaEditarDependencia").dialog('close');
					$("#txtRegistrosDependencias").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al editar el registro',500,5000,'error',30,3);
			$("#editandoDependencia").html('');
		}
	});		
}

function borrarDependencia(idDependencia)
{
	if(!confirm('¿Realmente desea borrar el registro?'))return;
		
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#procesandoDependencia').html('<img src="'+base_url+'img/ajax-loader.gif"/> Borrando el registro');
		},
		type:"POST",
		url:base_url+"catalogos/borrarDependencia",
		data:
		{
			"idDependencia":	idDependencia,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#procesandoDependencia').html('');
			
			switch(data)
			{
				case "0":
					notify('Error al borrar el registro',500,5000,'error',30,3);
				break;
				
				case "1":
					obtenerDependencias();
					notify('El registro se ha borrado correctamente',500,5000,'',30,3);
					$("#txtRegistrosDependencias").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al borrar el registro',500,5000,'error',30,3);
			$('#procesandoDependencia').html('');
		}
	});				  	  
}