//PARA NIVEL 1
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
$(document).ready(function()
{
	$('#txtBuscarConvenio').keypress(function(e)
	 {
		if(e.which == 13) 
		{
			obtenerConvenios();
		}
	});
	
	$("#ventanaRegistrarConvenio").dialog(
	{
		autoOpen:false,
		height:200,
		width:750,
		modal:true,
		resizable:false,
		buttons: 
		{
			Cancelar: function() 
			{
				$(this).dialog('close');				 
			},
			'Registrar': function() 
			{
				registrarConvenio();
			},
		},
		close: function() 
		{
			$('#formularioConvenios').html('');
		}
	});
	
	$("#ventanaEditarConvenio").dialog(
	{
		autoOpen:false,
		height:200,
		width:750,
		modal:true,
		resizable:false,
		buttons: 
		{
			Cancelar: function() 
			{
				$(this).dialog('close');				 
			},
			'Editar': function() 
			{
				editarConvenio();
			},
		},
		close: function() 
		{
			$('#obtenerConvenio').html('');
		}
	});
	
	$(document).on("click", ".ajax-pagConvenios > li a", function(eve)
	{
		eve.preventDefault();
		var element = "#obtenerConvenios";
		var link = $(this).attr('href');
		
		$.ajax(
		{
			url:link,
			type:"POST",
			data:
			{
				criterio:	$('#txtBuscarConvenio').val(),
			},
			dataType:"html",
			beforeSend:function(){$(element).html('<img src="'+ img_loader +'"/> Obteniendo registros...');},
			success:function(html,textStatus)
			{
				setTimeout(function()
				{
					$(element).html(html);},300);
				},
				error:function(datos){$(element).html('Error '+ datos).show('slow');
			}
		});
	});
});

function obtenerConvenios()
{
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerConvenios').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo registros');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerConvenios',
		data:
		{
			criterio:	$('#txtBuscarConvenio').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerConvenios").html(data);
		},
		error:function(datos)
		{
			notify('Error al obtener los registros',500,5000,'error',30,3);
			$("#obtenerConvenios").html('');
		}
	});		
}

function formularioConvenios()
{
	$("#ventanaRegistrarConvenio").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioConvenios').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo el formulario');
		},
		type:"POST",
		url:base_url+'catalogos/formularioConvenios',
		data:
		{
			//idUsuario:idUsuario
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioConvenios").html(data);
			$('#txtConvenio').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3);
			$("#formularioConvenios").html('');
		}
	});		
}


function registrarConvenio()
{
	if(!camposVacios($('#txtConvenio').val()))
	{
		notify('El nombre es incorrecto',500,5000,'error',30,3);
		return;
	}
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoConvenio').html('<img src="'+base_url+'img/ajax-loader.gif"/> Registrando');
		},
		type:"POST",
		url:base_url+'catalogos/registrarConvenio',
		data:
		{
			nombre:	$('#txtConvenio').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoConvenio').html('');
			
			switch(data)
			{
				case "0":
					notify('Error en el registro',500,5000,'error',30,3);
				break;
	
				case "1":
					notify('El registro ha sido correcto',500,5000,'',30,3);
					obtenerConvenios();
					$("#ventanaRegistrarConvenio").dialog('close');
					$("#txtRegistrosConvenios").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error en el registro',500,5000,'error',30,3);
			$("#registrandoConvenio").html('');
		}
	});		
}

function obtenerConvenio(idConvenio)
{
	$("#ventanaEditarConvenio").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerConvenio').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo la variable');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerConvenio',
		data:
		{
			idConvenio:idConvenio
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerConvenio").html(data);
			$('#txtConvenio').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener la variable',500,5000,'error',30,3);
			$("#obtenerConvenio").html('');
		}
	});		
}

function editarConvenio()
{
	if(!camposVacios($('#txtConvenio').val()))
	{
		notify('El nombre es incorrecto',500,5000,'error',30,3);
		return;
	}
	
	if(!confirm('¿Realmente desea editar el registro?'))return
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#editandoConvenio').html('<img src="'+base_url+'img/ajax-loader.gif"/> Editando el registro');
		},
		type:"POST",
		url:base_url+'catalogos/editarConvenio',
		data:
		{
			nombre:		$('#txtConvenio').val(),
			idConvenio:	$('#txtIdConvenio').val()
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoConvenio').html('');
			
			switch(data)
			{
				case "0":
					notify('Error al editar o no hubo cambios en el registro',500,5000,'error',30,3);
				
				break;
				case "1":
					notify('El registro se ha editado correctamente',500,5000,'',30,3);
					obtenerConvenios();
					$("#ventanaEditarConvenio").dialog('close');
					$("#txtRegistrosConvenios").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al editar el registro',500,5000,'error',30,3);
			$("#editandoConvenio").html('');
		}
	});		
}

function borrarConvenio(idConvenio)
{
	if(!confirm('¿Realmente desea borrar el registro?'))return;
		
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#procesandoConvenio').html('<img src="'+base_url+'img/ajax-loader.gif"/> Borrando el registro');
		},
		type:"POST",
		url:base_url+"catalogos/borrarConvenio",
		data:
		{
			"idConvenio":	idConvenio,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#procesandoConvenio').html('');
			
			switch(data)
			{
				case "0":
					notify('Error al borrar el registro',500,5000,'error',30,3);
				break;
				
				case "1":
					obtenerConvenios();
					notify('El registro se ha borrado correctamente',500,5000,'',30,3);
					$("#txtRegistrosConvenios").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al borrar el registro',500,5000,'error',30,3);
			$('#procesandoConvenio').html('');
		}
	});				  	  
}