//PARA NIVEL 1
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
$(document).ready(function()
{
	$('#txtBuscarCargo').keypress(function(e)
	 {
		if(e.which == 13) 
		{
			obtenerCargos();
		}
	});
	
	$("#ventanaRegistrarCargo").dialog(
	{
		autoOpen:false,
		height:200,
		width:750,
		modal:true,
		resizable:false,
		buttons: 
		{
			Cancelar: function() 
			{
				$(this).dialog('close');				 
			},
			'Registrar': function() 
			{
				registrarCargo();
			},
		},
		close: function() 
		{
			$('#formularioCargos').html('');
		}
	});
	
	$("#ventanaEditarCargo").dialog(
	{
		autoOpen:false,
		height:200,
		width:750,
		modal:true,
		resizable:false,
		buttons: 
		{
			Cancelar: function() 
			{
				$(this).dialog('close');				 
			},
			'Editar': function() 
			{
				editarCargo();
			},
		},
		close: function() 
		{
			$('#obtenerCargo').html('');
		}
	});
	
	$(document).on("click", ".ajax-pagCargos > li a", function(eve)
	{
		eve.preventDefault();
		var element = "#obtenerCargos";
		var link = $(this).attr('href');
		
		$.ajax(
		{
			url:link,
			type:"POST",
			data:
			{
				criterio:	$('#txtBuscarCargo').val(),
			},
			dataType:"html",
			beforeSend:function(){$(element).html('<img src="'+ img_loader +'"/> Obteniendo registros...');},
			success:function(html,textStatus)
			{
				setTimeout(function()
				{
					$(element).html(html);},300);
				},
				error:function(datos){$(element).html('Error '+ datos).show('slow');
			}
		});
	});
});

function obtenerCargos()
{
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerCargos').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo registros');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerCargos',
		data:
		{
			criterio:	$('#txtBuscarCargo').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerCargos").html(data);
		},
		error:function(datos)
		{
			notify('Error al obtener los registros',500,5000,'error',30,3);
			$("#obtenerCargos").html('');
		}
	});		
}

function formularioCargos()
{
	$("#ventanaRegistrarCargo").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#formularioCargos').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo el formulario');
		},
		type:"POST",
		url:base_url+'catalogos/formularioCargos',
		data:
		{
			//idUsuario:idUsuario
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#formularioCargos").html(data);
			$('#txtCargo').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener el formulario',500,5000,'error',30,3);
			$("#formularioCargos").html('');
		}
	});		
}


function registrarCargo()
{
	if(!camposVacios($('#txtCargo').val()))
	{
		notify('El nombre es incorrecto',500,5000,'error',30,3);
		return;
	}
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#registrandoCargo').html('<img src="'+base_url+'img/ajax-loader.gif"/> Registrando');
		},
		type:"POST",
		url:base_url+'catalogos/registrarCargo',
		data:
		{
			nombre:	$('#txtCargo').val(),
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#registrandoCargo').html('');
			
			switch(data)
			{
				case "0":
					notify('Error en el registro',500,5000,'error',30,3);
				break;
	
				case "1":
					notify('El registro ha sido correcto',500,5000,'',30,3);
					obtenerCargos();
					$("#ventanaRegistrarCargo").dialog('close');
					$("#txtRegistrosCargos").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error en el registro',500,5000,'error',30,3);
			$("#registrandoCargo").html('');
		}
	});		
}

function obtenerCargo(idCargo)
{
	$("#ventanaEditarCargo").dialog('open');
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#obtenerCargo').html('<img src="'+base_url+'img/ajax-loader.gif"/> Obteniendo la variable');
		},
		type:"POST",
		url:base_url+'catalogos/obtenerCargo',
		data:
		{
			idCargo:idCargo
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$("#obtenerCargo").html(data);
			$('#txtCargo').focus();
		},
		error:function(datos)
		{
			notify('Error al obtener la variable',500,5000,'error',30,3);
			$("#obtenerCargo").html('');
		}
	});		
}

function editarCargo()
{
	if(!camposVacios($('#txtCargo').val()))
	{
		notify('El nombre es incorrecto',500,5000,'error',30,3);
		return;
	}
	
	if(!confirm('¿Realmente desea editar el registro?'))return
	
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#editandoCargo').html('<img src="'+base_url+'img/ajax-loader.gif"/> Editando el registro');
		},
		type:"POST",
		url:base_url+'catalogos/editarCargo',
		data:
		{
			nombre:		$('#txtCargo').val(),
			idCargo:	$('#txtIdCargo').val()
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#editandoCargo').html('');
			
			switch(data)
			{
				case "0":
					notify('Error al editar o no hubo cambios en el registro',500,5000,'error',30,3);
				
				break;
				case "1":
					notify('El registro se ha editado correctamente',500,5000,'',30,3);
					obtenerCargos();
					$("#ventanaEditarCargo").dialog('close');
					$("#txtRegistrosCargos").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al editar el registro',500,5000,'error',30,3);
			$("#editandoCargo").html('');
		}
	});		
}

function borrarCargo(idCargo)
{
	if(!confirm('¿Realmente desea borrar el registro?'))return;
		
	$.ajax(
	{
		async:true,
		beforeSend:function(objeto)
		{
			$('#procesandoCargo').html('<img src="'+base_url+'img/ajax-loader.gif"/> Borrando el registro');
		},
		type:"POST",
		url:base_url+"catalogos/borrarCargo",
		data:
		{
			"idCargo":	idCargo,
		},
		datatype:"html",
		success:function(data, textStatus)
		{
			$('#procesandoCargo').html('');
			
			switch(data)
			{
				case "0":
					notify('Error al borrar el registro',500,5000,'error',30,3);
				break;
				
				case "1":
					obtenerCargos();
					notify('El registro se ha borrado correctamente',500,5000,'',30,3);
					$("#txtRegistrosCargos").val(1);
				break;
			}
		},
		error:function(datos)
		{
			notify('Error al borrar el registro',500,5000,'error',30,3);
			$('#procesandoCargo').html('');
		}
	});				  	  
}