<?php
class Crm_modelo extends CI_Model
{
	protected $_fecha_actual;
	protected $_table;
	protected $idLicencia;
	protected $resultado;
	protected $_user_id;

	function __construct()
	{
		parent::__construct();
		$this->config->load('datatables',TRUE);
		$this->_table 			= $this->config->item('datatables');

        $this->_user_id 		= $this->session->userdata('id');
		$this->idLicencia 		= $this->session->userdata('idLicencia');

		$datestring   			= "%Y-%m-%d %H:%i:%s";
		$this->_fecha_actual 	= mdate($datestring,now());
		$this->resultado		="1";
	}
	
	public function registrarCrm()
	{
		$fecha			= trim($this->input->post('fecha'));
		$idStatus		= $this->input->post('idStatus');
		$comentarios	= $this->input->post('comentarios');
		$idResponsable	= $this->input->post('idResponsable');
		
		$data=array
		(
			'comentarios'		=> $comentarios,
			'bitacora' 			=> $this->input->post('bitacora'),
			'email' 			=> $this->input->post('email'),
			'fecha'				=> $fecha,
			'idCliente' 		=> $this->input->post('idCliente'),
			'idStatus' 			=> $idStatus,
			'idServicio' 		=> $this->input->post('idServicio'),
			'idResponsable' 	=> $idResponsable,
			#'monto' 			=> $this->input->post('monto'),
			'fechaCierre' 		=> trim($this->input->post('fechaCierre')),
			'lugar'				=> $this->input->post('lugar'),
			'tipo' 				=> 0,
			'idLicencia'		=> $this->idLicencia,
			'idTiempo'			=> $this->input->post('idTiempo'),
			
			'idContacto'		=> $this->input->post('idContacto'),
		);
		
		$this->db->insert('seguimiento', $data);
		
		if($idStatus==4)
		{
			$this->enviarCorreoLlamada($idResponsable,$comentarios,$fecha);
		}
		
		return ($this->db->affected_rows() >= 1)? "1" : "0";
	}
	
	//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	//CRM PARA COTIZACIONES Y VENTAS --------- CLIENTES
	//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	public function obtenerUltimoSeguimientoCotizacion($idCotizacion,$permiso=0)
	{
		$sql="select a.*, b.nombre as servicio,
		d.nombre as status, d.color, d.idStatusIgual,
		concat(c.nombre,' ',c.apellidoPaterno,' ', c.apellidoMaterno) as responsable
		from seguimiento as a
		inner join seguimiento_servicios as b
		on a.idServicio=b.idServicio
		inner join usuarios as c
		on a.idResponsable=c.idUsuario
		inner join seguimiento_status as d
		on d.idStatus=a.idStatus
		where a.idCotizacion='$idCotizacion' ";
		
		$sql.=$permiso==0?" and a.idResponsable='$this->_user_id' ":'';
		
		$sql.=" order by fecha desc
		limit 1 ";	
		
		return $this->db->query($sql)->row();
	}
	
	public function obtenerUltimoSeguimientoVenta($idCotizacion,$permiso=0)
	{
		$sql="select a.*, b.nombre as servicio,
		d.nombre as status, d.color, d.idStatusIgual,
		concat(c.nombre,' ',c.apellidoPaterno,' ', c.apellidoMaterno) as responsable
		from seguimiento as a
		inner join seguimiento_servicios as b
		on a.idServicio=b.idServicio
		inner join usuarios as c
		on a.idResponsable=c.idUsuario
		inner join seguimiento_status as d
		on d.idStatus=a.idStatus
		where a.idVenta='$idCotizacion' ";
		
		$sql.=$permiso==0?" and a.idResponsable='$this->_user_id' ":'';
		
		$sql.=" order by fecha desc
		limit 1 ";	
		
		#echo $sql; exit;
		return $this->db->query($sql)->row();
	}
	
	public function obtenerClienteSeguimientoCotizacion($idCotizacion)
	{
		$sql=" select a.idCliente, b.empresa as  cliente, c.serie
		from seguimiento as a
		inner join clientes as b
		on a.idCliente=b.idCliente
		inner join cotizaciones as c
		on a.idCotizacion=c.idCotizacion
		where a.idCotizacion='$idCotizacion'
		order by a.fecha desc
		limit 1 ";	
		
		return $this->db->query($sql)->row();
	}
	
	public function contarSeguimientoServicio($idCliente,$inicio,$fin,$idServicio,$idCotizacion=0,$permiso=0)
	{
		$sql=" select a.idSeguimiento
		from seguimiento as a
		inner join seguimiento_servicios as b
		on a.idServicio=b.idServicio
		inner join usuarios as c
		on a.idResponsable=c.idUsuario
		where a.idServicio='$idServicio'
		and tipo=0
		and a.idLicencia='$this->idLicencia'  ";	
		
		$sql.=$idCliente>0?"and  a.idCliente='$idCliente'":'';
		if($idServicio==1) $sql.=$idCotizacion>0?"and a.idCotizacion='$idCotizacion'":'';
		if($idServicio==2) $sql.=$idCotizacion>0?"and a.idVenta='$idCotizacion'":'';
		$sql.=$permiso==0?" and a.idResponsable='$this->_user_id' ":'';
		
		
		#$sql.=" and a.fecha between '$inicio' and '$fin' ";
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerSeguimientoServicio($numero,$limite,$idCliente,$inicio,$fin,$idServicio,$idCotizacion,$permiso=0)
	{
		$sql=" select a.*, b.nombre as servicio,
		concat(c.nombre,' ', c.apellidoPaterno,' ',c.apellidoMaterno) as responsable,
		d.nombre as status, d.color, d.idStatusIgual,
		
		(select concat('Folio: ',g.folio, ', Serie: ', g.serie) from cotizaciones as g where g.idCotizacion=a.idCotizacion) as cotizacion,
		(select concat('Folio: ',g.folio, ', Orden: ', g.ordenCompra) from cotizaciones as g where g.idCotizacion=a.idVenta) as venta
		
		from seguimiento as a
		inner join seguimiento_servicios as b
		on a.idServicio=b.idServicio
		inner join usuarios as c
		on a.idResponsable=c.idUsuario
		
		inner join seguimiento_status as d
		on a.idStatus=d.idStatus
		
		where a.idServicio='$idServicio'
		and a.tipo=0
		and a.idLicencia='$this->idLicencia' ";	
		
		$sql.=$idCliente>0?"and  a.idCliente='$idCliente'":'';
		if($idServicio==1) $sql.=$idCotizacion>0?"and a.idCotizacion='$idCotizacion'":'';
		if($idServicio==2) $sql.=$idCotizacion>0?"and a.idVenta='$idCotizacion'":'';
		$sql.=$permiso==0?" and a.idResponsable='$this->_user_id' ":'';
		
		#$sql.=" and a.fecha between '$inicio' and '$fin' ";
		
		$sql .= " order by fecha desc
		limit $limite,$numero ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerFolioSeguimientoCliente()
	{
		$sql=" select coalesce(max(folio),0) as folio
		from seguimiento
		where idLicencia='$this->idLicencia' ";	

		return $this->db->query($sql)->row()->folio+1;
	}
	
	//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	//CRM PARA COMPRAS --------- PROVEEDORES
	//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
	public function obtenerUltimoSeguimientoCompra($idCompra)
	{
		$sql=" select a.*, b.nombre as servicio,
		d.nombre as status, d.color, d.idStatusIgual,
		concat(c.nombre,' ',c.apellidoPaterno,' ', c.apellidoMaterno) as responsable
		from proveedores_seguimiento as a
		inner join seguimiento_servicios as b
		on a.idServicio=b.idServicio
		inner join usuarios as c
		on a.idResponsable=c.idUsuario
		inner join seguimiento_status as d
		on d.idStatus=a.idStatus
		where a.idCompra='$idCompra'
		and a.idLicencia='$this->idLicencia'
		order by fecha desc
		limit 1 ";	
		
		return $this->db->query($sql)->row();
	}
	
	public function contarSeguimientoServicioCompras($idProveedor,$inicio,$fin,$idServicio,$idCompra=0)
	{
		$sql=" select a.idSeguimiento
		from proveedores_seguimiento as a
		inner join seguimiento_servicios as b
		on a.idServicio=b.idServicio
		inner join usuarios as c
		on a.idResponsable=c.idUsuario
		where a.idServicio='$idServicio'
		and tipo=0 
		and a.idLicencia='$this->idLicencia'";	
		
		$sql.=$idProveedor>0?"and  a.idProveedor='$idProveedor'":'';
		$sql.=$idCompra>0?"and a.idCompra='$idCompra'":'';
		
		
		#$sql.=" and a.fecha between '$inicio' and '$fin' ";
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerSeguimientoServicioCompras($numero,$limite,$idProveedor,$inicio,$fin,$idServicio,$idCompra)
	{
		$sql=" select a.*, b.nombre as servicio,
		concat(c.nombre,' ', c.apellidoPaterno,' ',c.apellidoMaterno) as responsable,
		d.nombre as status, d.color, d.idStatusIgual,
		
		(select concat(g.nombre) from compras as g where g.idCompras=a.idCompra) as venta
		
		from proveedores_seguimiento as a
		inner join seguimiento_servicios as b
		on a.idServicio=b.idServicio
		inner join usuarios as c
		on a.idResponsable=c.idUsuario
		
		inner join seguimiento_status as d
		on a.idStatus=d.idStatus
		
		where a.idServicio='$idServicio'
		and a.tipo=0
		and a.idLicencia='$this->idLicencia' ";	
		
		$sql.=$idProveedor>0?"and  a.idProveedor='$idProveedor'":'';
		$sql.=$idCompra>0?"and a.idCompra='$idCompra'":'';
		
		#$sql.=" and a.fecha between '$inicio' and '$fin' ";
		
		$sql .= " order by fecha desc
		limit $limite,$numero ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerFolioSeguimientoProveedor()
	{
		$sql=" select coalesce(max(folio),0) as folio
		from proveedores_seguimiento
		where idLicencia='$this->idLicencia' ";	

		return $this->db->query($sql)->row()->folio+1;
	}
	
	public function registrarDetalleSeguimiento()
	{
		$data=array
		(
			'fechaRegistro'		=> $this->_fecha_actual,
			'idSeguimiento' 	=> $this->input->post('txtIdSeguimiento'),
			'fecha' 			=> $this->input->post('txtFechaSeguimiento'),
			'hora' 				=> $this->input->post('txtHoraSeguimiento'),
			'observaciones' 	=> $this->input->post('txtObservacionesSeguimiento'),
			'idUsuario' 		=> $this->input->post('selectResponsableDetalle'),
		);
		
		$this->db->insert('seguimiento_detalles', $data);

		return ($this->db->affected_rows() >= 1)? array('1') : array('0') ;
	}
	
	public function obtenerDetallesSeguimiento($idSeguimiento)
	{
		$sql=" select a.*,
		(select  concat(b.nombre,' ', b.apellidoPaterno,' ',b.apellidoMaterno)  from usuarios as b where b.idUsuario=a.idUsuario) as usuario
		from seguimiento_detalles as a
		where a.idSeguimiento='$idSeguimiento' ";	

		return $this->db->query($sql)->result();
	}
	
	public function borrarDetalleSeguimiento($idDetalle)
	{
		$this->db->where('idDetalle', $idDetalle);
		$this->db->delete('seguimiento_detalles');

		return ($this->db->affected_rows() >= 1)? array('1') : array('0') ;
	}
	
	//EDITAR EL RESPONSABLE
	//=============================================================================================================
	public function editarResponsable()
	{
		$data=array
		(
			'idResponsable' 		=> $this->input->post('selectResponsable'),
		);
		
		$this->db->where('idSeguimiento', $this->input->post('txtIdSeguimiento'));
		$this->db->update('seguimiento', $data);
		
		$this->enviarCorreoResponsable($this->input->post('txtIdSeguimiento'));

		return ($this->db->affected_rows() >= 1)? array('1') : array('0') ;
	}
	
	public function enviarCorreoResponsable($idSeguimiento)
	{
		if(!empty($_POST))
		{
			$seguimiento	= $this->clientes->obtenerSeguimiento($idSeguimiento);
			
			$usuario		= $this->clientes->obtenerUsuario($seguimiento->idResponsable);
			$cliente		= $this->clientes->obtenerCliente($seguimiento->idCliente);
			$emisor			= $this->clientes->obtenerUsuario($seguimiento->idUsuarioRegistro);			
			
			if($emisor==null)
			{
				$emisor			= $this->clientes->obtenerUsuario($this->_user_id);	
			}
			
			$asunto			= 'Tienes un seguimiento pendiente en el CRM';
			
			/*$mensaje		=' <strong>Responsable: </strong>'.$usuario->nombre.'<br />';
			$mensaje		.= '<strong>Fecha: </strong>'.obtenerFechaMesCortoHora($fecha).'<br />';
			$mensaje		.= '<strong>Comentarios: </strong> '.$seguimiento->comentarios.'<br />';
			$mensaje		.= '<strong>Cliente: </strong> '.$cliente->empresa;*/

			$mensaje		=nl2br($usuario->nombre);
			$mensaje		.='<br /><br />Atte.<br />'.$emisor->nombre;
			
			$this->load->library('email');
			$this->email->from($emisor->correo,$emisor->nombre);
			$this->email->to($usuario->correo,$usuario->nombre);
			$this->email->subject($asunto);
			$this->email->message($mensaje);
			
			if (!$this->email->send())
			{
				#print("0");
			}
			else
			{
				#print("1");
			}
				
		}
		else
		{
			#print("2");
		}
	}
	
}
