<?php
PHPExcel_Cell::setValueBinder( new PHPExcel_Cell_AdvancedValueBinder() );
	
$excel = new PHPExcel();

$excel
->getProperties()
->setCreator(empresa)
->setLastModifiedBy(empresa)
->setTitle(empresa)
->setSubject(empresa)
->setDescription(empresa)
->setKeywords(empresa)
->setCategory(empresa);

$excel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
$excel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
$excel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
$excel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
$excel->getActiveSheet()->getColumnDimension('F')->setWidth(35);
$excel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('H')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
$excel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
$excel->getActiveSheet()->getColumnDimension('K')->setWidth(25);
$excel->getActiveSheet()->getColumnDimension('L')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('M')->setWidth(30);

$i=1;

$excel->setActiveSheetIndex(0)->mergeCells('A'.$i.':M'.$i.'');
$excel->getActiveSheet()->getStyle('A'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$excel->getActiveSheet()->getStyle('A'.$i.':M'.$i)->getFont()->setName('Arial Black');
$excel->getActiveSheet()->setCellValue('A'.$i, 'REPORTE GENERAL');

$i++;
$excel->getActiveSheet()->getStyle('A'.$i.':M'.$i)->getFont()->setName('Arial Black');

$excel->getActiveSheet()->setCellValue('A'.$i, 'Fecha registro');
$excel->getActiveSheet()->setCellValue('B'.$i, 'Fecha inscrito');
$excel->getActiveSheet()->setCellValue('C'.$i, 'Prospecto');
$excel->getActiveSheet()->setCellValue('D'.$i, 'Email');
$excel->getActiveSheet()->setCellValue('E'.$i, 'Teléfono');
$excel->getActiveSheet()->setCellValue('F'.$i, 'Contacto');
$excel->getActiveSheet()->setCellValue('G'.$i, 'Programa');
$excel->getActiveSheet()->setCellValue('H'.$i, 'Campaña');
$excel->getActiveSheet()->setCellValue('I'.$i, 'Estatus');
$excel->getActiveSheet()->setCellValue('J'.$i, 'Seguimientos');
$excel->getActiveSheet()->setCellValue('K'.$i, 'Promotor');

$excel->getActiveSheet()->setCellValue('L'.$i, 'Comentario 1');
$excel->getActiveSheet()->setCellValue('M'.$i, 'Comentario 2');


$i++;

foreach($prospectos as $row)
{
	$seguimientos	= $this->crm->obtenerUltimosSeguimientos($row->idCliente);
	
	$excel->getActiveSheet()->getCell('A'.$i)->setValueExplicit(obtenerFechaMesCortoHora($row->fechaRegistro), PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('B'.$i)->setValueExplicit(obtenerFechaMesCortoHora($row->fechaInscrito), PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('C'.$i)->setValueExplicit($row->nombre.' '.$row->paterno.' '.$row->materno, PHPExcel_Cell_DataType::TYPE_STRING);
	
	$excel->getActiveSheet()->getCell('D'.$i)->setValueExplicit($row->email, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('E'.$i)->setValueExplicit($row->telefono.' '.$row->movil, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('F'.$i)->setValueExplicit($row->fuente, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('G'.$i)->setValueExplicit($row->programa, PHPExcel_Cell_DataType::TYPE_STRING);
	#$excel->getActiveSheet()->getCell('G'.$i)->setValueExplicit($row->campana, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->setCellValue('H'.$i, $row->campana." \n\n".$row->campanaOriginal);
	
	
	$excel->getActiveSheet()->getCell('I'.$i)->setValueExplicit($row->prospecto=='1'?'Prospecto':'Alumno', PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->setCellValue('J'.$i, $row->numeroSeguimientos);
	$excel->getActiveSheet()->getCell('K'.$i)->setValueExplicit($row->promotor, PHPExcel_Cell_DataType::TYPE_STRING);
	
	$excel->getActiveSheet()->setCellValue('L'.$i, isset($seguimientos[0]->observaciones)?$seguimientos[0]->observaciones:'');
	$excel->getActiveSheet()->setCellValue('M'.$i, isset($seguimientos[1]->observaciones)?$seguimientos[1]->observaciones:'');
	
	$excel->getActiveSheet()->getStyle('J'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	
	$i++;
}

$fichero= rand(50,60);

$excel->getActiveSheet()->setTitle('Reporte');
$excel->setActiveSheetIndex(0);
$objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel5');

$objWriter->save(str_replace('.php', '.xls',"media/ficheros/".$fichero.".xls"));

echo $fichero;
?>
