<?php
PHPExcel_Cell::setValueBinder( new PHPExcel_Cell_AdvancedValueBinder() );
	
$excel = new PHPExcel();

$excel
->getProperties()
->setCreator(empresa)
->setLastModifiedBy(empresa)
->setTitle(empresa)
->setSubject(empresa)
->setDescription(empresa)
->setKeywords(empresa)
->setCategory(empresa);

$excel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
$excel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
$excel->getActiveSheet()->getColumnDimension('D')->setWidth(50);
$excel->getActiveSheet()->getColumnDimension('E')->setWidth(50);


$i=1;

$excel->setActiveSheetIndex(0)->mergeCells('A'.$i.':E'.$i.'');
$excel->getActiveSheet()->getStyle('A'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$excel->getActiveSheet()->getStyle('A'.$i.':E'.$i)->getFont()->setName('Arial Black');
$excel->getActiveSheet()->setCellValue('A'.$i, 'REPORTE DE PROMOTORES');

$i++;
$excel->getActiveSheet()->getStyle('A'.$i.':E'.$i)->getFont()->setName('Arial Black');

$excel->getActiveSheet()->setCellValue('A'.$i, 'Promotor');
$excel->getActiveSheet()->setCellValue('B'.$i, 'Asignados');
$excel->getActiveSheet()->setCellValue('C'.$i, 'Inscritos');
$excel->getActiveSheet()->setCellValue('D'.$i, 'Campaña');
$excel->getActiveSheet()->setCellValue('E'.$i, 'Programa');


$i++;

foreach($prospectos as $row)
{
	$excel->getActiveSheet()->getCell('A'.$i)->setValueExplicit($row->promotor, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->setCellValue('B'.$i, $this->crm->obtenerNumeroProspectosPromotor($row->idPromotor));
	$excel->getActiveSheet()->setCellValue('C'.$i, $row->numeroInscritos);
	$excel->getActiveSheet()->getCell('D'.$i)->setValueExplicit($row->campana, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('E'.$i)->setValueExplicit($row->programa, PHPExcel_Cell_DataType::TYPE_STRING);
	
	$i++;
}

$fichero= rand(50,60);

$excel->getActiveSheet()->setTitle('Promotores');
$excel->setActiveSheetIndex(0);
$objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel5');

$objWriter->save(str_replace('.php', '.xls',"media/ficheros/".$fichero.".xls"));

echo $fichero;
?>
