<?php
PHPExcel_Cell::setValueBinder( new PHPExcel_Cell_AdvancedValueBinder() );
	
$excel = new PHPExcel();

$excel
->getProperties()
->setCreator(empresa)
->setLastModifiedBy(empresa)
->setTitle(empresa)
->setSubject(empresa)
->setDescription(empresa)
->setKeywords(empresa)
->setCategory(empresa);

$excel->getActiveSheet()->getColumnDimension('A')->setWidth(60);
$excel->getActiveSheet()->getColumnDimension('B')->setWidth(30);



$i=1;

$excel->setActiveSheetIndex(0)->mergeCells('A'.$i.':B'.$i.'');
$excel->getActiveSheet()->getStyle('A'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$excel->getActiveSheet()->getStyle('A'.$i.':B'.$i)->getFont()->setName('Arial Black');
$excel->getActiveSheet()->setCellValue('A'.$i, 'REPORTE DE BAJAS');
$excel->getActiveSheet()->getStyle('A'.$i.':K'.$i)->getFont()->setSize(11);

if($campana!=null)
{
	$i++;

	$excel->setActiveSheetIndex(0)->mergeCells('A'.$i.':B'.$i.'');
	$excel->getActiveSheet()->getStyle('A'.$i.':B'.$i)->getFont()->setSize(10);
	$excel->getActiveSheet()->getStyle('A'.$i.':B'.$i)->getFont()->setName('Arial Black');
	$excel->getActiveSheet()->getCell('A'.$i)->setValueExplicit('Campaña: '.$campana->nombre, PHPExcel_Cell_DataType::TYPE_STRING);
}

if($programa!=null)
{
	$i++;

	$excel->setActiveSheetIndex(0)->mergeCells('A'.$i.':B'.$i.'');
	$excel->getActiveSheet()->getStyle('A'.$i.':B'.$i)->getFont()->setSize(10);
	$excel->getActiveSheet()->getStyle('A'.$i.':B'.$i)->getFont()->setName('Arial Black');
	$excel->getActiveSheet()->getCell('A'.$i)->setValueExplicit('Programa: '.$programa->nombre, PHPExcel_Cell_DataType::TYPE_STRING);
}


$i++;
$excel->getActiveSheet()->getStyle('A'.$i.':B'.$i)->getFont()->setName('Arial Black');
$excel->getActiveSheet()->getStyle('A'.$i.':K'.$i)->getFont()->setSize(10);

$excel->getActiveSheet()->setCellValue('A'.$i, 'Causa');
$excel->getActiveSheet()->setCellValue('B'.$i, 'Número bajas');



$i++;

foreach($bajas as $row)
{
	
	$excel->getActiveSheet()->getCell('A'.$i)->setValueExplicit(strlen($row->causa)>0?$row->causa:'Sin causa', PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->setCellValue('B'.$i, $row->numeroBajas);
	
	$i++;
}

$fichero= rand(50,60);

$excel->getActiveSheet()->setTitle('Bajas');
$excel->setActiveSheetIndex(0);
$objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel5');

$objWriter->save(str_replace('.php', '.xls',"media/ficheros/".$fichero.".xls"));

echo $fichero;
?>
