<?php
PHPExcel_Cell::setValueBinder( new PHPExcel_Cell_AdvancedValueBinder() );
	
$excel = new PHPExcel();

$excel
->getProperties()
->setCreator(empresa)
->setLastModifiedBy(empresa)
->setTitle(empresa)
->setSubject(empresa)
->setDescription(empresa)
->setKeywords(empresa)
->setCategory(empresa);

$excel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
$excel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
$excel->getActiveSheet()->getColumnDimension('F')->setWidth(22);
$excel->getActiveSheet()->getColumnDimension('G')->setWidth(45);

$i=1;

$excel->setActiveSheetIndex(0)->mergeCells('A'.$i.':G'.$i.'');
$excel->getActiveSheet()->getStyle('A'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$excel->getActiveSheet()->getStyle('A'.$i.':G'.$i)->getFont()->setName('Arial Black');
$excel->getActiveSheet()->setCellValue('A'.$i, 'PRIMER CONTACTO');

$i++;
$excel->getActiveSheet()->getStyle('A'.$i.':G'.$i)->getFont()->setName('Arial Black');

$excel->getActiveSheet()->setCellValue('A'.$i, 'Promotor');
$excel->getActiveSheet()->setCellValue('B'.$i, 'Prospecto');
$excel->getActiveSheet()->setCellValue('C'.$i, 'Teléfono');
$excel->getActiveSheet()->setCellValue('D'.$i, 'Email');
$excel->getActiveSheet()->setCellValue('E'.$i, 'Fecha registro');
$excel->getActiveSheet()->setCellValue('F'.$i, 'Seguimientos');
$excel->getActiveSheet()->setCellValue('G'.$i, 'Fecha primer seguimiento promotor');



$i++;

foreach($prospectos as $row)
{
	$excel->getActiveSheet()->getCell('A'.$i)->setValueExplicit($row->promotor, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('B'.$i)->setValueExplicit($row->nombre.' '.$row->paterno.' '.$row->materno, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('C'.$i)->setValueExplicit($row->telefono.' '.$row->movil, PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->getCell('D'.$i)->setValueExplicit($row->email, PHPExcel_Cell_DataType::TYPE_STRING);
	
	$excel->getActiveSheet()->getCell('E'.$i)->setValueExplicit(obtenerFechaMesCortoHora($row->fechaRegistro), PHPExcel_Cell_DataType::TYPE_STRING);
	$excel->getActiveSheet()->setCellValue('F'.$i, $row->numeroSeguimientos);
	$excel->getActiveSheet()->getCell('G'.$i)->setValueExplicit(obtenerFechaMesCortoHora($row->fechaContacto), PHPExcel_Cell_DataType::TYPE_STRING);
	
	
	

	
	$excel->getActiveSheet()->getStyle('E'.$i.':G'.$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	
	$i++;
}

$fichero= rand(50,60);

$excel->getActiveSheet()->setTitle('Primer contacto');
$excel->setActiveSheetIndex(0);
$objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel5');

$objWriter->save(str_replace('.php', '.xls',"media/ficheros/".$fichero.".xls"));

echo $fichero;
?>
