<?php
class Temporal_modelo extends CI_Model
{
	protected $fecha;
	protected $idLicencia;
	protected $idUsuario;
	protected $CI;

	function __construct()
	{
		parent::__construct();
		
        $this->idUsuario 		= $this->session->userdata('id');
		$this->fecha 			= date('Y-m-d H:i:s');
		$this->idLicencia 		= $this->session->userdata('idLicencia');
		$this->CI				= & get_instance();
	}
	
	public function registrarDatosTemporal($id,$operacion='registrar',$modulo='ventas')
	{
		$data=array
		(
			'fecha'				=> $this->fecha,
			'id'				=> $id,
			'operacion'			=> $operacion,
			'modulo'			=> $modulo,
		);
		
		$this->db->insert('temporal_datos',$data);
	}
	
	public function sincronizarVentasTemporales()
	{
		$sql=" select * from temporal_datos
		where modulo='ventas' ";
		
		$this->CI->load->database('default', TRUE);
		$ventas	= $this->db->query($sql)->result();
		
		foreach($ventas as $row)
		{
			if($row->operacion=='editar')
			{
				$remota = $this->CI->load->database('remota', TRUE);
				
				//BORRAR VENTA
				$sql=" delete a, b, c
				from ventas_entrega_detalles as a
				inner join cotiza_productos as b
				on  a.idProducto=b.idProducto
				inner join cotizaciones as c
				on  c.idCotizacion=b.idCotizacion
				where c.idCotizacion='$row->id' ";
				
				$remota->query($sql);
				
				/*//BORRAR DETALLES
				$remota->where('idCotizacion',$row->idCotizacion);
				$remota->delete('cotiza_productos');*/
			}
			
			$this->CI->load->database('default', TRUE);
			
			//VENTA
			$sql="select * from cotizaciones
			where idCotizacion='$row->id' ";
			
			$venta	= $this->db->query($sql)->row_array();
			
			//DETALLES VENTA
			$sql="select * from cotiza_productos
			where idCotizacion='$row->idCotizacion' ";
			
			$detalles	= $this->db->query($sql)->result_array();
			
			//ENTREGADOS VENTA
			$sql=" select a.* 
			from ventas_entrega_detalles as a
			inner join cotiza_productos as b
			on a.idProducto=b.idProducto
			where b.idCotizacion='$row->id' ";
			
			$entregados	= $this->db->query($sql)->result_array();
			
			$remota = $this->CI->load->database('remota', TRUE);
			
			$remota->insert('cotizaciones',$venta);
			
			foreach($detalles as $detalle)
			{
				$remota->insert('cotiza_productos',$detalle);
			}
			
			foreach($entregados as $entregado)
			{
				$remota->insert('ventas_entrega_detalles',$entregado);
			}
		}
		
		$this->CI->load->database('default', TRUE);
		$this->db->truncate('temporal_datos');
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//SINCRONIZAR PRODUCTOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
	public function sincronizarProductosTemporales()
	{
		$sql=" select * from temporal_datos
		where modulo='productos' ";
		
		$this->CI->load->database('default', TRUE);
		$productos	= $this->db->query($sql)->result();
		
		foreach($productos as $row)
		{
			$this->CI->load->database('default', TRUE);

			if($row->operacion=='inventario')
			{
				//OBTENER PRODUCTO INVENTARIO
				$sql		= "select idProducto, stock from productos where idProducto='$row->id' ";
				$producto	= $this->db->query($sql)->row();
				
				if($producto!=null)
				{
					$remota 	= $this->CI->load->database('remota', TRUE);
					
					$remota->where('idProducto',$producto->idProducto);
					$remota->update('productos',array('stock'=>$producto->stock));
				}
			}
		}
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//SINCRONIZAR PRODUCTOS DE LA NUBE
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
	public function sincronizarProductosNubeTemporales()
	{
		$sql=" select * from temporal_datos
		where modulo='productos' ";
		
		$remota 	= $this->CI->load->database('remota', TRUE);
		$productos	= $remota->query($sql)->result();
		
		foreach($productos as $row)
		{
			$remota 	= $this->CI->load->database('remota', TRUE);

			if($row->operacion=='inventario')
			{
				//OBTENER PRODUCTO INVENTARIO
				$sql		= "select idProducto, stock, precioA, precioB from productos where idProducto='$row->id' ";
				$producto	= $remota->query($sql)->row();
				
				if($producto!=null)
				{
					$this->CI->load->database('default', TRUE);
					
					$this->db->where('idProducto',$producto->idProducto);
					$this->db->update('productos',array('stock'=>$producto->stock));
				}
			}
			
			if($row->operacion=='registrar')
			{
				$sql		= "select * from productos where idProducto='$row->id' ";
				$producto	= $remota->query($sql)->row_array();
				
				if($producto!=null)
				{
					$this->CI->load->database('default', TRUE);
					
					$this->db->insert('productos',$producto);
				}
			}
			
		}
	}

}
	