<?php
class soporte_modelo extends CI_Model
{
	protected $idUsuario;
    protected $fechaCorta;
	protected $fecha;
	protected $hora;

	function __construct()
	{
		parent::__construct();
		
		$this->fecha 			= date('Y-m-d H:i:s');
		$this->fechaCorta		= date('Y-m-d');
		$this->hora 			= date('H:i:s');
		$this->idUsuario 		= $this->session->userdata('id');
	}

	public function obtenerProductos()
	{
		$sql=" select idProducto, stock, servicio
		from productos
		order by idProducto asc ";
		
		/*
		where servicio='0'
		order by idProducto asc*/
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerLinea($nombre)
	{
		$sql=" select idLinea
		from productos_lineas
		where nombre='$nombre' ";
		
		return $this->db->query($sql)->row()->idLinea;
	}
	
	public function procesarProductos()
	{
		$productos	= $this->obtenerProductos();
		
		foreach($productos as $row)
		{
			$data=array
			(
				'idLinea'				=> $this->obtenerLinea($row->familia),
			);
			
			$this->db->where('idProducto',$row->idProducto);
			$this->db->update('productos',$data);
		}
	}
	
	
	
	public function obtenerClientes($contactos=1)
	{
		$sql=" select a.idCliente, a.empresa, a.razonSocial, a.nombre, a.paterno, a.materno, a.email, a.telefono 
		from clientes as a
		where a.idCliente>1 ";
		
		$sql.=$contactos==1?" and (select count(b.idContacto) from clientes_contactos as b where b.idCliente=a.idCliente) = 0 ":"";
		
		$sql.=" order by a.idCliente asc ";
		
		return $this->db->query($sql)->result();
	}
	
	public function procesarClientes()
	{
		$clientes	= $this->obtenerClientes();
		
		foreach($clientes as $row)
		{
			$cliente	= $row->empresa;
			
			if(strlen($row->nombre)>0)
			{
				$cliente	= $row->nombre.' '.$row->paterno.' '.$row->materno;
			}
			
			$data=array
			(
				'idCliente'				=> $row->idCliente,
				'nombre'				=> $cliente,
				'telefono'				=> $row->telefono,
				'email'					=> $row->email,
				'direccion'				=> '',
				'fechaRegistro'			=> $this->fecha,
			);
			
			$this->db->insert('clientes_contactos',$data);
		}
		
		//REGISTRAR LOS DATOS ACADEMICOS
		$clientes	= $this->obtenerClientes(0);
		
		foreach($clientes as $row)
		{
			$data=array
			(
				'idCliente'				=> $row->idCliente,
			);
			
			$this->db->insert('clientes_academicos',$data);
		}
		
	}
	
	//CREADOR DE PERMISOS
	public function obtenerRoles()
	{
		$sql=" select * from roles ";
		
		return $this->db->query($sql)->result();
	}
	
	public function creadorPermisos($idPermiso)
	{
		$roles	= $this->obtenerRoles();
		
		foreach($roles as $row)
		{
			$data=array
			(
				'leer' 		=> $row->idRol==1?'1':'0',
				'escribir' 	=> $row->idRol==1?'1':'0',
				'idPermiso' => $idPermiso,
				'idRol' 	=> $row->idRol
			);
			
			$this->db->insert('rel_rol_permiso',$data);
		}
	}
	
	//PROCESAR LOS MATERIALES
	public function obtenerMateriales()
	{
		$sql=" select * from produccion_materiales
		order by idMaterial asc ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerUnidad($descripcion)
	{
		$sql=" select idUnidad
		from unidades
		where descripcion='$descripcion' ";
		
		return $this->db->query($sql)->row()->idUnidad;
	}
	
	public function obtenerProveedor($proveedor)
	{
		$sql=" select idProveedor
		from proveedores
		where proveedor='$proveedor' ";
		
		$proveedor	= $this->db->query($sql)->row();
		
		return $proveedor!=null?$proveedor->idProveedor:1;
	}
	
	public function procesarMateriaPrima()
	{
		$materiales	= $this->obtenerMateriales();
		
		foreach($materiales as $row)
		{
			if($row->proveedor=='S/P' or $row->proveedor=='' or $row->proveedor==' ')
			{
				$idProveedor=1;
			}
			else
			{
				$idProveedor	= $this->obtenerProveedor($row->proveedor);	
			}
			
			$this->db->where('idMaterial',$row->idMaterial);
			$this->db->update('produccion_materiales',array('idUnidad'=>$this->obtenerUnidad($row->unidad)));
			
			$data=array
			(
				'idMaterial'			=> $row->idMaterial,
				'idProveedor'			=> $idProveedor,
				'costo'					=> $row->costo,
			);
			
			$this->db->insert('rel_material_proveedor',$data);
			
		}
	}
	
	
	//PROVEEDORES
	
	public function obtenerProveedores()
	{
		$sql=" select idProveedor, empresa, telefono, email, contacto
		from proveedores
		where idProveedor>1 ";
		
		return $this->db->query($sql)->result();
	}
	
	public function procesarProveedores()
	{
		$proveedores	= $this->obtenerProveedores();
		
		foreach($proveedores as $row)
		{
			$data=array
			(
				'idProveedor'			=> $row->idProveedor,
				'nombre'				=> strlen($row->contacto)>1?$row->contacto:$row->empresa,
				'telefono'				=> $row->telefono,
				'email'					=> $row->email,
			);
			
			$this->db->insert('contactos_proveedores',$data);
		}
	}
	
	
	public function registrarStockLicencias()
	{
		#$licencias	= $this->configuracion->obtenerLicencias();
		$productos	= $this->obtenerProductos();
		
		foreach($productos as $row)
		{
			$this->inventario->registrarStockLicencias($row->idProducto,$row->stock);
		}
		
		/*foreach($licencias as $row)
		{
			$data=array
			(
				'idProducto'			=> $idProducto,
				'idLicencia'			=> $row->idLicencia,
				'stock'					=> $row->idLicencia==$this->idLicencia?$stock:0,
			);
	
			$this->db->insert('productos_inventarios', $data);
		}*/
	}
	
	public function registrarStockLicencia()
	{
		$productos	= $this->obtenerProductos();
		
		foreach($productos as $row)
		{
			$data=array
			(
				'idProducto'			=> $row->idProducto,
				'idLicencia'			=> 4,
				'stock'					=> 0,
			);
	
			$this->db->insert('productos_inventarios', $data);
		}
	}
	
	
	//PROCESAR DATOS DE LA PIÑATA
	//PROVEEDORES
	
	public function obtenerClaveUnidad($clave)
	{
		$sql=" select idUnidad
		from fac_catalogos_unidades
		where clave='$clave' ";
		
		$unidad	= $this->db->query($sql)->row();
		
		return $unidad!=null?$unidad->idUnidad:1070;
	}
	
	public function obtenerClaveProducto($clave)
	{
		$sql=" select idClave
		from fac_catalogos_claves_productos
		where clave='$clave' ";
		
		$producto	= $this->db->query($sql)->row();
		
		return $producto!=null?$producto->idClave:1;
	}
	
	public function obtenerProductosPinata()
	{
		$sql=" select * from soporte ";
		
		return $this->db->query($sql)->result();
	}
	
	public function procesarProductosPinata()
	{
		$productos	= $this->obtenerProductosPinata();
		
		foreach($productos as $row)
		{
			$data=array
			(
				'idClave'					=> $this->obtenerClaveProducto($row->clave),
			);
			
			$this->db->where('codigoBarras',$row->codigoBarras);
			$this->db->update('productos',$data);
		}
	}
	
	
	//PROCESAR LOS DATOS ACADEMICOS DE LOS ALUMNOS
	
	public function obtenerPrograma($nombre)
	{
		if(strlen($nombre)<2)
		{
			return 0;
		}
		
		$sql=" select idPrograma
		from clientes_programas
		where nombre='$nombre' ";
		
		$programa=$this->db->query($sql)->row();

		if($programa!=null)
		{
			return $programa->idPrograma;
		}
		else
		{
			$data=array
			(
				'nombre'				=> $nombre,
			);
			
			$this->db->insert('clientes_programas',$data);
			return $this->db->insert_id();
		}
		
	}
	
	/*public function obtenerClientesAlumnos()
	{
		$sql=" select *
		from clientes_alumnos
		order by nombre asc, apaterno asc, programainscribe asc ";

		return $this->db->query($sql)->result();
	}
	
	public function obtenerClienteAlumno($nombre,$paterno,$materno,$rfc)
	{
		$sql=" select idCliente
		from clientes
		where nombre='$nombre'
		and paterno='$paterno'
		and materno='$materno'
		and rfc='$rfc' ";

		return $this->db->query($sql)->result();
	}
	
	public function procesarClientesAlumnos()
	{
		$clientes	= $this->obtenerClientesAlumnos();
		
		foreach($clientes as $row)
		{
			$cliente	= $this->obtenerClienteAlumno($row->nombre,$row->apaterno,$row->amaterno,$row->facrfc);
			
			foreach($cliente as $cli)
			{
				$data=array
				(
					'idPrograma'			=> $this->obtenerPrograma($row->programainscribe),
					'matricula'				=> $row->matricula,
					'usuario'				=> $row->usuario,
					'password'				=> $row->contrasena,
					'inscripcion'			=> $row->inscripcion,
					'colegiatura'			=> $row->colegiatura,
					'reinscripcion'			=> $row->reinscripcion,
					'titulacion'			=> $row->titulacion,
					'periodo'				=> $row->periodo,
				);
				
				$this->db->where('idCliente',$cli->idCliente);
				$this->db->update('clientes_academicos',$data);
			}
		}
	}*/
	
	
	public function obtenerClientesAlumnos()
	{
		$sql=" select *
		from clientes_alumnos
		order by nombre asc, apellido asc ";

		return $this->db->query($sql)->result();
	}
	
	public function obtenerClienteAlumno($nombre,$apellido)
	{
		$sql=" select a.idCliente
		from clientes as a
		inner join clientes_academicos as b
		on a.idCliente=b.idCliente
		where a.nombre='$nombre'
		and concat(a.paterno,' ',a.materno)='$apellido'
		and length(b.matricula)=0 ";

		return $this->db->query($sql)->result();
	}
	
	public function procesarClientesAlumnos()
	{
		$clientes	= $this->obtenerClientesAlumnos();
		
		foreach($clientes as $row)
		{
			$cliente	= $this->obtenerClienteAlumno($row->nombre,$row->apellido);
			
			foreach($cliente as $cli)
			{
				$data=array
				(
					'matricula'				=> $row->matricula,
				);
				
				$this->db->where('idCliente',$cli->idCliente);
				$this->db->update('clientes_academicos',$data);
			}
		}
	}
	
	//CREADOR DE BOTONES DE  PERMISOS
	public function creadorPermisosBotones($idBoton)
	{
		$roles	= $this->obtenerRoles();
		
		foreach($roles as $row)
		{
			$data=array
			(
				'idBoton' 	=> $idBoton,
				'idRol' 	=> $row->idRol,
				'activo' 	=> $row->idRol==1?'1':'0'
			);
			
			$this->db->insert('rel_rol_boton',$data);
		}
	}
	
	public function creadorPermisosBotonesRango()
	{
		$roles	= $this->obtenerRoles();
		
		for($i=246;$i<=251;$i++)
		{
			foreach($roles as $row)
			{
				$data=array
				(
					'idBoton' 	=> $i,
					'idRol' 	=> $row->idRol,
					'activo' 	=> $row->idRol==1?'1':'0'
				);
				
				$this->db->insert('rel_rol_boton',$data);
			}
		}
		
	}
	
	public function obtenerClienteMatricula($matricula)
	{
		$sql=" select idCliente
		from clientes_academicos
		where matricula='$matricula' ";

		$alumno	= $this->db->query($sql)->row();
		
		return $alumno!=null?$alumno->idCliente:0;
	}
	
	public function obtenerClientesMatricula()
	{
		$sql=" select *
		from clientes_alumnos ";

		return $this->db->query($sql)->result();
	}
	
	public function procesarClientesZona()
	{
		$clientes	= $this->obtenerClientesMatricula();
		
		foreach($clientes as $row)
		{
			$cliente	= $this->obtenerClienteMatricula($row->matricula);
			
			$this->db->where('idCliente',$cliente);
			$this->db->update('clientes',array('idZona'=>1));
		}
	}
	
	
	////PROCESAR LOS SEGUIMIENTOS REPETIDOS
	public function obtenerSeguimientosBorrar()
	{
		$sql=" select a.idSeguimiento 
		FROM seguimiento AS a 
		WHERE a.idCliente>1
		AND (SELECT COUNT(b.idCliente) FROM clientes AS b WHERE b.idCliente=a.idCliente) =0 ";

		return $this->db->query($sql)->result();
	}
	
	public function procesarSeguimientosBorrar()
	{
		$seguimiento	= $this->obtenerSeguimientosBorrar();
		
		foreach($seguimiento as $row)
		{	
			$this->db->where('idSeguimiento',$row->idSeguimiento);
			$this->db->delete('seguimiento_detalles');
			
			$this->db->where('idSeguimiento',$row->idSeguimiento);
			$this->db->delete('seguimiento');
		}
	}
	
	//QUITAR PROGRAMAS DUPLICADOS
	public function obtenerProgramasNombre($nombre,$idPrograma)
	{
		$sql=" select idPrograma 
		from clientes_programas 
		where activo='1'
		and nombre='$nombre'
		and idPrograma!='$idPrograma' ";

		return $this->db->query($sql)->result();
	}
	
	public function procesarProgramasAlumnos()
	{
		$sql=" select * from clientes_programas where activo='1' group by nombre";
		
		$programas	=$this->db->query($sql)->result();
		
		foreach($programas as $row)
		{
			$detalles	= $this->obtenerProgramasNombre($row->nombre,$row->idPrograma);
			
			foreach($detalles as $det)
			{
				$this->db->where('idPrograma',$det->idPrograma);
				$this->db->update('clientes_academicos',array('idPrograma'=>$row->idPrograma));
				
				$this->db->where('idPrograma',$det->idPrograma);
				$this->db->update('clientes_programas',array('activo'=>'0'));
			}
		}
	}
	
	public function procesarAlumnosInscritos1()
	{
		$sql=" select a.idCliente,
		(select b.fecha from catalogos_ingresos as b where b.idCliente=a.idCliente order by fecha desc  limit 1) as fecha
		from clientes as a
		where a.prospecto='0'
		and a.activo='1' ";
		
		$clientes	=$this->db->query($sql)->result();
		
		foreach($clientes as $row)
		{
			$this->db->where('idPrograma',$det->idPrograma);
			$this->db->update('clientes_academicos',array('idPrograma'=>$row->idPrograma));
		}
	}
	
	public function obtenerAlumnosInscritos($cliente)
	{
		$sql=" select a.idCliente,
		a.idCampana,
		(select count(b.idIngreso) from catalogos_ingresos as b where b.idCliente=a.idCliente) as numeroPagos,
		(select count(b.idDetalle) from seguimiento_detalles as b inner join seguimiento as c on c.idSeguimiento=b.idSeguimiento where c.idCliente=a.idCliente) as numeroSeguimientos,
		
		(select b.idPrograma from clientes_academicos  as b where b.idCliente=a.idCliente limit 1) as idPrograma
		
		from clientes as a
		where a.activo='1'
		
		and (trim(a.empresa)='$cliente->nombre'
		or trim(a.nombre)='$cliente->nombre'
		or concat(trim(a.nombre),' ',trim(a.paterno),' ',trim(a.materno))='$cliente->nombre'  ";	
		
		$sql.=strlen($cliente->email)>2?" or a.email='$cliente->email' ":'';
		
		#and a.prospecto='0'
		
		$sql.=" )
		order by  numeroSeguimientos desc,
		numeroPagos desc,
		a.email desc, 
		a.idCampana desc ";	
		
		return $this->db->query($sql)->result();
	}
	
	public function procesarAlumnosInscritos()
	{
		$sql=" select * from clientes_inscritos ";
		
		$inscritos	=$this->db->query($sql)->result();
		
		foreach($inscritos as $ins)
		{
			$clientes	= $this->obtenerAlumnosInscritos($ins);
			
			if(count($clientes)>1)
			{
				$idCliente	= $clientes[0]->idCliente;
				$idPrograma	= $clientes[0]->idPrograma;
				$idCampana	= $clientes[0]->idCampana;
				
				$i=0;
				
				foreach($clientes as $row)
				{
					if($i>0)
					{
						$data	= array('idCliente'=>$idCliente);
						
						$this->db->where('idCliente',$row->idCliente);
						$this->db->update('seguimiento',$data);
						
						$this->db->where('idCliente',$row->idCliente);
						$this->db->update('catalogos_ingresos',$data);
						
						$this->db->where('idCliente',$row->idCliente);
						$this->db->update('clientes',array('activo'=>'0'));
						
						$this->db->where('idCliente',$idCliente);
						$this->db->update('clientes',array('prospecto'=>'0'));
						
						if($idPrograma<1)
						{
							$this->db->where('idCliente',$idCliente);
							$this->db->update('clientes_academicos',array('idPrograma'=>$row->idPrograma));
						}
						
						if($idCampana<1)
						{
							$this->db->where('idCliente',$idCliente);
							$this->db->update('clientes',array('idCampana'=>$row->idCampana));
						}
					}
					
					$i++;
				}
			}
		}
	}
	
	public function procesarCorreos()
	{
		$sql=" select * from clientes_correos ";
		
		$clientes	=$this->db->query($sql)->result();
		
		foreach($clientes as $row)
		{
			$this->db->where('email',$row->email);
			$this->db->update('clientes',array('idCampana'=>6));
		}
	}
	
	
	public function procesarSeguimientosAtrasos()
	{
		$sql.="
		select distinct a.idCliente, a.idPromotor, concat(a.nombre, ' ', a.paterno,' ', a.materno) as prospecto,
		a.lada, a.telefono, a.ladaMovil, a.movil, a.email,
		
		f.nombre as campana, 
		
		(select g.idContacto from clientes_contactos as g where g.idCliente=a.idCliente limit 1 ) as idContacto,
		
		concat(b.nombre, ' ', b.apellidoPaterno,' ', b.apellidoMaterno) as promotor,
		timestampdiff(minute,a.fechaRegistro ,now()) / 60 as horas,
		a.fechaRegistro as fechaSeguimiento
		from clientes as a
		inner join usuarios as b
		on a.idPromotor=b.idUsuario
		inner join clientes_campanas as f
		on a.idCampana=f.idCampana 
		
		
		where b.promotor='1'
		and a.prospecto='1'
		and a.activo='1'
		and a.idZona!=2
		and timestampdiff(minute,a.fechaRegistro ,now()) / 60 >= 24
		
		and (select count(g.idDetalle) from seguimiento_detalles as g inner join seguimiento as h on g.idSeguimiento=h.idSeguimiento where h.idCliente=a.idCliente )=0  ";

		//AGREGAR LA CAMPAÑA
		$sql.=" and f.fechaFinal>curdate() ";
		
		$sql.=" group by a.idCliente 
		order by fechaSeguimiento desc ";
		
		$prospectos	=$this->db->query($sql)->result();
		
		foreach($prospectos as $row)
		{
			
			$seguimiento['fecha']				= $this->fecha;
			$seguimiento['comentarios']			= 'S/C';
			$seguimiento['fechaCierre']			= $this->fecha;
			$seguimiento['horaCierreFin']		= '13:00';
			$seguimiento['idStatus']			= 4;
			$seguimiento['idEstatus']			= 4;
			$seguimiento['tipo']				= 1;
			$seguimiento['idServicio']			= 1;
			$seguimiento['folio']				= $this->crm->obtenerFolioSeguimientoCliente(1);
			
			$seguimiento['idResponsable']		= $row->idPromotor;
			$seguimiento['idUsuarioRegistro']	= $row->idPromotor;
			$seguimiento['idCliente']			= $row->idCliente;
			$seguimiento['idContacto']			= $row->idContacto;

			$detalle['fecha']					= $this->fecha;
			$detalle['hora']					= '13:00';
			$detalle['fechaRegistro']			= $this->fecha;
			$detalle['observaciones']			= 'S/C';
			$detalle['fechaSeguimiento']		= $this->fecha;
			$detalle['horaInicial']				= '13:00';;
			$detalle['horaFinal']				= '13:00';;
			$detalle['alerta']					= '1';
			
			$this->importar->registrarSeguimientoInicial($seguimiento,$detalle);
		}
	}	
	
	public function procesarNuevos()
	{
		$sql=" SELECT DISTINCT a.idCliente
		FROM clientes AS a
		INNER JOIN usuarios AS b
		ON a.idPromotor=b.idUsuario
		INNER JOIN clientes_campanas AS f
		ON a.idCampana=f.idCampana
		WHERE b.promotor='1'
		AND a.prospecto='1'
		AND a.activo='1'
		AND a.idZona!=2
		AND (SELECT COUNT(g.idDetalle) FROM seguimiento_detalles AS g INNER JOIN seguimiento AS h ON g.idSeguimiento=h.idSeguimiento WHERE h.idCliente=a.idCliente )=0
		AND f.fechaFinal>CURDATE() 
		GROUP BY a.idCliente ";
		
		$prospectos	=$this->db->query($sql)->result();
		
		foreach($prospectos as $row)
		{
			$this->db->where('idCliente',$row->idCliente);
			$this->db->update('clientes',array('nuevoRegistro'=>'1'));
		}
	}
	
	public function obtenerDetalleSeguimiento($idSeguimiento)
	{
		$sql=" select * from seguimiento_detalles_
		where idSeguimiento='$idSeguimiento' ";
		
		return $this->db->query($sql)->result_array();
	}
	
	public function procesarSeguimientosClientes()
	{
		$sql=" select * from seguimiento_ ";
		
		$seguimiento	= $this->db->query($sql)->result_array();
		
		foreach($seguimiento as $row)
		{
			$detalles	= $this->obtenerDetalleSeguimiento($row['idSeguimiento']);
			
			$row['idSeguimiento']	= 0;
			
			$this->db->insert('seguimiento',$row);
			$idSeguimiento	= $this->db->insert_id();
			
			foreach($detalles as $seg)
			{
				$seg['idSeguimiento']	= $idSeguimiento;
				$seg['idDetalle']		= 0;
				
				$this->db->insert('seguimiento_detalles',$seg);
			}
		}
	}
	
	public function obtenerSeguimientoCliente($idCliente)
	{
		$sql=" select idSeguimiento from seguimiento
		where idCliente='$idCliente' ";
		
		return $this->db->query($sql)->result();
	}
	
	//PROCESAR ERRORES IMPORTAR
	public function procesarClientesErrores()
	{
		#$sql=" SELECT idCliente FROM clientes WHERE fechaRegistro='2018-09-18 10:36:18' ";
		$sql=" SELECT idCliente FROM clientes WHERE fechaRegistro='2018-09-18 10:45:41' ";
		
		$clientes	= $this->db->query($sql)->result();
		
		foreach($clientes as $row)
		{
			$seguimiento	= $this->obtenerSeguimientoCliente($row->idCliente);
			
			foreach($seguimiento as $seg)
			{
				$this->db->where('idSeguimiento',$seg->idSeguimiento);
				$this->db->delete('seguimiento_detalles');
				
				$this->db->where('idSeguimiento',$seg->idSeguimiento);
				$this->db->delete('seguimiento');
			}
			
			$this->db->where('idCliente',$row->idCliente);
			$this->db->delete('clientes_contactos');
			
			$this->db->where('idCliente',$row->idCliente);
			$this->db->delete('clientes_academicos');
			
			$this->db->where('idCliente',$row->idCliente);
			$this->db->delete('clientes');
		}
	}
	
	public function procesarCrmPromotores()
	{
		$sql=" select idUsuario from usuarios
		where activo='1'
		and promotor='1' ";
		
		$promotores		= $this->db->query($sql)->result();
		$comentarios	= 'Se envió información masivamente por correo.';
		
		foreach($promotores as $pro)
		{
			$sql=" select distinct(a.idCliente), a.fechaRegistro, a.idPromotor,
			time(a.fechaRegistro) as horaRegistro, d.idContacto
			from clientes as a 
			inner join zonas as b
			on a.idZona=b.idZona
			
			inner join clientes_contactos as d
			on d.idCliente=a.idCliente
			
			where a.activo='1'
			and a.idZona!=2  
			and  a.prospecto='1'  
			and a.nuevo='0'
			and date(a.fechaRegistro) between '2017-01-01' and '2018-10-16'
			and (select count(g.idDetalle) from seguimiento_detalles as g inner join seguimiento as h on g.idSeguimiento
			=h.idSeguimiento 
			where h.idCliente=a.idCliente )=0  
			and  a.idPromotor='$pro->idUsuario'
			order by concat(a.nombre,' ',a.paterno,' ',a.materno) asc  ";
			
			$clientes	= $this->db->query($sql)->result();
			$i			= 1;
			$dia		= 1;
			$fecha		= '2018-11-01';
			
			foreach($clientes as $row)
			{
				$seguimiento['fecha']			= $row->fechaRegistro;
				$seguimiento['comentarios']		= $comentarios;
				$seguimiento['fechaCierre']		= $row->fechaRegistro;
				$seguimiento['horaCierreFin']	= $row->horaRegistro;
				$seguimiento['idStatus']		= 4;
				$seguimiento['idEstatus']		= 4;
				$seguimiento['tipo']			= 1;
				$seguimiento['idServicio']		= 1;
				
				$seguimiento['idResponsable']		= $row->idPromotor;
				$seguimiento['idUsuarioRegistro']	= $row->idPromotor;
				$seguimiento['idCliente']			= $row->idCliente;
				$seguimiento['idContacto']			= $row->idContacto;
				
				
				$seguimiento['folio']			= $this->crm->obtenerFolioSeguimientoCliente(1);
				
				$detalle['fecha']				= $row->fechaRegistro;
				$detalle['hora']				= $row->horaRegistro;
				$detalle['fechaRegistro']		= $row->fechaRegistro;
				$detalle['observaciones']		= $comentarios;
				$detalle['fechaSeguimiento']	= $fecha;
				$detalle['horaInicial']			= '09:00:00';
				$detalle['horaFinal']			= '09:00:00';
				$detalle['alerta']				= '1';
				
				$this->importar->registrarSeguimientoInicial($seguimiento,$detalle);
				
				$i++;
				
				if($i>50)
				{
					$dia++;
					
					$fecha		= '2018-11-'.($dia<10?'0'.$dia:$dia);
					$i			= 1;
				}
			}
			
		}
	}
	
	public function comprobarProductoCodigo($codigoInterno)
	{
		$this->db->select('idProducto');
		$this->db->from('productos');
		$this->db->where('codigoInterno',$codigoInterno);
		
		return $this->db->get()->row();
	}
	
	public function importarProductosCerraduras()
	{
		$sql=" select * from productos_importar";
		
		$productos		= $this->db->query($sql)->result();
		
		
		foreach($productos as $row)
		{
			$inventario	= $this->comprobarProductoCodigo($row->clave);
			
			$data=array
			(
				'codigoBarras' 		=> $row->codigo,
				'nombre' 			=> $row->nombre,
				'precioC' 			=> $row->precioA,
				'precioA' 			=> $row->precioB,
				'precioB' 			=> $row->precioC,
				'cantidadMayoreo' 	=> $row->mayoreo,
				'idClave' 			=> $this->importar->obtenerClaveProducto($row->claveProducto),
				'idUnidad' 			=> $this->importar->obtenerClaveUnidadImportar($row->unidad)
			);
			
			if($inventario!=null)
			{
				if(strlen($row->clave)>0)
				{
					$this->db->where('idProducto',$inventario->idProducto);
					$this->db->update('productos',$data);
					
					$this->db->where('idProducto',$inventario->idProducto);
					$this->db->update('rel_producto_proveedor',array('precio'=>$row->costo));
				}
			}
			else
			{
				$data['codigoInterno']		= $row->clave;
				$data['fecha']				= $this->fecha;
				$data['idUsuario']			= $this->idUsuario;
				$data['reventa']			= 1;
				$data['descripcion']		= '';
				
				$this->db->insert('productos',$data);
				$idProducto	= $this->db->insert_id();
				
				$this->inventario->registrarStockLicencias($idProducto,0);
				
				
				$proveedor=array
				(
					'idProducto' 		=> $idProducto,
					'idProveedor' 		=> 1,
					'precio' 			=> $row->costo,
				);
				
				$this->db->insert('rel_producto_proveedor',$proveedor);
			}
			
			
		}
	}
	
	public function procesarProspectosPromotor()
	{
		$sql		=" SELECT idUsuario FROM usuarios
		WHERE promotor='1'
		AND activo='1'
		AND idUsuario>1 
		and idUsuario!=48 ";
		
		$usuarios		= $this->db->query($sql)->result();
		
		
		$sql=" SELECT a.*, b.descripcion
		AS variable,
		
		(SELECT CONCAT(d.nombre, ' ', d.apellidoPaterno, ' ', d.apellidoMaterno) FROM usuarios AS d WHERE d
		.idUsuario=a.idPromotor ) AS promotor,
		(SELECT d.correo FROM usuarios AS d WHERE d.idUsuario=a.idPromotor ) AS emailPromotor,
		
		(SELECT d.nombre FROM clientes_campanas AS d WHERE d.idCampana=a.idCampana) AS campana,
		
		(SELECT d.nombre FROM clientes_programas AS d INNER JOIN clientes_academicos AS e ON d.idPrograma=e
		.idPrograma WHERE a.idCliente=e.idCliente) AS programa,
		
		(SELECT COUNT(g.idDetalle) FROM seguimiento_detalles AS g INNER JOIN seguimiento AS h ON g.idSeguimiento
		=h.idSeguimiento WHERE h.idCliente=a.idCliente) AS numeroSeguimientos,
		
		(SELECT d.nombre FROM clientes_fuentes AS d WHERE d.idFuente=a.idFuente) AS fuente
		
		FROM clientes AS a 
		INNER JOIN zonas AS b
		ON a.idZona=b.idZona
		WHERE a.activo='1'
		AND a.idZona!=2  
		AND  a.prospecto='1'  
		AND  a.idPromotor='48'  ";
		
		$prospectos		= $this->db->query($sql)->result();
		$idPromotor		= $usuarios[0]->idUsuario;
		$i				= 1;
		$p				= 0;
		
		foreach($prospectos as $row)
		{
			$this->db->where('idCliente',$row->idCliente);
			$this->db->update('clientes',array('idPromotor'=>$idPromotor));
			
			$this->db->where('idCliente',$row->idCliente);
			$this->db->update('seguimiento',array('idResponsable'=>$idPromotor,'idUsuarioRegistro'=>$idPromotor));
			
			$i++;
			
			if($i==19)
			{
				if($p!=9)
				{
					$p++;
					$i=1;
				}
				
				$idPromotor		= $usuarios[$p]->idUsuario;
			}
			
			
		}
	}
	
	public function asignarCampanaSeguimiento()
	{
		$sql=" select a.idSeguimiento, a.idCliente, b.idCampana
		from seguimiento as a
		inner join clientes as b
		on a.idCliente=b.idCliente ";
		
		$seguimiento		= $this->db->query($sql)->result();
		
		foreach($seguimiento as $row)
		{
			$this->db->where('idSeguimiento',$row->idSeguimiento);
			$this->db->update('seguimiento_detalles',array('idCampana'=>$row->idCampana));
		}
	}
	
	public function obtenerUltimaConexion()
	{
		$sql=" select a.idCliente,
		(select g.matricula from clientes_academicos as g where g.idCliente=a.idCliente) as matricula 
		from clientes as a 
		inner join zonas as b
		on a.idZona=b.idZona  
		where a.activo='1'  and  a.idZona='1'";
			
		$clientes		= $this->db->query($sql)->result();
		
		foreach($clientes as $row)
		{
			if(strlen($row->matricula)>2)
			{
				$ultima	= $this->crm->obtenerUltimaConexionPreinscrito($row->matricula);
				
				if(strlen($ultima)>2)
				{
					#echo strlen($ultima)>0?obtenerFechaMesCortoHora($ultima):'';
					
					$this->db->where('idCliente',$row->idCliente);
					$this->db->update('clientes',array('ultimaConexion'=>$ultima));
				}
				
			}
			
			
			
		}
	}
	
	
	public function asignarClientesPromotor()
	{
		$sql=" select a.idCliente
		from clientes as a
		where a.idPromotor=89 ";
		
		$clientes		= $this->db->query($sql)->result();
		
		$i=1;
		foreach($clientes as $row)
		{
			if($i<=63)
			{
				$idPromotor=88;
			}
			
			if($i>63 and $i<=126)
			{
				$idPromotor=87;
			}
			
			if($i>126)
			{
				$idPromotor=90;
			}
			
			$this->db->where('idCliente',$row->idCliente);
			$this->db->update('seguimiento',array('idUsuarioRegistro'=>$idPromotor,'idResponsable'=>$idPromotor));
			
			
			$this->db->where('idCliente',$row->idCliente);
			$this->db->update('clientes',array('idPromotor'=>$idPromotor));
			
			
			$i++;
		}
	}
	
	public function asignarClientesPromotorRegistro()
	{
		$sql=" select a.idCliente
		from clientes as a
		where a.idPromotor=201 ";
		
		$clientes		= $this->db->query($sql)->result();
		
		$i=1;
		foreach($clientes as $row)
		{
			$idPromotor=193;
			
			$this->db->where('idCliente',$row->idCliente);
			$this->db->update('seguimiento',array('idUsuarioRegistro'=>$idPromotor,'idResponsable'=>$idPromotor));
			
			
			$this->db->where('idCliente',$row->idCliente);
			$this->db->update('clientes',array('idPromotor'=>$idPromotor));
			
			$this->db->where('idPromotor',201);
			$this->db->update('seguimiento_detalles',array('idPromotor'=>$idPromotor));
			
			
			$i++;
		}
	}
	
	public function cambiarSeguimientosFechas()
	{
		$sql=" ( SELECT e.idDetalle, a.idSeguimiento, a.idCliente, a.comentarios, a.fechaCierre AS fecha, a.horaCierreFin,
		CONCAT(b.nombre, ' ', b.paterno, ' ', b.materno) AS prospecto,
		CONCAT(c.nombre, ' ', c.apellidoPaterno, ' ', c.apellidoMaterno) AS promotor,
		(SELECT d.nombre FROM seguimiento_estatus AS d WHERE d.idEstatus=a.idEstatus) AS estatus,
		(SELECT d.nombre FROM clientes_fuentes AS d WHERE d.idFuente=b.idFuente) AS fuente,
		b.movil, b.ladaMovil, e.horaInicial, e.horaFinal,
		'activo' AS tipoSeguimiento
		FROM seguimiento AS a 
		INNER JOIN clientes AS b
		ON a.idCliente=b.idCliente
		INNER JOIN usuarios AS c
		ON b.idPromotor=c.idUsuario
		INNER JOIN seguimiento_detalles AS e
		ON e.idSeguimiento=a.idSeguimiento  INNER JOIN clientes_campanas AS f
		ON b.idCampana=f.idCampana  WHERE  b.idZona!=2
		AND b.idZona!=8
		AND b.activo='1'
		AND b.prospecto='1'
		AND f.atrasos='0'   AND f.fechaFinal>CURDATE()  AND (SELECT g.preinscrito FROM clientes_academicos AS g WHERE g.idCliente=b.idCliente LIMIT 1) = '0'  AND TIMESTAMPDIFF(MINUTE,(SELECT CONCAT(f.fechaSeguimiento,' ',f.horaInicial) FROM seguimiento_detalles AS f INNER JOIN seguimiento AS g ON g.idSeguimiento=f.idSeguimiento WHERE g.idCliente=b.idCliente ORDER BY f.fechaSeguimiento DESC, f.horaInicial DESC LIMIT 1 ) ,NOW()) / 60 >= 3   AND b.idPromotor='39'  GROUP BY a.idCliente )  
		
		UNION  (SELECT 0 AS idDetalle, 0 AS idSeguimiento, a.idCliente, '' AS comentarios, a.fechaRegistro AS fecha,  TIME(a.fechaRegistro) AS horaCierreFin,
		CONCAT(a.nombre, ' ', a.paterno, ' ', a.materno) AS prospecto,
		CONCAT(b.nombre, ' ', b.apellidoPaterno, ' ', b.apellidoMaterno) AS promotor,
		'Nuevo' AS estatus,
		(SELECT c.nombre FROM clientes_fuentes AS c WHERE c.idFuente=a.idFuente) AS fuente,
		a.movil, a.ladaMovil, TIME(a.fechaRegistro) AS horaInicial, TIME(a.fechaRegistro) AS horaFinal,
		'nuevo' AS tipoSeguimiento
		FROM clientes AS a 
		INNER JOIN usuarios AS b
		ON a.idPromotor=b.idUsuario 
		
		INNER JOIN clientes_campanas AS f
		ON a.idCampana=f.idCampana
		
		
		AND a.idZona!=2
		AND a.idZona!=8
		AND a.activo='1'
		AND a.prospecto='1' 
		
		AND f.atrasos='0' 
		
		AND (SELECT g.preinscrito FROM clientes_academicos AS g WHERE g.idCliente=a.idCliente LIMIT 1) = '0'
		AND TIMESTAMPDIFF(MINUTE,a.fechaRegistro ,NOW()) / 60 >= 3
		AND (SELECT COUNT(g.idDetalle) FROM seguimiento_detalles AS g INNER JOIN seguimiento AS h ON g.idSeguimiento=h.idSeguimiento WHERE h.idCliente=a.idCliente )=0  AND a.idPromotor='39'  AND f.fechaFinal>CURDATE()  GROUP BY a.idCliente )  ORDER BY horaInicial ASC";
			
		$seguimiento		= $this->db->query($sql)->result();
		
		foreach($seguimiento as $row)
		{
			$this->db->where('idDetalle',$row->idDetalle);
			$this->db->update('seguimiento_detalles',array('fechaSeguimiento'=>$this->fechaCorta));
		}
	}
	
	public function cambiarProspectosClientes()
	{
		$sql=" select a.idCliente, b.matricula
		from clientes as a
		inner join clientes_academicos as b
		on a.idCliente=b.idCliente
		where a.idCliente>0
		and length(b.matricula)>1
		and a.prospecto='1' ";
			
		$registros		= $this->db->query($sql)->result();
		
		foreach($registros as $row)
		{
			$this->db->where('idCliente',$row->idCliente);
			$this->db->update('clientes',array('prospecto'=>'0'));
		}
	}

	public function obtenerDependencia($nombre)
	{
		$registro	= $this->db
		->where('nombre',$nombre)
		->where('activo','1')
		->get('clientes_dependencias')->row();
		
		
		if($registro!=null)
		{
			return $registro->idDependencia;
		}
		else
		{
			$this->db->insert('clientes_dependencias',array('nombre'=>$nombre,'fechaRegistro'=>$this->fecha,'idUsuario'=>$this->idUsuario));
			
			return $this->db->insert_id();
		}
	}

	public function obtenerCargo($nombre)
	{
		$nombre=trim($nombre);
		if(strlen($nombre)==0) return 0;

		$registro	= $this->db
		->where('nombre',$nombre)
		->where('activo','1')
		->get('clientes_contactos_cargos')->row();
		
		if($registro!=null)
		{
			return $registro->idCargo;
		}
		else
		{
			$this->db->insert('clientes_contactos_cargos',array('nombre'=>$nombre,'fechaRegistro'=>$this->fecha,'idUsuario'=>$this->idUsuario));
			
			return $this->db->insert_id();
		}
	}

	public function registrarClientesEvaluare()
	{
		$sql=" select  * from clientes_temporal ";
			
		$registros		= $this->db->query($sql)->result();
		
		foreach($registros as $row)
		{
			$data=array
			(
				'empresa'			=> $row->nombre,
				'precio'			=> 1,	 
				'telefono'			=> $row->telefono,
				'idUsuario' 		=> $row->idUsuario,
				'fechaRegistro'		=> $this->fecha,
				'pais'				=> 'México',
				'idLicencia'		=> 1,
				'idZona'			=> 1,
				'prospecto'			=> '1',
				'idFuente'			=> 0,
				'idCuentaCatalogo'	=> 0,
				'saldoInicial'		=> 0,
				'idDependencia'		=> $this->obtenerDependencia($row->zona),
				'idConvenio'		=> 0,			
				'idPrograma'		=> 0,
				'bajaAnterior'		=> '0',
				'idPromotor' 		=> $row->idUsuario,
			);
		
			$data	= procesarArreglo($data);

			$this->db->insert('clientes', $data);
			$idCliente = $this->db->insert_id();

			$data=array
			(
				'idCliente' 			=> $idCliente,
				'nombre' 				=> $row->nombre,				
				'idCargo'				=> $this->obtenerCargo($row->puesto),
				'fechaRegistro'			=> $this->fecha,
				'idUsuario' 			=> $this->idUsuario,
			);
		
			$data	= procesarArreglo($data);
			$this->db->insert('clientes_contactos', $data); 
		}
	}
}
