<?php
class Facturaventa_modelo extends CI_Model 
{
    protected $_fecha_actual;
    protected $_table;
    protected $_iduser;
	protected $idLicencia;
	protected $resultado;
	protected $facturaId;

    function __construct() 
	{
        parent::__construct();
        #$this->config->load('datatables', TRUE);
        #$this->_table = $this->config->item('datatables');

        $datestring 			= "%Y-%m-%d %H:%i:%s";
        $this->_fecha_actual 	= mdate($datestring, now());
        $this->_iduser 			= $this->session->userdata('id');
		$this->idLicencia 		= $this->session->userdata('idLicencia');
		$this->resultado		= "1";
		$this->facturaId		= 0;
		
		$this->cambiarFechaActual();
    }
	
	public function cambiarFechaActual()
	{
		$sql="select date_sub('".date('Y-m-d H:i:s')."', interval 10 minute) as fechaActual";
		
		$this->_fecha_actual=$this->db->query($sql)->row()->fechaActual;
	}
	
	public function obtenerComisionPersonal($idPersonal)
	{
		$sql="select comision
		from recursos_personal
		where idPersonal='$idPersonal' ";
		
		return $this->db->query($sql)->row()->comision;
	}
	
	public function obtenerFechaVencimiento($fecha,$dias)
	{
		$sql		="select date_add('".$fecha."',interval ".$dias." day) as fechaFin";
		
		return $this->db->query($sql)->row()->fechaFin;
	}
	
	public function obtenerFolioVenta()
	{
		$sql="select coalesce(max(folio),0) as folio 
		from  cotizaciones ";
		
		return $this->db->query($sql)->row()->folio+1;
	}
	
	public function obtenerDigitosCuenta($idCuenta)
	{
		$idCuenta	=$idCuenta==0?1:$idCuenta;
		
		if($idCuenta>0)
		{
			$sql="select cuenta
			from cuentas
			where idCuenta='$idCuenta' ";
			
			$cuenta		= $this->db->query($sql)->row()->cuenta;
			
			if($cuenta=='Efectivo')return '';
			
			$longitud	=strlen($cuenta);
			return substr($cuenta,$longitud-4,4);
		}
		else
		{
			return '';
		}
	}
	
	public function registrarVentaFactura() 
	{
		$this->db->trans_start(); #Se Inicia una transaccion porque se inserta en mas de 2 tablas
		
		$idForma		= $this->input->post('idForma');

		$folio			= $this->obtenerFolioVenta();
		$divisa			= $this->obtenerDivisa($this->input->post('idDivisa'));

		$cantidad		= $this->input->post('cantidad');
		$productos		= $this->input->post('productos');
		$preciosTotales	= $this->input->post('preciosTotales');
		$precioProducto	= $this->input->post('precioProducto');
		
		$subtotal		= $this->input->post('subTotal');
		$iva			= $this->input->post('iva');
		$total			= $this->input->post('total');
		$descuento		= 0;#$this->input->post('descuento');
		$idCliente		= $this->input->post('idCliente');
		$cliente		= $this->obtenerCliente($idCliente);
		$pago			= $this->input->post('pago');
		$idTienda		= $this->input->post('idTienda');

		#--------------------------ORDEN DE VENTAS----------------------------#
		$serie="COT-".date('Y-m-d').'-'.$folio;
		$venta="VEN-".$folio;
		#---------------------------------------------------------------------#

		$comentarios	="";
		$formaPago		=$this->configuracion->obtenerForma($idForma);
		$formaPago		=$formaPago!=null?$formaPago->nombre:'';
		
		$metodoPago		=$formaPago.' '.$this->obtenerDigitosCuenta($this->input->post('idCuenta'));
		
		$data=array
		(
			'ordenCompra'			=> $venta,
			'idCliente'				=> $idCliente,
			'fecha'					=> $this->_fecha_actual,
			'fechaPedido'			=> $this->input->post('fechaVenta'),
			'fechaEntrega'			=> $this->input->post('fechaVenta'),
			'fechaCompra'			=> $this->input->post('fechaVenta'),
			'serie'					=> $serie,
			'estatus'				=> '1',
			'idUsuario'				=> $this->_iduser,
			'pago'					=> $pago,
			'cambio'				=> $this->input->post('cambio'), 			
			'subTotal'				=> $subtotal,
			'descuento'				=> $this->input->post('descuento'),
			'descuentoPorcentaje'	=> $this->input->post('descuentoPorcentaje'),
			'ivaPorcentaje'			=> $this->input->post('ivaPorcentaje'),
			'iva'					=> $this->input->post('iva'),
			'total'					=> $total,
			'folio'					=> $folio,
			'idLicencia'			=> $this->idLicencia,
			'comentarios'			=> $comentarios,
			'idDivisa'				=> $divisa->idDivisa,
			'tipoCambio'			=> $divisa->tipoCambio,
			'condicionesPago'		=> $this->input->post('condicionesPago'), 
			'formaPago'				=> $this->input->post('formaDePago'), 
			'facturar'				=> $this->input->post('facturar'), 
			'observaciones'			=> $this->input->post('observaciones'),
			'metodoPago'			=> $metodoPago, 
			'observaciones'			=> $this->input->post('observaciones'), 
			'diasCredito'			=> $this->input->post('diasCredito'), 
			'idForma'				=> $idForma,
			'idTienda'				=> $idTienda,
		);
		
		$this->db->insert('cotizaciones',$data);
		$idCotizacion	=$this->db->insert_id();
		
		$this->procesarProductosVenta($idCotizacion,$cantidad,$productos,$preciosTotales,$precioProducto,$idTienda);
		
		if($pago>0)
		{
			$this->realizarPagoVenta($idCotizacion,$folio,$pago,$total,$idCliente); //Realizar el pago de la venta
		}
		
		if($pago<$total)
		{
			$this->realizarPagoProgramado($idCotizacion,$folio,$idCliente,$pago,$total); //Pago programado
		}

		if($this->resultado=="1")
		{
			$this->crearCFDI($idCotizacion,$cliente); 
		}
		
		$data		= array(); //Vaciar el array
		
		if ($this->db->trans_status() === FALSE or $this->resultado!="1")
		{
			$this->db->trans_rollback(); #Revertir si hubo algun fallo en las actualizaciones
			$this->db->trans_complete();
			
			
			$data[0]	= "0";
			$data[1]	= $this->resultado;
			
			return $data;
		}
		else
		{
			$this->db->trans_commit(); #Guargar los cambios si todo ha sido correcto
			$this->db->trans_complete();
			
			
			$data[0]	= "1";
			$data[1]	= $this->resultado;
			$data[2]	= $this->facturaId;
			
			return $data;
		}
	}
	
	public function obtenerDetallesServicio($idProducto)
	{
		$sql=" select manoObra, refacciones
		from productos
		where idProducto='$idProducto' ";
		
		return $this->db->query($sql)->row();
	}
	
	public function obtenerPeriodo($idPeriodo)
	{
		$sql="select * from produccion_periodos
		where idPeriodo='$idPeriodo' ";
		
		return $this->db->query($sql)->row();
	}
	
	public function obtenerFechaFinServicio($valor,$factor,$fecha)
	{
		$sql="select date_add('".$fecha."',interval ".$valor." $factor) as fechaFin";
		
		return $this->db->query($sql)->row()->fechaFin;
	}
	
	public function procesarProductosVenta($idCotizacion,$cantidad,$productos,$preciosTotales,$precioProducto,$idTienda)
	{
		$servicios		= $this->input->post('servicios');
		$fechas			= $this->input->post('fechas');
		$nombres		= $this->input->post('nombres');
		$descuentos		= $this->input->post('descuentos');
		
		for($i=0;$i<count($cantidad);$i++)
		{
			$descuento	= explode('|',$descuentos[$i]);
			
			$data=array
			(
				'idCotizacion' 			=> $idCotizacion,
				'cantidad' 				=> $cantidad[$i],
				'precio' 				=> $precioProducto[$i],
				'importe' 				=> $preciosTotales[$i],
				'idProduct' 			=> $productos[$i],
				'tipo' 					=> $precioProducto[$i],
				'nombre' 				=> $nombres[$i],
				'servicio' 				=> $servicios[$i],
				'fechaInicio' 			=> $this->_fecha_actual,
				'fechaVencimiento' 		=> $this->_fecha_actual,
				'notificar' 			=> 0,
				'facturado' 			=> '0',
				
				'descuento' 			=> $descuento[1],
				'descuentoPorcentaje'	=> $descuento[0],
			);
			
			if($this->input->post('mostrador')==0)
			{
				$data['enviado']		=1;
				$data['entregado']		=1;
				$data['produccion']		=1;
			}
			
			/*if($servicios[$i]!=0)
			{
				$data['servicio']			=1;
				
				if($servicios[$i]!=8)
				{
					$periodo					= $this->obtenerPeriodo($servicios[$i]);
					$fechaFin					= $this->obtenerFechaFinServicio($periodo->valor*$cantidad[$i],$periodo->factor,$fechas[$i]);
					
					$data['fechaInicio']		= $fechas[$i];
					$data['fechaVencimiento']	= $fechaFin;
					$data['notificar']			= 1;
				}
			}*/
			
			$this->db->insert('cotiza_productos',$data);
			
			$idProductoCotizacion=$this->db->insert_id();
			#----------------------------------------------------------------------------------------------------------#
			
			if($this->input->post('mostrador')==0)
			{
				if($servicios[$i]==0)
				{
					$this->actualizarStockProducto($productos[$i],$idProductoCotizacion,$cantidad[$i],$idTienda);	
				}
				
				$this->entregarProductos($idProductoCotizacion,$cantidad[$i]);
			}
			#----------------------------------------------------------------------------------------------------------#
		}
	}
	
	public function entregarProductos($idProductoCotizacion,$cantidad)
	{
		$data=array
		(
			'fecha' 		=>$this->_fecha_actual,
			'cantidad' 		=>$cantidad,
			'entrego' 		=>$this->session->userdata('nombreUsuarioSesion'),
			'idProducto' 	=>$idProductoCotizacion
		);
		
		$this->db->insert('ventas_entrega_detalles',$data);
	}
	
	/*public function obtenerStockProducto($idProducto,$idTienda=0)
	{
		$sql =" select ".($idTienda==0?"c.stock":" (select coalesce(sum(d.cantidad),0) from tiendas_productos as d where d.idProducto=a.idProducto) as stock ").", c.idProducto
		from productos as a
		inner join rel_producto_produccion as b
		on a.idProducto=b.idProducto
		inner join produccion_productos as c
		on c.idProducto=b.idProductoProduccion  
		where a.idProducto='$idProducto' ";
		
		return $this->db->query($sql)->row();
	}*/
	
	public function obtenerStockProducto($idProducto,$idTienda=0)
	{
		$sql =" select ".($idTienda==0?"a.stock":" (select coalesce(sum(d.cantidad),0) from tiendas_productos as d where d.idProducto=a.idProducto and d.idTienda='$idTienda') as stock ").", a.idProducto
		from productos as a
		where a.idProducto='$idProducto' ";
		
		return $this->db->query($sql)->row();
	}

	public function actualizarStockProducto($idProducto,$idProductoCotizacion,$cantidad,$idTienda)
	{
		$producto	= $this->obtenerStockProducto($idProducto,$idTienda);
		
		if($producto->stock<$cantidad)
		{
			$this->resultado="No existen suficientes productos para realizar la factura";
			
			return 0;
		}
		else
		{
			if($idTienda==0)
			{
				$data=array
				(
					'stock' => $producto->stock-$cantidad
				);
				
				/*$this->db->where('idProducto',$producto->idProducto);
				$this->db->update('produccion_productos',$data);*/
				
				$this->db->where('idProducto',$idProducto);
				$this->db->update('productos',$data);
			}
			
			if($idTienda>0)
			{
				$data=array
				(
					'cantidad' =>$producto->stock-$cantidad
				);
				
				$this->db->where('idProducto',$producto->idProducto);
				$this->db->where('idTienda',$idTienda);
				$this->db->update('tiendas_productos',$data);
			}
			
		#----------------------------------------------------------------------------------------------------------#
		}
	}
	
	public function realizarPagoVenta($idVenta,$folio,$pago,$total,$idCliente)
	{
		$anticipo				=$pago<$total?'Anticipo ':'';
		
		$data = array
		(
			'idVenta'			=>$idVenta,
			'idCliente'			=>$idCliente,
			'idCuenta'			=>$this->input->post('idCuenta'),
			'pago'				=>$pago>=$total?$total:$pago,
			'nombreReceptor'	=>$this->input->post('nombreReceptor'),
			'transferencia'		=>$this->input->post('numeroTransferencia'),
			'cheque'			=>$this->input->post('numeroCheque'),
			'formaPago'			=>'',
			'fecha'				=>$this->_fecha_actual,
			'idLicencia'		=>$this->idLicencia,
			'concepto'			=>$anticipo.'VEN-'.$folio,
			'producto'			=>$anticipo.'VEN-'.$folio,
			#'idGasto'			=>1,
			#'idProducto'		=>1,
			'iva'				=>$this->session->userdata('iva'),
			'nombreReceptor'	=>'',
			'incluyeIva'		=>1,
			#'idDepartamento'	=>1,
			#'idNombre'			=>1,
			'idForma'			=>$this->input->post('idForma'),
		);
		
		$this->db->insert('catalogos_ingresos',$data);
	}
	
	public function realizarPagoProgramado($idVenta,$folio,$idCliente,$pago,$total)
	{
		$idCuenta	=$this->input->post('idCuenta');
		#$idCuenta	=$idCuenta==0?1:$idCuenta;
		
		$data = array
		(
			'idVenta'			=>$idVenta,
			'idCuenta'			=>$idCuenta,
			'idCliente'			=>$idCliente,
			'pago'				=>$total-$pago,
			'nombreReceptor'	=>$this->input->post('nombreReceptor'),
			'transferencia'		=>'',
			'cheque'			=>'',
			'formaPago'			=>'',
			'fecha'				=>$this->obtenerFechaFinServicio($this->input->post('diasCredito'),'day',$this->input->post('fechaVenta')),
			'idLicencia'		=>$this->idLicencia,
			'concepto'			=>'VEN-'.$folio,
			'producto'			=>'VEN-'.$folio,
			#'idGasto'			=>1,
			#'idProducto'		=>1,
			'iva'				=>$this->session->userdata('iva'),
			'nombreReceptor'	=>'',
			'incluyeIva'		=>1,
			#'idDepartamento'	=>1,
			#'idNombre'			=>1,
			'notificacion'		=>'1',
			'idForma'			=>'4',
		);
		
		$this->db->insert('catalogos_ingresos',$data);
	}
	
	//TODO AQUI  PARA LA FACTURACIÓN
	public function obtenerFolio()
	{
		$serie			=$this->session->userdata('serie');
		$folioInicio	=$this->session->userdata('folioInicio');
		$folioFinal		=$this->session->userdata('folioFinal');
		
		$sql=" 	select max(folio) as folio
		from facturas
		where idLicencia='$this->idLicencia' ";
		
		if(strlen($serie)>0)
		{
			$sql.=" and serie='".$serie."'";
		}
		
		$folio=$this->db->query($sql)->row()->folio;
		
		if($folio==null)
		{
			$folio=$folioInicio;
		}
		else
		{
			$folio++;
		}
		
		if($folio>$folioFinal)
		{
			$folio=-1;
		}
		
		return $folio;
	}
	
	public function obtenerCliente($idCliente)
	{
		$sql="select * from clientes
		where idCliente='$idCliente'";
		
		return $this->db->query($sql)->row();
	}
	
	public function obtenerConfiguracion()
	{
		$sql="select * from configuracion ";
		
		return $this->db->query($sql)->row();
	}
	
	public function obtenerProductosCotizacion($idCotizacion)
	{
		$sql="select a.*, b.nombre as producto, 
		b.precioA, b.unidad, b.codigoInterno
		from cotiza_productos as a
		inner join productos as b
		on a.idProduct=b.idProducto
		where a.idCotizacion='$idCotizacion'";
		
		$query = $this->db->query($sql);
		
		return ($query->num_rows() > 0) ? $query->result() : NULL;
	}
	
	public function obtenerCotizacion($idCotizacion)
	{
		$sql="select * from cotizaciones
		where idCotizacion='$idCotizacion'";
		
		return $this->db->query($sql)->row();
	}
	
	public function obtenerCotizacionFactura($idCotizacion)
	{
		$sql="select a.*, b.nombre as forma
		from cotizaciones as a
		inner join catalogos_formas as b
		on a.idForma=b.idForma
		where a.idCotizacion='$idCotizacion'";
		
		return $this->db->query($sql)->row();
	}

	#------------------------------------------------------------------------------------------------------#
	
	public function verificarStockProductos($productos)
	{
		foreach($productos as $row)
		{
			$sql="select b.stock
			from rel_producto_produccion as a
			inner join produccion_productos as b
			on b.idProducto=a.idProductoProduccion
			where a.idProducto='$row->idProduct'";
			
			$query=$this->db->query($sql)->row();
			
			if($row->cantidad>$query->stock)
				return 1;
		}
		
		return 0;
	}
	
	#------------------------------------------------------------------------------------------------------#
	public function crearCFDI($idCotizacion,$cliente)
   {
		$this->load->helper('sat');
		
		#$idCotizacion			=$this->input->post('idCotizacion');
		$idEmisor				= $this->input->post('idEmisor');
		$configuracion			= $this->facturacion->obtenerEmisor($idEmisor);
		$cotizacion				= $this->obtenerCotizacion($idCotizacion);
		#$cliente				=$this->obtenerCliente($idCliente);
		#$comprobante			=$this->input->post('tipoComprobante');
		$divisa					= $this->obtenerDivisa($this->input->post('idDivisa'));
		
		$retenciones['importe']	=0;#$this->input->post('retencion');
		$retenciones['tasa']	=0;#$this->input->post('tasa');
		$retenciones['nombre']	='';#$this->input->post('nombre');

		$productos				= $this->obtenerProductosCotizacion($cotizacion->idCotizacion);

		if(strlen($cliente->rfc)<12 
		or strlen($cliente->empresa) <3
		or strlen($cliente->pais) <3 )
		{
			$this->resultado="El cliente seleccionado no tiene los datos fiscales necesario para crear la factura";
			return 0;
		}
		
		$folio	=$this->facturacion->obtenerFolio($idEmisor);
		
		if($folio<1)
		{
			$this->resultado=" Sin folio suficientes para crear la factura";
			return 0;
		}
		
		$carpetaUsuario		= carpetaCfdi.$configuracion->rfc.'/';
		$carpetaFolio		= $carpetaUsuario.'folio'.$configuracion->serie.$folio.'/';
		$cfd				= $carpetaFolio.'cfd'.$folio.'.xml';
		
		crearDirectorio($carpetaFolio);
		
		$sello				="";
		$certificado		="";

		
 		$ficheroXML=xmFacturaVenta($configuracion,$cliente,$productos,$sello,$certificado,$this->_fecha_actual,$folio,$cotizacion,$retenciones,$divisa);

		guardarArchivoXML($cfd,$ficheroXML);
		
		exec("xsltproc ".carpetaCfdi.'cadenaoriginal_3_2.xslt'." ".$cfd." > ".$carpetaFolio.'cadena.txt');

		exec("openssl pkcs8 -inform DER -in ".$carpetaUsuario.$configuracion->llave." -passin pass:".$configuracion->passwordLlave." -out ".$carpetaFolio.'certificado.txt');
		exec("openssl dgst -sha1 -sign ".$carpetaFolio."certificado.txt ".$carpetaFolio."cadena.txt | openssl enc -base64 -A > ".$carpetaFolio.'sello.txt');
		exec("openssl enc -base64 -in ".$carpetaUsuario.$configuracion->certificado." -out ".$carpetaFolio.'certificadoImprimir.txt');
		
		$certificado	=leerFichero($carpetaFolio.'certificadoImprimir.txt',"READ","");
		$certificado 	=QuitarEspaciosXML($certificado,"B");
		$sello			=leerFichero($carpetaFolio.'sello.txt',"READ","");
		$sello 			=QuitarEspaciosXML($sello,"B");
		
		$cadena			=leerFichero($carpetaFolio.'cadena.txt',"READ","");
		#$selloDigital=str_replace(" ","",$SelloTxtPrint); #Esto se guardara en BD
		
		#$ficheroXML=RegresaXMLFormato($configuracion,$cliente,$productos,$sello,$certificado,$this->_fecha_actual,$folio,$cotizacion);
		
		
		$ficheroXML=xmFacturaVenta($configuracion,$cliente,$productos,$sello,$certificado,$this->_fecha_actual,$folio,$cotizacion,$retenciones,$divisa); 
		

		if(guardarArchivoXML($cfd,$ficheroXML))
		{
			#$this->obtenerTimbrado($ficheroXML,$folio,$carpetaFolio,$sello,$cadena,$cotizacion,$cliente,$configuracion);
			#$this->timbrarXML($ficheroXML,$folio,$carpetaFolio,$sello,$cadena,$cotizacion,$cliente,$configuracion);
			$this->timbrarFactor($ficheroXML,$folio,$carpetaFolio,$sello,$cadena,$cotizacion,$cliente,$configuracion,$productos);
		}
	}
	
	public function timbrarFactor($ficheroXML,$folio,$carpetaFolio,$sello,$cadena,$cotizacion,$cliente,$configuracion,$productos)
	{
		$this->load->library('factor');
		
		$config			=$this->obtenerConfiguracion();
		$timbrado 		= new Factor();
		$respuesta 		= $timbrado->obtenerTimbre($config->usuarioFactor, $config->passwordFactor, $ficheroXML);

		if(!$respuesta['estatus'])
		{
			#echo trim($respuesta['estatus']);
			
			$this->resultado=$respuesta['mensaje'];
			return 0;
		}
		
		if($respuesta['estatus'])
		{
			$timbre		=$carpetaFolio.'cfdi'.$folio.'Timbre.xml'; #Es el archivo XML Timbrado
			$fichero	=fopen($timbre,"w");	
			fwrite($fichero,$respuesta['xml']);
			fclose($fichero);
			
			$data['xml']			=$respuesta['xml'];
			$data['folio']			=$folio;
			$data['cadenaTimbre']	=$respuesta['cadenaTimbre'];
			$data['cadenaOriginal']	=$cadena;
			$data['selloDigital']	=$sello;
			$data['UUID']			=$respuesta['uuid'];
			$data['fechaTimbrado']	=$respuesta['fechaTimbrado'];
			$data['selloSat']		=$respuesta['selloSat'];
			$data['certificado']	=$respuesta['certificado'];
			
			$this->session->set_userdata('notificacion',"El cfdi se ha creado correctamente");
			$this->agregarFactura($data,$cotizacion,$cliente,$configuracion,$productos);
		}
	}

	public function obtenerDivisa($idDivisa)
	{
		$sql="select * from divisas
		where idDivisa='$idDivisa' ";
		
		return $this->db->query($sql)->row();
	}
	
	public function formaPago()
	{
		$formaPago		=$this->input->post('formaPago');
		$cheque			=$this->input->post('numeroCheque');
		$transferencia	=$this->input->post('numeroTransferencia');
		
		switch($formaPago)
		{
			case "1":
			$formaPago			="Efectivo";
			break;
			
			case "2":
			$formaPago			="Cheque";
			break;
			
			case "3":
			$formaPago			="Transferencia";
			break;
		}
		
		return $formaPago;
	}
	
	public function agregarFactura($timbre,$cotizacion,$cliente,$configuracion,$productos)
	{
		#$productos	=$this->obtenerProductosCotizacion($cotizacion->idCotizacion); 

		$retenciones['importe']	=0;#$this->input->post('retencion');
		$retenciones['tasa']	=0;#$this->input->post('tasa');
		$retenciones['nombre']	='';#$this->input->post('nombre');
		
		if($retenciones['importe']>0)
		{
			$total=$total-$retenciones['importe'];
		}
		
		$divisa		=$this->obtenerDivisa($this->input->post('idDivisa'));
		
		$data=array
		(
			'rfc'				=> $cliente->rfc,
			'empresa'			=> $cliente->empresa,
			'calle'				=> $cliente->calle,
			'numeroExterior'	=> $cliente->numero,
			'colonia'			=> $cliente->codigoPostal,
			'localidad'			=> $cliente->localidad,
			'municipio'			=> $cliente->municipio,
			'estado'			=> $cliente->estado,
			'pais'				=> $cliente->pais,
			'codigoPostal'		=> $cliente->codigoPostal,
			'subTotal'			=> $cotizacion->subTotal,
			'iva'				=> $cotizacion->iva,
			'ivaPorcentaje'		=> $cotizacion->ivaPorcentaje,
			'descuento'				=> $cotizacion->descuento,
			'descuentoPorcentaje'	=> $cotizacion->descuentoPorcentaje,
			'total'				=> $cotizacion->total,
			'folio'				=> $timbre['folio'],
			'fecha'				=> $this->_fecha_actual,
			'xml'				=> $timbre['xml'],
			'cadenaOriginal'	=> $timbre['cadenaOriginal'],
			'selloSat'			=> $timbre['selloSat'],
			'selloDigital'		=> $timbre['selloDigital'],
			'UUID'				=> $timbre['UUID'],
			'certificadoSat'	=> $timbre['certificado'],
			'cadenaTimbre'		=> $timbre['cadenaTimbre'],	
			'fechaTimbrado'		=> $timbre['fechaTimbrado'],
			'idLicencia'		=> $this->idLicencia,
			'idCotizacion'		=> $cotizacion->idCotizacion,
			'idCliente'			=> $cotizacion->idCliente,
			'documento'			=> 'FACTURA',
			'tipoComprobante'	=> 'ingreso',
			'serie'				=> $configuracion->serie,
			'condicionesPago'	=> $this->input->post('condiciones'),
			'metodoPago'		=> $this->input->post('metodoPagoTexto'),
			'formaPago'			=> $this->input->post('formaDePago'),
			'observaciones'		=> $this->input->post('observaciones'),
			'parcial'			=> 0,
			
			'divisa'			=> $divisa->nombre,
			'claveDivisa'		=> $divisa->clave,
			'tipoCambio'		=> $divisa->tipoCambio,
			
			'idEmisor'			=> $this->input->post('idEmisor'),
		);
		
		$this->db->insert('facturas',$data);
		$idFactura 			= $this->db->insert_id();
		$this->facturaId	=$idFactura;
		#$this->resultado	="1";
		#-------------------------------------------------------------------------------------#
		$data=array();
		$data['encriptacion']	=sha1("'".$idFactura.$timbre['fechaTimbrado']."'"); 
		
		$this->db->where('idFactura',$idFactura); 
		$this->db->update('facturas',$data);
		
		#GUARDAR EL DETALLE DE PRODUCTOS Y ASOCIAR LA FACTURA PARCIAL EN CASO DE SER NECESARIO
		#-------------------------------------------------------------------------------------#
		
		$data=array
		(
			'idCotizacion'		=>$cotizacion->idCotizacion,
			'idFactura'			=>$idFactura,
			'porcentaje'		=>0,
		);
		
		$this->db->insert('rel_factura_cotizacion',$data);
		
		#GUARDAR EL DETALLE DE PRODUCTOS
		#-------------------------------------------------------------------------------------#
	
		foreach($productos as $row)
		{
			$data=array
			(
				'idFactura'				=> $idFactura,
				'idProducto'			=> $row->idProducto,
				'nombre'				=> $row->nombre,
				'unidad'				=> $row->unidad,
				'precio'				=> $row->precio,
				'importe'				=> $row->importe,
				'cantidad'				=> $row->cantidad,
				'codigoInterno'			=> $row->codigoInterno,
				'descuento'				=> $row->descuento,
				'descuentoPorcentaje'	=> $row->descuentoPorcentaje,
			);
			
			$this->db->insert('facturas_detalles',$data);
		}
		
		#-------------------------------------------------------------------------------------#
		
		
		$data=array
		(
			'idFactura'	=>$idFactura,
			'idCliente'	=>$cliente->idCliente
		);
		
		$this->db->where('idCotizacion',$cotizacion->idCotizacion); 
		$this->db->update('cotizaciones',$data);
		
		/*
		if($retenciones['importe']>0)
		{
			$data=array
			(
				'idFactura'		=>$idFactura,
				'retencion'		=>$retenciones['nombre'],
				'tasa'			=>$retenciones['tasa'],
				'importe'		=>$retenciones['importe'],
				'idCotizacion'	=>$cotizacion->idCotizacion,
			);
			
			$this->db->insert('facturas_retenciones',$data);
		}*/
	}

	public function obtenerProductosFactura($idCotizacion)
	{
		$sql="select a.idProducto, a.cantidad, a.precio, 
		a.importe, b.nombre, b.unidad
		from cotiza_productos as a
		inner join productos as b
		on(a.idProduct=b.idProducto)
		where a.idCotizacion='".$idCotizacion."'";
		
		$query = $this->db->query($sql);
		
		return ( $query->num_rows() > 0) ? $query->result() : NULL;
	}
	
	public function obtenerProductosFacturados($idFactura)
	{
		$sql=" select a.*, c.codigoInterno
		from facturas_detalles as a
		inner join cotiza_productos as b
		on a.idProducto=b.idProducto
		inner join productos as c
		on c.idProducto=b.idProduct
		where idFactura='$idFactura' ";
		
		$sql.=" union ";
		$sql.=" select a.*, '' as codigoInterno
		from facturas_detalles as a
		where idFactura='$idFactura'
		and idProducto=0 ";
		
		$query = $this->db->query($sql);
		
		return ( $query->num_rows() > 0) ? $query->result() : NULL;
	}

	public function obtenerProductosProductos($idCotizacion)
	{
		$sql="  select a.precio, a.cantidad, a.importe,
		b.nombre as descripcion, a.servicio, c.nombre as periodo,
		a.nombre as producto, b.medida, b.rin, b.codigoInterno,
		a.servicio, b.unidad, a.descuento, a.descuentoPorcentaje,
		a.idProducto, a.nombre, a.idProduct
		from cotiza_productos as a
		inner join productos as b
		on a.idProduct=b.idProducto
		inner join produccion_periodos as c
		on b.idPeriodo=c.idPeriodo
		where a.idCotizacion='$idCotizacion' 
		and a.servicio=0 ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerProductosRefacciones($idCotizacion)
	{
		$sql="  select a.cantidad, a.importe,
		b.nombre as descripcion, a.servicio, c.nombre as periodo,
		a.nombre as producto, b.medida, b.rin, b.codigoInterno,
		a.servicio, b.unidad, a.descuento, a.descuentoPorcentaje,
		a.refacciones as precio, a.idProducto, a.nombre
		from cotiza_productos as a
		inner join productos as b
		on a.idProduct=b.idProducto
		inner join produccion_periodos as c
		on b.idPeriodo=c.idPeriodo
		where a.idCotizacion='$idCotizacion' 
		and a.servicio=1
		and a.refacciones>0 ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerProductosMano($idCotizacion)
	{
		$sql="  select a.cantidad, a.importe,
		b.nombre as descripcion, a.servicio, c.nombre as periodo,
		a.nombre as producto, b.medida, b.rin, b.codigoInterno,
		a.servicio, b.unidad, a.descuento, a.descuentoPorcentaje,
		sum(a.manoObra) as precio
		from cotiza_productos as a
		inner join productos as b
		on a.idProduct=b.idProducto
		inner join produccion_periodos as c
		on b.idPeriodo=c.idPeriodo
		where a.idCotizacion='$idCotizacion' 
		and a.servicio=1
		and a.manoObra>0
		group by a.idCotizacion ";
		
		return $this->db->query($sql)->row();
	}
	
	public function timbrarXML($archivoXML,$folio,$ruta,$selloDigital,$cadena,$cotizacion,$cliente,$configuracion)
	{
		#$ComprobanteXML = $comprobante;
		$this->load->library('timbrado');
		$this->load->library('seguridad');
		
		$integrador 		= "2b3a8764-d586-4543-9b7e-82834443f219";
		#$integrador 		= "d8ff5d28-9fc3-4097-b683-966a1a634f75";
		#$rfc = "SUL010720JN8";
		$rfc 			= $configuracion->rfc;
		
		$token 			= new Seguridad();
		$transaccion 	= rand(1, 10000);
		$generaToken 	= $token->setToken($rfc, $transaccion, $integrador);
		$tokenGenerado 	= $token->getToken();

		$Timbra 		= new Timbrado();
		$timbrar 		= $Timbra->setTimbrado($archivoXML, $rfc, $transaccion, $tokenGenerado);                               
		$cfdi 			= $Timbra->getTimbrado();
		
		#echo $archivoXML;
		#echo 'cfdi: '.$cfdi;
		
		if($timbrar)
        {
			#=================================================================================#
			$timbre		=$ruta.'cfdi'.$folio.'Timbre.xml'; #Es el archivo XML Timbrado
			#$timbre='media/timbre.xml'; #Es el archivo XML Timbrado
			$fichero	=fopen($timbre,"w");	
			fwrite($fichero,$cfdi);
			fclose($fichero);
			
			#=================================================================================#
			$UUID			="";
			$fechaTimbrado	="";
			$sello			="";
			$certificado	="";
			$cadenaTimbre	="";
			$rutaFicheros	='media/fel/';
			$cadenaOriginal	=$ruta.'cadenaTimbre'.$folio.'.txt';
			$selloSat		=$ruta.'selloSat'.$folio.'.txt';
			
			$timbre			=$ruta.'cfdi'.$folio.'Timbre.xml'; #Es el archivo XML Timbrado
			
			exec("xsltproc ".$rutaFicheros.'convertir.xslt'." ".$timbre." > ".$cadenaOriginal);
			$cadenaTimbre	=openFile($cadenaOriginal,"READ","");
			
			$selloSat		=$ruta.'selloSat'.$folio.'.txt';
			
			exec("xsltproc ".$rutaFicheros.'selloSat.xslt'." ".$timbre." > ".$selloSat);
			$datosSello		=openFile($selloSat,"READ","");
			$tamano			=strlen($datosSello);
	
			$b=0;
			
			for($i=0;$i<$tamano;$i++)
			{
				if($b==1)
				{
					if($datosSello[$i]!="*")
					{
						$UUID.=$datosSello[$i];
					}
				}
				
				if($b==2)
				{
					if($datosSello[$i]!="*")
					{
						$fechaTimbrado.=$datosSello[$i];
					}
				}
				
				if($b==3)
				{
					if($datosSello[$i]!="*")
					{
						$sello.=$datosSello[$i];
					}
				}
				
				if($b==4)
				{
					if($datosSello[$i]!="*")
					{
						$certificado.=$datosSello[$i];
					}
				}
				
				if($datosSello[$i]=="*")
				{
					$b++;
				}
			}
			
			$data['xml']			=$cfdi;
			$data['folio']			=$folio;
			$data['cadenaTimbre']	=$cadenaTimbre;
			$data['cadenaOriginal']	=$cadena;
			$data['selloDigital']	=$selloDigital;
			$data['UUID']			=$UUID;
			$data['fechaTimbrado']	=$fechaTimbrado;
			$data['selloSat']		=$sello;
			$data['certificado']	=$certificado;
			
			#$selloDigital=openFile($sello,"READ","");
			
			if(strlen($UUID)>3)
			{
				//$this->session->set_userdata('notificacion',"El cfdi se ha creado correctamente");
				$this->agregarFactura($data,$cotizacion,$cliente);
			}
			else
			{
				#$this->session->set_userdata('errorNotificacion',$cfdi);
				
				#$this->db->trans_rollback(); #Revertir si hubo algun fallo en las actualizaciones
				#$this->db->trans_complete();
				
				$this->resultado=$cfdi;
			}
		}
		else
		{
			#$this->session->set_userdata('errorNotificacion',$cfdi);
			
			#$this->db->trans_rollback(); #Revertir si hubo algun fallo en las actualizaciones
			#$this->db->trans_complete();
				
			$this->resultado=$cfdi;
		}
	}
}
?>
