<?php
class ExpedienteM_model extends CI_Model
{
  	protected $fecha;
  	protected $idUsuario;

  	function __construct()
  	{
  		parent::__construct();
        $this->db_r = $this->load->database('resgitro', TRUE);
  	}

    public function obtenerAlumnos()
    {
        
        $this->db->select('a.*,c.nombre as nombre, c.paterno as paterno, c.materno as materno, cp.nombre as programa');
        $this->db->from('clientes_academicos a');
        $this->db->join("clientes c","a.idCliente = c.idCliente","left");
        $this->db->join("clientes_programas cp","a.idPrograma = cp.idPrograma","left");
        $this->db->join("clientes_programas_grados cpg","cp.idGrado = cpg.idGrado");
        $this->db->where('matricula !=','');
        $this->db->where('matricula !=',NULL);
        $this->db->where('cp.activo =',1);
        $this->db->where('cpg.idGrado !=',4);
        $this->db->where('c.activo =',1);
        $result = $this->db->get();
        return $result->result_array();
    }

    public function get_expediente($id)
    {
      $this->db_r->select('*');
      $this->db_r->from('registro');
      $this->db_r->where('matricula',$id);
      $query = $this->db_r->get();
      $result = $query->row_array();
      return $result;
    }

    public function get_expediente_complemento($matricula)
    {
      $this->db->select('a.*,cpp.nombre as periodo');
      $this->db->from('clientes_academicos a');
      $this->db->join("clientes c","a.idCliente = c.idCliente","left");
      $this->db->join("clientes_programas cp","a.idPrograma = cp.idPrograma","left");
      $this->db->join("clientes_programas_grados cpg","cp.idGrado = cpg.idGrado");
      $this->db->join("clientes_programas_periodos cpp","cp.idPeriodo = cpp.idPeriodo");
      $this->db->where('matricula',$matricula);
      $query = $this->db->get();
      $result = $query->row_array();
      return $result;
    }

    public function get_pagos($id)
    {
      $query = $this->db->query('select a.fecha, a.pago, a.producto,
      b.nombre as forma, d.nombre as banco, a.idProducto as id_producto
      from catalogos_ingresos as a
      inner join catalogos_formas as b
      on a.idForma=b.idForma
      inner join cuentas as c
      on c.idCuenta=a.idCuenta
      inner join bancos as d
      on d.idBanco=c.idBanco
      where a.idCliente='.$id.'
      and a.idForma!=4');
      if ($query->num_rows() > 0){
        return $query->result_array();
      }
      else{
        return FALSE;
      }
    }

    public function get_saldos($id,$tipo)
    {
      $this->db->select('(SELECT SUM(pago)) as total');
      $this->db->from('catalogos_ingresos');
      $this->db->where('idCliente',$id);
      $this->db->where('idProducto',$tipo);
      $query = $this->db->get();
      if ($query->num_rows() > 0){
       return $query->result()[0]->total;
     }else{
       return 0;
     }
    }

    public function id_plataforma($matricula)
    {
      $mat=substr($matricula,0,4);
      $m=substr($mat,0,1);
          if(preg_match("/L/",$matricula)) {
            $tipo=1;
          }elseif (preg_match("/MAPP/",$matricula)) {
            $tipo=2;
          }elseif (preg_match("/MEPP/",$matricula)) {
            $tipo=3;
          }elseif (preg_match("/MSPP/",$matricula)) {
            $tipo=4;
          }elseif (preg_match("/MFP/",$matricula) || preg_match("/MAN/",$matricula)) {
            $tipo=5;
          }elseif (preg_match("/D/",$m)) {
            $tipo=6;
          }
      //var_dump($matricula);
            switch($tipo){
              case'1':
                $CNXDB  = $this->load->database('licenciaturas', TRUE);
              break;

              case'2':
                $CNXDB = $this->load->database('mapp', TRUE);
              break;

              case'3':
                $CNXDB = $this->load->database('mepp', TRUE);
              break;

              case'4':
                $CNXDB = $this->load->database('mspp', TRUE);
              break;

              case'5':
                $CNXDB  = $this->load->database('maestrias', TRUE);
              break;

              case'6':
                $CNXDB  = $this->load->database('doctorado', TRUE);
              break;
            }
        $query = $CNXDB->query("SELECT id FROM mdl_user WHERE username = '$matricula'");
        if ($query->num_rows() > 0){
            $id=$query->result()[0]->id;
         }
         else{
            $id=0;
         }
         $query2 = $CNXDB->query('
             SELECT
               c.id as id_curso,
               ue.userid,
               c.fullname as nombre_curso,
               c.shortname,
               gg.finalgrade as calificacion,
               ue.status as estatus_enrolment,
               c.visible
               FROM
               mdl_user_enrolments ue LEFT JOIN mdl_enrol e
               ON  ue.enrolid = e.id
               LEFT JOIN mdl_course c
               ON e.courseid = c.id
               LEFT JOIN mdl_grade_items gi
               ON c.id = gi.courseid AND gi.itemtype = "course"
               LEFT JOIN mdl_grade_grades gg
               ON
               gi.id = gg.itemid
               AND (gg.userid = ue.userid)
               WHERE (c.fullname <> "Curso de Inducción")
               AND (c.fullname <> "Citar en formato APA")
               AND ue.userid = '.$id.'
               ORDER BY id_curso ASC');
    		    if ($query2->num_rows() > 0){
              return $query2->result_array();
            }
            else{
        			return FALSE;
        		}
    }


}
