<?php
class Estatus_modelo extends CI_Model
{
	protected $fecha;
	protected $idLicencia;
	protected $resultado;
	protected $idUsuario;

	function __construct()
	{
		parent::__construct();

        $this->idUsuario 		= $this->session->userdata('id');
		$this->idLicencia 		= $this->session->userdata('idLicencia');
		$datestring   			= "%Y-%m-%d %H:%i:%s";
		$this->fecha 			= mdate($datestring,now());
		$this->resultado		="1";
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//MATERIAS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarRegistros($criterio='')
	{    
		$sql=" select a.idEstatusCobranza
		from cobranza_estatus as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerRegistros($numero=0,$limite=0,$criterio='')
	{    
		$sql=" select a.idEstatusCobranza, a.nombre
		from cobranza_estatus as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerRegistro($idEstatusCobranza)
	{    
		$sql=" select * from cobranza_estatus 
		where idEstatusCobranza=$idEstatusCobranza ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarFormulario()
	{
		$data=array
		(
			'nombre'		=> $this->input->post('txtNombreEstatus'),
		);
		
	    $this->db->insert('cobranza_estatus',$data);

		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro); 
	}
	
	public function editarFormulario()
	{
		$data=array
		(
			'nombre'		=> $this->input->post('txtNombreEstatus'),
		);
		
		$this->db->where('idEstatusCobranza',$this->input->post('txtIdRegistro'));
	    $this->db->update('cobranza_estatus',$data);
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro); 
	}

	public function borrarRegistro($idEstatusCobranza)
	{
	    $this->db->where('idEstatusCobranza',$idEstatusCobranza);
		$this->db->update('cobranza_estatus',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?array('1','El registro se ha borrado correctamente'):array('0','Error al borrar el registro'); 
	}
	
	
	
}
