<?php
class Dashboard_modelo extends CI_Model
{
	protected $fecha;
	protected $idLicencia;
	protected $resultado;
	protected $idUsuario;

	function __construct()
	{
		parent::__construct();

        $this->idUsuario 		= $this->session->userdata('id');
		$this->idLicencia 		= $this->session->userdata('idLicencia');
		$this->fecha 			= date('Y-m-d H:i:s');
		$this->resultado		="1";
	}
	
	public function obtenerRegistrosFecha($fecha,$h1,$h2,$permiso)
	{
		$h2	= $h1.':59';
		$h1	= $h1.':00';

		$sql=" select a.idSeguimiento, b.empresa, c.idDetalle, c.observaciones,
		c.fechaRegistro, c.fechaSeguimiento, c.horaInicial, c.horaFinal, c.importe, 
		d.nombre as estatus, d.color as colorEstatus, e.nombre as dependencia, 
		f.nombre as contacto, g.nombre as temperatura, g.color as colorTemperatura,
		concat(h.nombre,' ', h.apellidoPaterno,' ',h.apellidoMaterno) as responsable

		from seguimiento as a 
		inner join clientes as b
		on a.idCliente=b.idCliente
		inner join seguimiento_detalles as c
		on a.idSeguimiento=c.idSeguimiento
		inner join seguimiento_estatus as d
		on c.idEstatus=d.idEstatus
		left join clientes_dependencias as e
		on b.idDependencia=e.idDependencia
		left join clientes_contactos as f
		on f.idCliente=b.idCliente
		left join clientes_temperaturas as g
		on g.idTemperatura=b.idTemperatura
		inner join usuarios as h
		on c.idResponsable=h.idUsuario

		where b.activo='1'
		and date(c.fechaSeguimiento)='$fecha'
		and time(c.horaInicial) between '".$h1."' and '".($h2)."' ";

	
		$sql.=$permiso[17]->activo=='0'?" and c.idResponsable='$this->idUsuario' ":'';

		$sql.="group by c.idDetalle, b.idCliente
		order by c.horaInicial asc";

		return $this->db->query($sql)->result();
	}
}