<?php
class Cobranza_modelo extends CI_Model
{
	protected $_fecha_actual;
	protected $_table;
	protected $idLicencia;
	protected $resultado;
	protected $_user_id;
	protected $fecha;
	protected $hora;
	protected $horaMedia;
	protected $idRol;

	function __construct()
	{
		parent::__construct();
		$this->config->load('datatables',TRUE);
		$this->_table 			= $this->config->item('datatables');

        $this->_user_id 		= $this->session->userdata('id');
		$this->idLicencia 		= $this->session->userdata('idLicencia');

		$datestring   			= "%Y-%m-%d %H:%i:%s";
		$this->_fecha_actual 	= mdate($datestring,now());
		$this->resultado		= "1";
		$this->fecha 			= date('Y-m-d');
		$this->hora 			= date('H:i:s');
		$this->horaMedia 		= date('H:i:00');
		$this->idRol 			= $this->session->userdata('role');
	}


	public function obtenerSeguimientoDiario()
	{
		//EL SEGUIMIENTO SERA POR DETALLES
		$sql=" select a.idSeguimiento, a.idCliente, a.comentarios, a.fechaSeguimiento, a.horaInicial, a. horaFinal,
		b.email, b.telefono, b.lada, b.movil, b.ladaMovil,
		concat(b.nombre, ' ', b.paterno, ' ', b.materno) as prospecto,
		concat(c.nombre, ' ', c.apellidoPaterno, ' ', c.apellidoMaterno) as usuario,
		d.matricula, e.nombre as programa

		from cobranza_seguimiento as a
		inner join clientes as b
		on a.idCliente=b.idCliente
		inner join usuarios as c
		on b.idPromotor=c.idUsuario

		inner join clientes_academicos as d
		on b.idCliente=d.idCliente

		inner join clientes_programas as e
		on e.idPrograma=e.idPrograma

		and date(a.fechaSeguimiento)='$this->fecha' ";


		$sql.=" and (select count(f.idSeguimiento) from cobranza_seguimiento as f
		where f.idCliente=a.idCliente and f.fechaSeguimiento>curdate()) =0 ";

		$sql.=" group by a.idSeguimiento
		order by a.horaInicial asc ";

		return $this->db->query($sql)->result();
	}

	public function obtenerSeguimientoDiarioFecha($fecha)
	{
		//EL SEGUIMIENTO SERA POR DETALLES
		$sql=" select a.idSeguimiento, a.idCliente, a.comentarios, a.fechaSeguimiento, a.horaInicial, a. horaFinal,
		b.email, b.telefono, b.lada, b.movil, b.ladaMovil,
		concat(b.nombre, ' ', b.paterno, ' ', b.materno) as prospecto,
		concat(c.nombre, ' ', c.apellidoPaterno, ' ', c.apellidoMaterno) as usuario,
		d.matricula, e.nombre as programa

		from cobranza_seguimiento as a
		inner join clientes as b
		on a.idCliente=b.idCliente
		inner join usuarios as c
		on b.idPromotor=c.idUsuario

		inner join clientes_academicos as d
		on b.idCliente=d.idCliente

		inner join clientes_programas as e
		on e.idPrograma=e.idPrograma

		and date(a.fechaSeguimiento)='$fecha' ";

		$sql.=" group by a.idSeguimiento
		order by a.horaInicial asc ";

		return $this->db->query($sql)->result();
	}

	public function obtenerTemas()
	{
		$sql=" select * from cobranza_temas
		where activo='1'
		order by idTema asc ";

		return $this->db->query($sql)->result();
	}

	public function obtenerContactos()
	{
		$sql=" select * from cobranza_contactos
		where activo='1'
		order by idContacto asc ";

		return $this->db->query($sql)->result();
	}

	public function obtenerSeguimientoDiarioCliente($idCliente)
	{
		//EL SEGUIMIENTO SERA POR DETALLES
		$sql=" select a.idSeguimiento, a.idCliente, a.comentarios, a.fechaSeguimiento, a.horaInicial, a. horaFinal,
		b.email, b.telefono, b.lada, b.movil, b.ladaMovil, a.fechaRegistro,
		concat(b.nombre, ' ', b.paterno, ' ', b.materno) as prospecto,
		concat(c.nombre, ' ', c.apellidoPaterno, ' ', c.apellidoMaterno) as usuario,
		d.matricula, e.nombre as programa
		from cobranza_seguimiento as a
		inner join clientes as b
		on a.idCliente=b.idCliente
		inner join usuarios as c
		on a.idUsuario=c.idUsuario
		inner join clientes_academicos as d
		on b.idCliente=d.idCliente
		inner join clientes_programas as e
		on e.idPrograma=d.idPrograma
		and a.idCliente='$idCliente'
	    order by a.fechaSeguimiento desc ";
		#echo $sql;
		return $this->db->query($sql)->result();
	}

	public function registrarSeguimiento()
	{
		$this->db->trans_start();

		$data=array
		(
			'fechaRegistro'		=> $this->_fecha_actual,
			'idCliente' 		=> $this->input->post('txtClienteId'),
			'comentarios' 		=> $this->input->post('txtComentarios'),
			'fechaSeguimiento' 	=> $this->input->post('chkPagado')=='0'?$this->input->post('txtFechaSeguimientoCobranza'):NULL,
			'horaInicial' 		=> $this->input->post('chkPagado')=='0'?$this->input->post('txtHoraCierre'):NULL,
			'horaFinal' 		=> $this->input->post('chkPagado')=='0'?$this->input->post('txtHoraCierreFin'):NULL,
			'alerta' 			=> $this->input->post('chkAlertaSeguimiento')=='1'?'1':'0',
			'idUsuario' 		=> $this->_user_id,
			'pagado' 			=> $this->input->post('chkPagado')=='1'?'1':'0',
		);

		$this->db->insert('cobranza_seguimiento', $data);
		$idSeguimiento	= $this->db->insert_id();

		//TEMAS
		$this->registrarTemasSeguimiento($idSeguimiento);

		//TEMAS
		$this->registrarContactosSeguimiento($idSeguimiento);

		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback();
			$this->db->trans_complete();

			return array("0",'Error en el registro');
		}
		else
		{
			$this->db->trans_commit();
			$this->db->trans_complete();

			return array("1",'El registro ha sido exitoso');
		}
	}

	public function registrarTemasSeguimiento($idSeguimiento=0)
	{
		$temas = $this->obtenerTemas();

		$i=0;
		foreach($temas as $row)
		{
			if($this->input->post('chkTema'.$i)>0)
			{
				$fecha=NULL;

				if($i==0)
				{
					if(strlen($this->input->post('txtFechaTema'))>2)
					{
						$fecha	= $this->input->post('txtFechaTema');
					}
				}

				$this->db->insert('cobranza_seguimiento_temas', array('idSeguimiento'=>$idSeguimiento,'idTema'=>$row->idTema,'fecha'=>$fecha));
			}

			$i++;
		}
	}

	public function registrarContactosSeguimiento($idSeguimiento=0)
	{
		$contactos = $this->obtenerContactos();

		$i=0;
		foreach($contactos as $row)
		{
			if($this->input->post('chkContacto'.$i)>0)
			{
				$this->db->insert('cobranza_seguimiento_contactos', array('idSeguimiento'=>$idSeguimiento,'idContacto'=>$row->idContacto));
			}

			$i++;

		}
	}

	//SEGUIMIENTO DE CLIENTES

	public function obtenerFormasContactoSeguimiento($idSeguimiento=0)
	{
		$sql=" select a.nombre
		from cobranza_contactos as a
		inner join cobranza_seguimiento_contactos as b
		on a.idContacto=b.idContacto
		where b.idSeguimiento='$idSeguimiento' ";

		return $this->db->query($sql)->result();
	}

	public function obtenerTemasSeguimiento($idSeguimiento=0)
	{
		$sql=" select a.nombre
		from cobranza_temas as a
		inner join cobranza_seguimiento_temas as b
		on a.idTema=b.idTema
		where b.idSeguimiento='$idSeguimiento' ";

		return $this->db->query($sql)->result();
	}

	public function contarSeguimientoCliente($idCliente,$inicio,$fin)
	{
		//EL SEGUIMIENTO SERA POR DETALLES
		$sql=" select count(a.idSeguimiento) as numero
		from cobranza_seguimiento as a
		where a.fechaSeguimiento between '$inicio' and '$fin'
		and a.idCliente='$idCliente' ";

		return $this->db->query($sql)->row()->numero;
	}

	public function obtenerSeguimientoCliente($numero,$limite,$idCliente,$inicio,$fin)
	{
		$sql=" select a.*
		from cobranza_seguimiento as a
		where fechaSeguimiento between '$inicio' and '$fin'
		and a.idCliente='$idCliente'
	    order by a.fechaRegistro desc ";

		$sql .= " limit $limite,$numero ";

		return $this->db->query($sql)->result();
	}

	public function editarEstatusCliente()
	{
		$data=array
		(
			'idEstatusCobranza'			=> $this->input->post('idEstatusCobranza'),
		);

		$this->db->where('idCliente', $this->input->post('idCliente'));
		$this->db->update('clientes', $data);

		return $this->db->affected_rows() >= 1? array("1",'El registro se ha editado correctamente') : array("0",'Error en el registro');
	}

	public function cont_reporte()
	{
		$this->db->select("COUNT(idCliente) as total");
    $this->db->from('cobranza_seguimiento');
    $query = $this->db->get();
    return $query->result()[0]->total;
	}

	public function reporte($params = array())
	{
		$i=0;
		$this->db->select('DISTINCT(c.idCliente) as cliente, cs.idSeguimiento as id, ca.idAcademico as academico ,CONCAT(c.nombre," ",c.paterno) as nombre,
		 ca.matricula as matricula, cp.nombre as programa,clp.nombre as periodo, ces.nombre as estatus,
		 DATE(cs.fechaRegistro) as fecha, cs.comentarios as comentario, ct.nombre as tema');
		$this->db->from('cobranza_seguimiento  cs');
		$this->db->join("clientes c","cs.idCliente = c.idCliente","left");
		$this->db->join("clientes_academicos ca","ca.idCliente = c.idCliente","left");
		$this->db->join("clientes_programas cp","cp.idPrograma = ca.idPrograma","left");
		$this->db->join("clientes_periodos_relacion cpr","cpr.idCliente = c.idCliente","left");
		$this->db->join("clientes_periodos clp","clp.idPeriodo = cpr.idPeriodo","left");
		$this->db->join("cobranza_estatus ces","ces.idEstatusCobranza = c.idEstatusCobranza","left");
		$this->db->join("cobranza_seguimiento_temas cst","cst.idSeguimiento = cs.idSeguimiento","left");
		$this->db->join("cobranza_temas ct","ct.idTema = cst.idTema","left");
		$this->db->where('ca.idPrograma !=',0);
		if (array_key_exists('inicio',$params) && $params['inicio']!=""   || $params['inicio']!=NULL) {
			$this->db->where('cs.fechaRegistro >=', $params['inicio']);
			$this->db->where('cs.fechaRegistro <=', $params['fin']);
			$this->db->group_by("ca.idAcademico");
			$this->db->order_by('nombre', 'ASC');
		}
		if(array_key_exists("start",$params) && array_key_exists("limit",$params)){
			  $this->db->group_by("ca.idAcademico");
        $this->db->order_by('nombre', 'ASC');
				$this->db->limit($params['limit'],$params['start']);
		}elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){
				$this->db->group_by("ca.idAcademico");
				$this->db->order_by('nombre', 'ASC');
				$this->db->limit($params['limit']);
		}
		if(array_key_exists("returnType",$params) && $params['returnType'] == 'count'){
			$this->db->group_by("ca.idAcademico");
			$this->db->order_by('nombre', 'ASC');
			$result = $this->db->count_all_results();
				//var_dump($result);
		}else{
			$query = $this->db->get();
			$result = ($query->num_rows() > 0)?$query->result_array():FALSE;
				if(!empty($result)) {
				$result=(array)$result;
						foreach ($result as $valor) {
							$this->db->select('cc.nombre');
							$this->db->from('cobranza_contactos cc');
							$this->db->join('cobranza_seguimiento_contactos csc','cc.idContacto = csc.idContacto');
							$this->db->join('cobranza_seguimiento cs','csc.idSeguimiento = cs.idSeguimiento');
							$this->db->where('cs.idCliente',$valor["cliente"]);
							$query=$this->db->get();
							//$genero=$row->genero;
							$result[$i]=(array) $valor;
							if ($query->num_rows() > 0){
							$result[$i]['contacto']=$query->result_array();
							}else{
							$result[$i]['contacto']="";
							}
							//$result[$i]['genero']=$genero;
							$i++;
							//var_dump($row);
						}
			 }
    }
  //return fetched data
   return $result;
	}
}
