<?php
class Catalogos_modelo extends CI_Model
{
	protected $fecha;
	protected $idLicencia;
	protected $resultado;
	protected $idUsuario;

	function __construct()
	{
		parent::__construct();

        $this->idUsuario 		= $this->session->userdata('id');
		$this->idLicencia 		= $this->session->userdata('idLicencia');
		$datestring   			= "%Y-%m-%d %H:%i:%s";
		$this->fecha 			= mdate($datestring,now());
		$this->resultado		="1";
	}
	
	public function obtenerEstados()
	{
		return $this->db->get("fac_catalogos_estados")->result();
	}

	//YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
	//MOTIVOS DE DEVOLUCIÓN
	//YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYs
	public function obtenerMotivos()
	{
		$sql=" select * from cotizaciones_devoluciones_motivos
		where activo='1' ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerMotivo($idMotivo)
	{
		$sql=" select * from cotizaciones_devoluciones_motivos
		where idMotivo='$idMotivo'";
		
		return $this->db->query($sql)->row();
	}
	
	public function comprobarMotivoNombre($nombre)
	{
		$sql="select count(idMotivo) as numero
		from cotizaciones_devoluciones_motivos
		where nombre='$nombre' 
		and activo='1' ";
		
		return $this->db->query($sql)->row()->numero>0?false:true;
	}
	
	public function registrarMotivo()
	{
		if(!$this->comprobarMotivoNombre($this->input->post('nombre')))
		{
			return array('0',registroDuplicado);
			exit;
		}
		
		$data=array
		(
			'idLicencia'		=> $this->idLicencia,
			'nombre'			=> $this->input->post('nombre'),
		);
		
		$this->db->insert('cotizaciones_devoluciones_motivos', $data);
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro); 
	}
	
	public function editarMotivo()
	{
		$data=array
		(
			'nombre'			=> $this->input->post('nombre'),
		);
		
		$this->db->where('idMotivo', $this->input->post('idMotivo'));
		$this->db->update('cotizaciones_devoluciones_motivos', $data);
		
		return $this->db->affected_rows() >= 1? "1" : "0";
	}
	
	public function borrarMotivo($idMotivo)
	{
	    $this->db->where('idMotivo',$idMotivo);
		$this->db->update('cotizaciones_devoluciones_motivos',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	//TIPOS DE DEVOLUCIONES
	public function obtenerTiposDevolucion()
	{
		$sql=" select * from cotizaciones_devoluciones_tipos ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerTipoDevolucionNombre($idTipo)
	{
		$sql=" select nombre 
		from cotizaciones_devoluciones_tipos
		where idTipo='$idTipo' ";
		
		$tipo= $this->db->query($sql)->row();
		
		return $tipo!=null?$tipo->nombre:'';
	}
	
	public function obtenerDiasSemanaActual()
	{
		$dia	= date('l', strtotime(date('Y-m-d')));
		$dia	= substr($dia,0,3);
		$fecha	= date('Y-m-d');
		$fecha1	= date('Y-m-d');
		$fecha2	= date('Y-m-d');
		
		switch($dia)
		{
			case 'Sun':
				$dia	= 1;
				$fecha1	= date('Y-m-d');
				$fecha2	= $this->db->query("select date_add('$fecha', interval 6 day) as fecha")->row()->fecha;
			break;
			
			case 'Mon':
				$dia	= 2;
				$fecha1	= $this->db->query("select date_sub('$fecha', interval 1 day) as fecha")->row()->fecha;
				$fecha2	= $this->db->query("select date_add('$fecha', interval 5 day) as fecha")->row()->fecha;
			
			break;
			
			case 'Tue':
				$dia	= 3;
				$fecha1	= $this->db->query("select date_sub('$fecha', interval 2 day) as fecha")->row()->fecha;
				$fecha2	= $this->db->query("select date_add('$fecha', interval 4 day) as fecha")->row()->fecha;
			break;
			
			case 'Wed':
				$dia	= 4;
				$fecha1	= $this->db->query("select date_sub('$fecha', interval 3 day) as fecha")->row()->fecha;
				$fecha2	= $this->db->query("select date_add('$fecha', interval 3 day) as fecha")->row()->fecha;
			break;
			
			case 'Thu':
				$dia	= 5;
				$fecha1	= $this->db->query("select date_sub('$fecha', interval 4 day) as fecha")->row()->fecha;
				$fecha2	= $this->db->query("select date_add('$fecha', interval 2 day) as fecha")->row()->fecha;
			break;
			
			case 'Fri':
				$dia	= 6;
				$fecha1	= $this->db->query("select date_sub('$fecha', interval 5 day) as fecha")->row()->fecha;
				$fecha2	= $this->db->query("select date_add('$fecha', interval 1 day) as fecha")->row()->fecha;
			break;
			
			case 'Sat':
				$dia=7;
				$fecha1	= $this->db->query("select date_sub('$fecha', interval 6 day) as fecha")->row()->fecha;
				$fecha2	= date('Y-m-d');
			break;
		}
		#echo $fecha1;
		return array($fecha1,$fecha2);
		/*if($dia==1)
		{
			$fecha1	= date('Y-m-d');
			$fecha2	= $this->db->query("select date_add('$fecha1', interval 6 day)");
		}
		
		if($dia==2)
		{
			$fecha1	= $this->db->query("select date_sub('$fecha1', interval 1 day)");
			$fecha2	= $this->db->query("select date_add('$fecha1', interval 5 day)");
		}*/
	}
	
	//DEPARTAMENTOS
	
	public function obtenerDepartamentos()
	{
		$sql=" select a.*
		from productos_departamentos as a
		where a.activo='1'
		order by a.nombre asc ";	
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerDepartamento($idDepartamento)
	{
		$sql=" select * from productos_departamentos
		where idDepartamento='$idDepartamento'
		and activo='1' ";	
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarDepartamento()
	{
		$data=array
		(
			'nombre'		=> trim($this->input->post('txtDepartamento')),
		);
		
		$data	= procesarArreglo($data);
		$this->db->insert('productos_departamentos',$data);
		
		$this->configuracion->registrarBitacora('Registrar departamento','Configuración - Departamentos ',$data['nombre']); //Registrar bitácora
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro); 
	}
	
	public function editarDepartamento()
	{
		$data=array
		(
			'nombre'		=> trim($this->input->post('txtDepartamento')),
		);
		
		$data	= procesarArreglo($data);
		$this->db->where('idDepartamento',$this->input->post('txtIdDepartamento'));
		$this->db->update('productos_departamentos',$data);
		
		$this->configuracion->registrarBitacora('Editar departamento','Configuración - Departamentos ',$data['nombre']); //Registrar bitácora
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro); 
	}
	
	public function obtenerDetallesDepartamento($idDepartamento)
	{
		$sql="select nombre
		from productos_departamentos
		where idDepartamento='$idDepartamento'";	
		
		$departamento	= $this->db->query($sql)->row();
		
		return $departamento!=null?$departamento->nombre:'';
	}
	
	public function borrarDepartamento($idDepartamento)
	{
		$this->configuracion->registrarBitacora('Borrar departamento','Configuración - Departamentos',$this->obtenerDetallesDepartamento($idDepartamento)); //Registrar bitácora
		
	    $this->db->where('idDepartamento',$idDepartamento);
		$this->db->update('productos_departamentos',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	
	//MARCAS
	
	public function obtenerMarcas()
	{
		$sql=" select a.*
		from productos_marcas as a
		where a.activo='1'
		order by a.nombre asc ";	
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerMarca($idMarca)
	{
		$sql=" select * from productos_marcas
		where idMarca='$idMarca'
		and activo='1' ";	
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarMarca()
	{
		$data=array
		(
			'nombre'		=> trim($this->input->post('txtMarca')),
		);
		
		$data	= procesarArreglo($data);
		$this->db->insert('productos_marcas',$data);
		
		$this->configuracion->registrarBitacora('Registrar marca','Configuración - Marcas ',$data['nombre']); //Registrar bitácora
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro); 
	}
	
	public function editarMarca()
	{
		$data=array
		(
			'nombre'		=> trim($this->input->post('txtMarca')),
		);
		
		$data	= procesarArreglo($data);
		$this->db->where('idMarca',$this->input->post('txtIdMarca'));
		$this->db->update('productos_marcas',$data);
		
		$this->configuracion->registrarBitacora('Editar marca','Configuración - Marcas ',$data['nombre']); //Registrar bitácora
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro); 
	}
	
	public function obtenerDetallesMarca($idMarca)
	{
		$sql="select nombre
		from productos_marcas
		where idMarca='$idMarca'";	
		
		$marca	= $this->db->query($sql)->row();
		
		return $marca!=null?$marca->nombre:'';
	}
	
	public function borrarMarca($idMarca)
	{
		$this->configuracion->registrarBitacora('Borrar marca','Configuración - Marcas',$this->obtenerDetallesMarca($idMarca)); //Registrar bitácora
		
	    $this->db->where('idMarca',$idMarca);
		$this->db->update('productos_marcas',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	//OBTENER LOS DIFERENTES CATÁLOGOS
	public function registrarCatalogoNombre($nombre,$tipo)
	{
		$data=array
		(
			'nombre'	=>	$nombre,
		);

		if(strlen($data['nombre'])==0) return 0;

		$this->db->select('*');
		$this->db->from("productos_".$tipo);
		$this->db->where('nombre', $data['nombre']);
		$this->db->where('activo', '1');
		
		$query = $this->db->get()->row();

		if($query!=null)
		{ 
			switch($tipo)
			{
				case 'departamentos':return $query->idDepartamento;break;
				case 'marcas':return $query->idMarca;break;
				case 'lineas':return $query->idLinea;break;
				
			}
		}

	    $this->db->insert('productos_'.$tipo,$data);
		$id	= $this->db->insert_id();
		
		return $this->db->affected_rows()>=1?$id:"0"; 
	}
	
	#PARA LAS VARIABLES
	#>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
	public function obtenerVariablesTipo($tipo=0)
	{    
		$sql=" select * from catalogos_variables
		where  tipo='$tipo'
		order by nombre asc ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerVariables()
	{    
		$criterio	= $this->input->post('criterio');
		$tipo		= $this->input->post('tipo');
		
		$sql=" select * from productos_variables
		where nombre like '%$criterio%'
		and tipo='$tipo'
		order by nombre asc ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerVariable($idVariable)
	{    
		$sql=" select * from productos_variables 
		where idVariable=$idVariable ";
		
		return $this->db->query($sql)->row();
	}
	
	public function obtenerTipoVariable($tipo)
	{    
		$sql=" select variable".$tipo." as variable
		from configuracion  ";
		
		return $this->db->query($sql)->row()->variable;
	}
	
	public function registrarVariable()
	{
		$data=array
		(
			'nombre'	=> $this->input->post('nombre'),
			'tipo'		=> $this->input->post('tipo'),
		);
		
	    $this->db->insert('productos_variables',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function editarVariable()
	{
		$data=array
		(
			'nombre'	=> $this->input->post('nombre')
		);
		
		$this->db->where('idVariable',$this->input->post('idVariable'));
	    $this->db->update('productos_variables',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function comprobarVariable($idVariable,$tipo)
	{
		$sql="select count(idVariable".$tipo.") as numero
		from productos
		where idVariable".$tipo."=$idVariable ";
		
		return $this->db->query($sql)->row()->numero;
	}
	
	public function borrarVariable($idVariable,$tipo)
	{
		if($this->comprobarVariable($idVariable,$tipo)>0)
		{
			return "0";	
		}
		
	    $this->db->where('idVariable',$idVariable);
		$this->db->delete('productos_variables');
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	//TIPOS DE DOCUMENTOS
	public function obtenerTiposDocumentos()
	{    
		$sql=" select * from recursos_personal_documentos_tipos
		where activo='1'
		order by idTipo asc ";
		
		return $this->db->query($sql)->result();
	}
	
	//TIPOS DE DOCUMENTOS
	public function obtenerTiposDocumentosCliente()
	{    
		$sql=" select * from clientes_documentos_tipos
		where activo='1'
		order by idTipo asc ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerDetallesCausaBaja($idCausa=0)
	{    
		$sql=" select * from clientes_bajas_causas_detalles
		where activo='1'
		and idCausa='$idCausa' ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerRegistrosCausaBajas()
	{    
		$sql=" select * from clientes_bajas_causas_detalles
		where activo='1'
		";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerDetallesCausaNocuali($idCausa=0)
	{    
		$sql=" select * from clientes_nocuali_causas_detalles
		where activo='1'
		and idCausa='$idCausa'  ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerRegistrosCausaNocuali()
	{    
		$sql=" select * from clientes_nocuali_causas_detalles
		where activo='1'
		order by orden asc";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerClientesProspectos()
	{    
		$sql=" select * from seguimiento_prospectos
		where activo='1' ";
		
		return $this->db->query($sql)->result();
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//NIVELES 1
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarNiveles1($criterio='')
	{    
		$sql=" select a.idNivel1
		from catalogos_niveles1 as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerNiveles1($numero=0,$limite=0,$criterio='')
	{    
		$sql=" select a.idNivel1, a.nombre,
		(select count(b.idNivel1) from catalogos_egresos as  b where b.idNivel1=a.idNivel1) as relaciones
		from catalogos_niveles1 as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerNivel1($idNivel1)
	{    
		$sql=" select * from catalogos_niveles1 
		where idNivel1=$idNivel1 ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarNivel1()
	{
		$data=array
		(
			'nombre'	=> $this->input->post('nombre'),
		);
		
	    $this->db->insert('catalogos_niveles1',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function editarNivel1()
	{
		$data=array
		(
			'nombre'	=> $this->input->post('nombre')
		);
		
		$this->db->where('idNivel1',$this->input->post('idNivel1'));
	    $this->db->update('catalogos_niveles1',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}

	public function borrarNivel1($idNivel1)
	{
	    $this->db->where('idNivel1',$idNivel1);
		$this->db->update('catalogos_niveles1',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//NIVELES 2
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarNiveles2($criterio='')
	{    
		$sql=" select a.idNivel2
		from catalogos_niveles2 as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerNiveles2($numero=0,$limite=0,$criterio='')
	{    
		$sql=" select a.idNivel2, a.nombre,
		(select b.nombre from catalogos_niveles1 as  b where b.idNivel1=a.idNivel1) as nivel1,
		(select count(b.idNivel2) from catalogos_egresos as  b where b.idNivel2=a.idNivel2) as relaciones
		from catalogos_niveles2 as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerNivel2($idNivel2)
	{    
		$sql=" select * from catalogos_niveles2 
		where idNivel2=$idNivel2 ";
		
		return $this->db->query($sql)->row();
	}
	
	public function obtenerNiveles2Catalogo($idNivel1)
	{    
		$sql=" select * from catalogos_niveles2 
		where idNivel1='$idNivel1'
		and activo='1' ";
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerNiveles3Catalogo($idNivel2)
	{    
		$sql=" select * from catalogos_niveles3 
		where idNivel2='$idNivel2'
		and activo='1'  ";
		
		return $this->db->query($sql)->result();
	}
	
	public function registrarNivel2()
	{
		$data=array
		(
			'nombre'	=> $this->input->post('nombre'),
			'idNivel1'	=> $this->input->post('idNivel1'),
		);
		
	    $this->db->insert('catalogos_niveles2',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function editarNivel2()
	{
		$data=array
		(
			'nombre'	=> $this->input->post('nombre')
		);
		
		$this->db->where('idNivel2',$this->input->post('idNivel2'));
	    $this->db->update('catalogos_niveles2',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}

	public function borrarNivel2($idNivel2)
	{
	    $this->db->where('idNivel2',$idNivel2);
		$this->db->update('catalogos_niveles2',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//NIVELES 3
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarNiveles3($criterio='')
	{    
		$sql=" select a.idNivel3
		from catalogos_niveles3 as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerNiveles3($numero=0,$limite=0,$criterio='')
	{    
		$sql=" select a.idNivel3, a.nombre,
		(select b.nombre from catalogos_niveles2 as  b where b.idNivel2=a.idNivel2) as nivel2,
		(select count(b.idNivel3) from catalogos_egresos as  b where b.idNivel3=a.idNivel3) as relaciones
		from catalogos_niveles3 as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerNivel3($idNivel3)
	{    
		$sql=" select * from catalogos_niveles3 
		where idNivel3=$idNivel3 ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarNivel3()
	{
		$data=array
		(
			'nombre'	=> $this->input->post('nombre'),
			'idNivel2'	=> $this->input->post('idNivel2'),
		);
		
	    $this->db->insert('catalogos_niveles3',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function editarNivel3()
	{
		$data=array
		(
			'nombre'	=> $this->input->post('nombre')
		);
		
		$this->db->where('idNivel3',$this->input->post('idNivel3'));
	    $this->db->update('catalogos_niveles3',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}

	public function borrarNivel3($idNivel3)
	{
	    $this->db->where('idNivel3',$idNivel3);
		$this->db->update('catalogos_niveles3',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	//FRECUENCIAS
	public function obtenerFrecuencias()
	{    
		$sql=" select * from sie_creditos_frecuencias 
		where activo='1'  ";
		
		return $this->db->query($sql)->result();
	}
	
	//GRADOS
	public function obtenerGrados()
	{    
		$sql=" select * from clientes_programas_grados 
		where activo='1'  ";
		
		return $this->db->query($sql)->result();
	}
	
	//TIPOS DE METAS
	public function obtenerTiposMetas()
	{    
		$sql=" select * from sie_prospectos_tipos 
		where activo='1'  ";
		
		return $this->db->query($sql)->result();
	}
	
	//TIPOS DE METAS
	public function obtenerMeses()
	{    
		$sql=" select * from meses   ";
		
		return $this->db->query($sql)->result();
	}
	
	//PADRES
	public function obtenerPadres($criterio)
	{
		$sql = " select a.*, concat(a.nombrePadre,' ',a.apellidoPaternoPadre, ' ', a.apellidoMaternoPadre) as value
		from clientes_padres as a
		where concat(a.nombrePadre,' ',a.apellidoPaternoPadre, ' ', a.apellidoMaternoPadre) like '%$criterio%'  
		limit 20 ";
		
		return $this->db->query($sql)->result_array();
	}
	

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//DEPENDENCIAS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarDependencias($criterio='')
	{    
		$sql=" select a.idDependencia
		from clientes_dependencias as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerDependencias($numero=0,$limite=0,$criterio='')
	{    
		$sql=" select a.idDependencia, a.nombre		
		from clientes_dependencias as a
		where a.activo='1' ";
		 
		$sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		$sql.=" order by a.nombre asc ";
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerDependencia($idDependencia)
	{    
		$sql=" select * from clientes_dependencias 
		where idDependencia=$idDependencia ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarDependencia()
	{
		$data=array
		(
			'nombre'		=> $this->input->post('nombre'),
			'fechaRegistro'	=> $this->fecha,
			'idUsuario'		=> $this->idUsuario,
		);
		
	    $this->db->insert('clientes_dependencias',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function editarDependencia()
	{
		$data=array
		(
			'nombre'				=> $this->input->post('nombre'),
			'fechaEdicion'			=> $this->fecha,
			'idUsuarioEdicion'		=> $this->idUsuario,
		);
		
		$this->db->where('idDependencia',$this->input->post('idDependencia'));
	    $this->db->update('clientes_dependencias',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}

	public function borrarDependencia($idDependencia)
	{
	    $this->db->where('idDependencia',$idDependencia);
		$this->db->update('clientes_dependencias',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CONVENIOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarConvenios($criterio='')
	{    
		$sql=" select a.idConvenio
		from clientes_convenios as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerConvenios($numero=0,$limite=0,$criterio='')
	{    
		$sql=" select a.idConvenio, a.nombre		
		from clientes_convenios as a
		where a.activo='1' ";
		 
		$sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		$sql.=" order by a.nombre asc ";
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerConvenio($idConvenio)
	{    
		$sql=" select * from clientes_convenios 
		where idConvenio=$idConvenio ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarConvenio()
	{
		$data=array
		(
			'nombre'		=> $this->input->post('nombre'),
			'fechaRegistro'	=> $this->fecha,
			'idUsuario'		=> $this->idUsuario,
		);
		
	    $this->db->insert('clientes_convenios',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function editarConvenio()
	{
		$data=array
		(
			'nombre'				=> $this->input->post('nombre'),
			'fechaEdicion'			=> $this->fecha,
			'idUsuarioEdicion'		=> $this->idUsuario,
		);
		
		$this->db->where('idConvenio',$this->input->post('idConvenio'));
	    $this->db->update('clientes_convenios',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}

	public function borrarConvenio($idConvenio)
	{
	    $this->db->where('idConvenio',$idConvenio);
		$this->db->update('clientes_convenios',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CARGOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarCargos($criterio='')
	{    
		$sql=" select a.idCargo
		from clientes_contactos_cargos as a
		where a.activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerCargos($numero=0,$limite=0,$criterio='')
	{    
		$sql=" select a.idCargo, a.nombre		
		from clientes_contactos_cargos as a
		where a.activo='1' ";
		 
		$sql.=strlen($criterio)>0?" and a.nombre like '$criterio%' ":'';
		$sql.=" order by a.nombre asc ";
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerCargo($idCargo)
	{    
		$sql=" select * from clientes_contactos_cargos 
		where idCargo=$idCargo ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarCargo()
	{
		$data=array
		(
			'nombre'		=> $this->input->post('nombre'),
			'fechaRegistro'	=> $this->fecha,
			'idUsuario'		=> $this->idUsuario,
		);
		
	    $this->db->insert('clientes_contactos_cargos',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function editarCargo()
	{
		$data=array
		(
			'nombre'				=> $this->input->post('nombre'),
			'fechaEdicion'			=> $this->fecha,
			'idUsuarioEdicion'		=> $this->idUsuario,
		);
		
		$this->db->where('idCargo',$this->input->post('idCargo'));
	    $this->db->update('clientes_contactos_cargos',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}

	public function borrarCargo($idCargo)
	{
	    $this->db->where('idCargo',$idCargo);
		$this->db->update('clientes_contactos_cargos',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//PAE
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarPae($criterio='',$idCliente=0)
	{    
		$sql=" select a.idPae
		from clientes_pae as a
		where a.activo='1'
		and a.idCliente='$idCliente' ";
		 
		 $sql.=strlen($criterio)>0?" and a.tipoEvaluacion like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerPae($numero=0,$limite=0,$criterio='',$idCliente=0)
	{    
		$sql=" select a.*
		from clientes_pae as a
		where a.activo='1'
		and a.idCliente='$idCliente' ";
		 
		$sql.=strlen($criterio)>0?" and a.tipoEvaluacion like '$criterio%' ":'';
		$sql.=" order by a.tipoEvaluacion asc ";
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerRegistroPae($idPae)
	{    
		$sql=" select * from clientes_pae 
		where idPae=$idPae ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarPae()
	{
		$data=array
		(
			'idCliente'				=> $this->input->post('idCliente'),
			'fechaPublicacion'		=> $this->input->post('txtFechaPublicacion'),
			'numeroEvaluaciones'	=> $this->input->post('txtNumeroEvaluaciones'),
			'tipoEvaluacion'		=> $this->input->post('txtTipoEvaluacion'),
			'precioEstimado'		=> $this->input->post('txtPrecioEstimado'),
			'precioTotalEstimado'	=> $this->input->post('txtPrecioTotalEstimado'),
			
			'fechaRegistro'			=> $this->fecha,
			'idUsuario'				=> $this->idUsuario,
		);
		
	    $this->db->insert('clientes_pae',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function editarPae()
	{
		$data=array
		(
			'fechaPublicacion'		=> $this->input->post('txtFechaPublicacion'),
			'numeroEvaluaciones'	=> $this->input->post('txtNumeroEvaluaciones'),
			'tipoEvaluacion'		=> $this->input->post('txtTipoEvaluacion'),
			'precioEstimado'		=> $this->input->post('txtPrecioEstimado'),
			'precioTotalEstimado'	=> $this->input->post('txtPrecioTotalEstimado'),
			'fechaEdicion'			=> $this->fecha,
			'idUsuarioEdicion'		=> $this->idUsuario,
		);
		
		$this->db->where('idPae',$this->input->post('txtIdPae'));
	    $this->db->update('clientes_pae',$data);
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}

	public function borrarPae($idPae)
	{
	    $this->db->where('idPae',$idPae);
		$this->db->update('clientes_pae',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?"1":"0"; 
	}
	
	public function obtenerTiposContacto()
	{    
		$sql=" select * from clientes_contactos_tipos";
		
		return $this->db->query($sql)->result();
	}

	public function obtenerTemperaturas()
	{    
		$sql=" select * from clientes_temperaturas
		where activo='1' 
		order by orden asc ";
		
		return $this->db->query($sql)->result();
	}


	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//FUENTES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarFuentes($criterio='')
	{    
		$sql=" select idFuente
		from clientes_fuentes
		where activo='1' ";
		 
		 $sql.=strlen($criterio)>0?" and nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerFuentes($numero=0,$limite=0,$criterio='')
	{    
		$sql=" select *	
		from clientes_fuentes
		where activo='1' ";
		 
		$sql.=strlen($criterio)>0?" and nombre like '$criterio%' ":'';
		$sql.=" order by nombre asc ";
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerFuente($idFuente)
	{    
		$sql=" select * from clientes_fuentes 
		where idFuente=$idFuente ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarFuente()
	{
		$data=array
		(
			'nombre'		=> $this->input->post('txtNombreFuente'),
			'fechaRegistro'	=> $this->fecha,
			'idUsuario'		=> $this->idUsuario,
		);
		
	    $this->db->insert('clientes_fuentes',$data);
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro);
	}
	
	public function editarFuente()
	{
		$data=array
		(
			'nombre'				=> $this->input->post('txtNombreFuente'),
			'fechaEdicion'			=> $this->fecha,
			'idUsuarioEdicion'		=> $this->idUsuario,
		);
		
		$this->db->where('idFuente',$this->input->post('txtIdRegistroFuente'));
	    $this->db->update('clientes_fuentes',$data);
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro);
	}

	public function borrarFuente($idFuente)
	{
	    $this->db->where('idFuente',$idFuente);
		$this->db->update('clientes_fuentes',array('activo'=>'0'));
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro);
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//PROPUESTAS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	public function contarPropuestas($criterio='',$idSeguimiento)
	{    
		$sql=" select idPropuesta
		from seguimiento_propuestas
		where activo='1'
		and idSeguimiento='$idSeguimiento' ";
		 
		 $sql.=strlen($criterio)>0?" and nombre like '$criterio%' ":'';
		
		return $this->db->query($sql)->num_rows();
	}
	
	public function obtenerPropuestas($numero=0,$limite=0,$criterio='',$idSeguimiento)
	{    
		$sql=" select *	
		from seguimiento_propuestas
		where activo='1'
		and idSeguimiento='$idSeguimiento' ";
		 
		$sql.=strlen($criterio)>0?" and nombre like '$criterio%' ":'';
		$sql.=" order by nombre asc ";
		
		$sql.= $numero>0?" limit $limite,$numero ":'';
		
		return $this->db->query($sql)->result();
	}
	
	public function obtenerPropuesta($idPropuesta)
	{    
		$sql=" select * from seguimiento_propuestas 
		where idPropuesta=$idPropuesta ";
		
		return $this->db->query($sql)->row();
	}
	
	public function registrarPropuesta()
	{
		$this->db->trans_start();

		$data=array
		(
			'nombre'		=> $this->input->post('txtNombre'),
			'idSeguimiento'	=> $this->input->post('idSeguimiento'),
			'importe'		=> $this->input->post('txtImporte'),
			'observaciones'	=> $this->input->post('txtObservaciones'),
			'fechaRegistro'	=> $this->fecha,
			'idUsuario'		=> $this->idUsuario,
		);
		
	    $this->db->insert('seguimiento_propuestas',$data);
		$idPropuesta	= $this->db->insert_id();

		$archivo 		= $_FILES['txtArchivo']['name'];
		
		if(strlen($archivo)>0)
		{
			$idArchivo	= $this->registrarArchivo($idPropuesta,$archivo,$_FILES['txtArchivo']['size']);
			
			move_uploaded_file($_FILES['txtArchivo']['tmp_name'], carpetaPropuestas.basename($idArchivo."_".$archivo));
		}
		
		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback(); 
			$this->db->trans_complete();
			
			return array('0',errorRegistro);
		}
		else
		{
			$this->db->trans_commit(); 
			$this->db->trans_complete();
			
			return array('1',registroCorrecto);
		}
	}
	
	public function editarPropuesta()
	{
		$data=array
		(
			'nombre'				=> $this->input->post('txtNombre'),
			'importe'				=> $this->input->post('txtImporte'),
			'observaciones'			=> $this->input->post('txtObservaciones'),
			'fechaEdicion'			=> $this->fecha,
			'idUsuarioEdicion'		=> $this->idUsuario,
		);
		
		$this->db->where('idPropuesta',$this->input->post('txtIdRegistroPropuesta'));
	    $this->db->update('seguimiento_propuestas',$data);
		
		return $this->db->affected_rows()>=1?array('1',registroCorrecto):array('0',errorRegistro);
	}

	public function borrarPropuesta($idPropuesta)
	{
		$this->db->trans_start();

	    $this->db->where('idPropuesta',$idPropuesta);
		$this->db->update('seguimiento_propuestas',array('activo'=>'0'));

		$this->borrarArchivos($idPropuesta);

		if ($this->db->trans_status() === FALSE)
		{
			$this->db->trans_rollback(); 
			$this->db->trans_complete();
			
			return array('0',errorRegistro);
		}
		else
		{
			$this->db->trans_commit(); 
			$this->db->trans_complete();
			
			return array('1',registroCorrecto);
		}
	}

	//ARCHIVOS DE PROPUESTAS
	public function obtenerArchivos($idPropuesta)
	{
		$sql="select *  from seguimiento_propuestas_archivos
		where idPropuesta='$idPropuesta'";
		
		return $this->db->query($sql)->result();
	}

	public function obtenerArchivo($idArchivo)
	{
		$sql="select *  from seguimiento_propuestas_archivos
		where idArchivo='$idArchivo'";
		
		return $this->db->query($sql)->row();
	}

	public function registrarArchivo($idPropuesta,$nombre,$tamano)
	{
		$data=array
		(
			'nombre'		=> $nombre,
			'tamano'		=> $tamano,
			'idPropuesta'	=> $idPropuesta,
			'fecha'			=> $this->fecha,
			'idUsuario'		=> $this->idUsuario,
		);
		
		$this->db->insert('seguimiento_propuestas_archivos',$data);
		$idArchivo	= $this->db->insert_id();
		
		$this->configuracion->registrarBitacora('Registrar comprobante','CRM - Propuestas',$nombre); //Registrar bitácora
		
		return $this->db->affected_rows()>=1?$idArchivo:0;
	}

	public function borrarArchivo($idArchivo)
	{
		$registro	=$this->obtenerArchivo($idArchivo);
		
		$this->db->where('idArchivo',$idArchivo);
		$this->db->delete('seguimiento_propuestas_archivos');
		
		if($this->db->affected_rows()>=1)
		{
			$this->configuracion->registrarBitacora('Borrar archivo','CRM - Propuestas',$registro->nombre); //Registrar bitácora
			
			if(file_exists(carpetaPropuestas.$registro->idArchivo.'_'.$registro->nombre))
			{
				unlink(carpetaPropuestas.$registro->idArchivo.'_'.$registro->nombre);
			}
			
			return "1";
		}
		else
		{
			return "0";
		}
	}

	public function borrarArchivos($idPropuesta)
	{
		$registros	=$this->obtenerArchivos($idPropuesta);

		if($registros!=null)
		{
			foreach($registros as $row)
			{
				$this->db->where('idArchivo',$row->idArchivo);
				$this->db->delete('seguimiento_propuestas_archivos');
		
				$this->configuracion->registrarBitacora('Borrar archivo','CRM - Propuestas',$row->nombre); //Registrar bitácora
			
				if(file_exists(carpetaPropuestas.$row->idArchivo.'_'.$row->nombre))
				{
					unlink(carpetaPropuestas.$row->idArchivo.'_'.$row->nombre);
				}
			}
			
		}
		
		
	}
}