<?php
class AppSie extends CI_Controller
{
	protected $fecha;
	protected $idUsuario;
	protected $_csstyle;
    protected $_tables;
    protected $_role;
	protected $cuota;

	function __construct()
	{
		parent::__construct();
		
		$this->config->load('datatables', TRUE);	
		$this->config->load('style', TRUE);
		$this->config->load('js',TRUE);
		$this->_jss				= $this->config->item('js');
		 
		$datestring   			= "%Y-%m-%d %H:%i:%s";
	    $this->fecha 			= mdate($datestring,now());
		$this->idUsuario		= $this->session->userdata('id');
		$this->_role 			= $this->session->userdata('role');
		$this->_tables 			= $this->config->item('datatables');
		$this->_csstyle 		= $this->config->item('style');
		
		$this->load->model("crm_modelo","crm");
        $this->load->model("modelousuario","usuarios");
        $this->load->model("modeloclientes","clientes");
		$this->load->model("modelo_configuracion","configuracion");
		$this->load->model("creditos_modelo","creditos");
		$this->load->model("motivos_modelo","motivos");
		$this->load->model("sie_modelo","sie");
		$this->load->model("proyeccion_modelo","proyeccion");
		$this->load->model("reportes_model","reportes");
		
  	}

  	//  Inicia versión móbil
	public function obtenerInformacionFinanciera()
	{
		$fecha								= $this->input->post('fecha');
		
		$data['financiera']					= $this->sie->obtenerFinanciera();
		$data['fechaFinanciera']			= $fecha;
		
		$dia								= obtenerFechaSeparada($fecha,'dia');
		$ultima								= $this->reportes->obtenerUltimaFecha($fecha);
		
		if($dia==15)
		{
			$fecha							= $this->input->post('fecha');
			$fecha2							= $this->input->post('fecha');
			$fecha3							= $this->reportes->obtenerUltimaFecha($fecha);
			$fecha4							= $this->reportes->obtenerFechaFinCriterio($fecha2,1,'month');
		}
		
		if($dia<15)
		{
			$fecha							= $this->input->post('fecha');
			$fecha2							= obtenerFechaSeparada($fecha,'anio').'-'.obtenerFechaSeparada($fecha,'mes').'-15';
			$fecha3							= $this->reportes->obtenerUltimaFecha($fecha);
			$fecha4							= $this->reportes->obtenerFechaFinCriterio($fecha2,1,'month');
		}
		
		if($dia>15 and $fecha!=$ultima)
		{
			$fecha							= $this->input->post('fecha');
			$fecha2							= $this->reportes->obtenerUltimaFecha($fecha);
			$fecha3							= $this->reportes->obtenerFechaFinCriterio($fecha2,15,'day');
			$fecha4							= $this->reportes->obtenerUltimaFecha($fecha3);
		}
		
		if($fecha==$ultima)
		{
			$fecha							= $this->input->post('fecha');
			$fecha2							= $this->reportes->obtenerFechaFinCriterio($fecha,15,'day');
			$fecha3							= $this->reportes->obtenerUltimaFecha($fecha2);
			$fecha4							= $this->reportes->obtenerFechaFinCriterio($fecha2,1,'month');
		}
		
		
		$data['saldoDia']					= $data['financiera']->efectivo+$data['financiera']->cuentas+$this->proyeccion->sumarIngresosFecha($fecha)-$this->proyeccion->sumarEgresosFecha($fecha);
		$data['saldoDia2']					= $data['financiera']->efectivo+$data['financiera']->cuentas+$this->proyeccion->sumarIngresosFecha($fecha2)-$this->proyeccion->sumarEgresosFecha($fecha2);
		$data['saldoDia3']					= $data['financiera']->efectivo+$data['financiera']->cuentas+$this->proyeccion->sumarIngresosFecha($fecha3)-$this->proyeccion->sumarEgresosFecha($fecha3);
		$data['saldoDia4']					= $data['financiera']->efectivo+$data['financiera']->cuentas+$this->proyeccion->sumarIngresosFecha($fecha4)-$this->proyeccion->sumarEgresosFecha($fecha4);
		
		
		
		$data['fecha']					= $fecha;
		$data['fecha2']					= $fecha2;
		$data['fecha3']					= $fecha3;
		$data['fecha4']					= $fecha4;
		
		print_r($data);

		
		
		//$this->load->view('sie/informacionFinanciera/obtenerInformacionFinanciera',$data);
	}
	// Acaba version mobil

  
}