<?php
class Soporte extends CI_Controller
{
    protected $idUsuario;
    protected $fecha;

	function __construct()
	{
		parent::__construct();

		

		$this->fecha 			= date('Y-m-d H:i:s');
		$this->idUsuario 		= $this->session->userdata('id');

        $this->load->model("soporte_modelo","soporte");
		$this->load->model("temporal_modelo","temporal");
	 	$this->load->model("modelo_configuracion","configuracion");
		$this->load->model("inventarioproductos_modelo","inventario");
		$this->load->model("listas_modelo","listas");
		
		$this->load->model("crm_modelo","crm");
		$this->load->model("importar_modelo","importar");
	}

	public function procesarMateriaPrima()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->procesarMateriaPrima();
		
		redirect(base_url().'materiales');
	}
	
	public function procesarProductos()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		$this->soporte->procesarProductos();
		
		redirect(base_url().'produccion');
	}
	
	public function procesarClientes()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		$this->soporte->procesarClientes();
		
		redirect(base_url().'clientes');
	}
	
	public function procesarProveedores()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->procesarProveedores();
		
		redirect(base_url().'proveedores');
	}
	
	public function creadorPermisos($idPermiso=0)
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		$this->soporte->creadorPermisos($idPermiso);
		
		redirect('clientes','refresh');
	}
	
	public function sincronizarBaseRemota()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->temporal->sincronizarVentasTemporales();
		
		redirect(base_url().'clientes');
	}
	
	public function registrarStockLicencias()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->registrarStockLicencias();
		
		redirect(base_url().'inventarioProductos');
	}
	
	public function procesarProductosPinata()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->procesarProductosPinata();
		
		redirect(base_url().'inventarioProductos');
	}
	
	public function procesarClientesAlumnos()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->procesarClientesAlumnos();
		
		redirect(base_url().'clientes');
	}
	
	public function creadorPermisosBotones($idBoton=0)
	{
		$this->soporte->creadorPermisosBotones($idBoton);
		
		redirect('clientes','refresh');
	}
	
	public function procesarClientesZona()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->procesarClientesZona();
		
		redirect(base_url().'clientes');
	}
	
	public function importarClientesMatricula()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
	
		$this->load->view('clientes/importar/importarClientesMatricula',$data);
		
		redirect(base_url().'clientes');
	} 
	
	public function administrarListasVigentes()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->listas->administrarListasVigentes();
		
		redirect(base_url().'materiales');
	}
	
	public function administrarListasPasadas()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->listas->administrarListasPasadas();
		
		redirect(base_url().'materiales');
	}
	
	public function procesarSeguimientosBorrar()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->procesarSeguimientosBorrar();
		
		redirect(base_url().'clientes');
	}
	
	public function procesarProgramasAlumnos()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0);
		
		$this->soporte->procesarProgramasAlumnos();
		
		redirect('ventas');
	}
	
	public function procesarAlumnosInscritos()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0);
		
		$this->soporte->procesarAlumnosInscritos();
		
		redirect('ventas');
	}
	
	public function procesarCorreos()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0);
		
		$this->soporte->procesarCorreos();
		
		redirect('ventas');
	}
	
	public function procesarSeguimientosAtrasos()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0);
		
		$this->soporte->procesarSeguimientosAtrasos();
		
		redirect('ventas');
	}
	
	public function procesarNuevos()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0);
		
		$this->soporte->procesarNuevos();
		
		redirect('clientes/prospectos');
	}
	
	public function procesarSeguimientosClientes()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0);
		
		$this->soporte->procesarSeguimientosClientes();
		
		redirect('clientes/prospectos');
	}
	
	public function procesarClientesErrores()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0);
		
		$this->soporte->procesarClientesErrores();
		
		redirect('clientes/prospectos');
	}
	
	public function procesarCrmPromotores()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0);
		
		$this->soporte->procesarCrmPromotores();
		
		redirect('clientes/prospectos');
	}
	
	public function importarProductosCerraduras()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->importarProductosCerraduras();
		
		redirect(base_url().'inventarioProductos');
	}
	
	public function procesarProspectosPromotor()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->procesarProspectosPromotor();
		
		redirect(base_url().'clientes/prospectos');
	}
	
	public function asignarCampanaSeguimiento()
	{
		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}
		
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->asignarCampanaSeguimiento();
		
		redirect(base_url().'clientes/prospectos');
	}
	
	public function obtenerUltimaConexion()
	{
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->obtenerUltimaConexion();
		
		redirect(base_url().'clientes');
	}
	
	public function registrarStockLicencia()
	{
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->registrarStockLicencia();
		
		redirect(base_url().'inventarioProductos');
	}
	
	public function asignarClientesPromotor()
	{
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->asignarClientesPromotor();
		
		redirect(base_url().'inventarioProductos');
	}
	
	public function creadorPermisosBotonesRango()
	{
		$this->soporte->creadorPermisosBotonesRango();
		
		redirect('configuracion/roles','refresh');
	}
	
	public function cambiarSeguimientosFechas()
	{
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->cambiarSeguimientosFechas();
		
		redirect(base_url().'inventarioProductos');
	}
	
	public function cambiarProspectosClientes()
	{
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->cambiarProspectosClientes();
		
		redirect(base_url().'inventarioProductos');
	}
	
	public function asignarClientesPromotorRegistro()
	{
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->asignarClientesPromotorRegistro();
		
		redirect(base_url().'inventarioProductos');
	}

	public function cambiarCharset()
    {
		ini_set("memory_limit","1500M");
		set_time_limit(0); 

		$consulta=$this->db->query("SELECT CONCAT('ALTER TABLE ',TABLE_SCHEMA,'.',TABLE_NAME,' CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_spanish_ci;') as consulta FROM information_schema.TABLES WHERE TABLE_SCHEMA = 'redisoftme_evaluare' and TABLE_TYPE='BASE TABLE'; ")->result();

		foreach($consulta as $row)
        {
			$this->db->query("$row->consulta");
        }

		echo 'Exito';
    }

	public function registrarClientesEvaluare()
	{
		ini_set("memory_limit","1500M");
		set_time_limit(0); 
		
		$this->soporte->registrarClientesEvaluare();
	}
}
?>
