<?php
class PerfilAlumnosMobil extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model("modelousuario","usuarios");
        $this->load->model("modelo_configuracion","configuracion");
        $this->load->model("sie_modelo","sie");
        $this->load->model("ExpedienteM_model","expediente");

        $this->perPage = 10;
        $this->config->load('datatables', TRUE);
    		$this->config->load('style', TRUE);
    		$this->config->load('js',TRUE);
    		$this->_jss				= $this->config->item('js');

        $newdata = array(
            'idLicencia'  => '1',
            'rol'=>"26"
        );

        $this->session->set_userdata($newdata);

		$datestring   			= "%Y-%m-%d %H:%i:%s";
	    $this->fecha 			= mdate($datestring,now());
		$this->idUsuario		= $this->session->userdata('id');
		$this->_role 			= $this->session->userdata('role');
		$this->_tables 			= $this->config->item('datatables');
		$this->_csstyle 		= $this->config->item('style');
        $this->configuracion->accesoUsuario(); //CONTROL DE ACCESOS
        $this->cuota	= $this->configuracion->comprobarCuota(); //COMPROBAR CUOTA DE DISCO
    }

    public function getAll()
    {

        $data['alumnos'] =$this->expediente->obtenerAlumnos();
        echo json_encode($data);
    }
    public function lista_alumnos()
    {
       //get rows count
       $conditions['returnType'] = 'count';
       $conditions['buscar']= $this->input->post('buscar');
       $data['total']=$this->expediente->obtenerAlumnos($conditions);
       $npagina=$this->input->post('nropagina');
       //limites de paginador
       $data['start'] = $conditions['start'] = ($npagina-1)*$this->perPage;
       $data['limit'] = $conditions['limit'] = $this->perPage;
       //obtenemos la informacion
       $conditions['returnType'] = '';
       $data['clientes'] =$this->expediente->obtenerAlumnos($conditions);
       
       echo json_encode($data);
    }

    public function expediente()
    {
        //matricula
        $id=$this->input->get("alumno");
        $data = array();
        //Datos del alumno
        $data['alumno'] = $this->expediente->get_expediente($id);
        $data['cliente'] = $this->expediente->get_expediente_complemento($id);
        $data['pagos'] = $this->expediente->get_pagos($data['cliente']['idCliente']);
        $data['materias'] = $this->expediente->id_plataforma($id);
        //Saldos
        $insc = $this->expediente->get_saldos($data['cliente']['idCliente'],23);
        $cole = $this->expediente->get_saldos($data['cliente']['idCliente'],22);
        $rein = $this->expediente->get_saldos($data['cliente']['idCliente'],24);
        $titu = $this->expediente->get_saldos($data['cliente']['idCliente'],25);

        $data['insc']=$data['cliente']['inscripcion']-$insc;
        $data['cole']=$data['cliente']['colegiatura']-$cole;
        $data['rein']=$data['cliente']['reinscripcion']-$rein;
        $data['titu']=$data['cliente']['titulacion']-$titu;
        //Formato de fecha
        $fecha=date_create($data['alumno']['fecha_registro']);
        $data['ingreso']=date_format($fecha, 'd M Y');
        //Generales
        $data['fecha'] 			= $this->fecha;


        
        echo json_encode($data,true);

    }

}
?>
