<?php
class PerfilAlumnos extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model("modelousuario","usuarios");
        $this->load->model("modelo_configuracion","configuracion");
        $this->load->model("sie_modelo","sie");
        $this->load->model("expediente_model","expediente");

        $this->perPage = 10;
        $this->config->load('datatables', TRUE);
    		$this->config->load('style', TRUE);
    		$this->config->load('js',TRUE);
    		$this->_jss				= $this->config->item('js');

    		$datestring   			= "%Y-%m-%d %H:%i:%s";
    	  $this->fecha 			= mdate($datestring,now());
    		$this->idUsuario		= $this->session->userdata('id');
    		$this->_role 			= $this->session->userdata('role');
    		$this->_tables 			= $this->config->item('datatables');
    		$this->_csstyle 		= $this->config->item('style');
        $this->configuracion->accesoUsuario(); //CONTROL DE ACCESOS
        $this->cuota	= $this->configuracion->comprobarCuota(); //COMPROBAR CUOTA DE DISCO
    }

    public function index()
    {
      $data = array();
      $data['titulo'] 		= "Lista de alumnos";
  		$data['usuario'] 		= $this->usuarios->getUsuarios($this->idUsuario);
  		$data['fecha'] 			= $this->fecha;

  		$data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
  		$data['configuracion']	= $this->configuracion->obtenerConfiguraciones(1);
  		$data['menuActivo']		= 'alumnos';
  		$data['subMenu']		= 'alumnos';
  		$data['pagina']			= 'sie/alumnos/lista';
      $data['permiso']		= $this->configuracion->obtenerPermisosBoton('64',$this->session->userdata('rol'));
      if($data['permiso'][0]->activo=='0')
      {
        $data['pagina']		= 'accesos/index';
      }
      $data["breadcumb"]		= '<li class="breadcrumb-item"><a href="'.base_url().'sie/index1">Sie</a></li><li class="breadcrumb-item active">Alumnos</li>';
        $this->load->view("sie/paginaPrincipal",$data);
    }

    public function lista_alumnos()
    {
       //get rows count
       $conditions['returnType'] = 'count';
       $conditions['buscar']= $this->input->post('buscar');
       $data['total']=$this->expediente->obtenerAlumnos($conditions);
       $npagina=$this->input->post('nropagina');
       //limites de paginador
       $data['start'] = $conditions['start'] = ($npagina-1)*$this->perPage;
       $data['limit'] = $conditions['limit'] = $this->perPage;
       //obtenemos la informacion
       $conditions['returnType'] = '';
       $data['clientes'] =$this->expediente->obtenerAlumnos($conditions);
       echo json_encode($data);
    }

    public function expediente()
    {
        $var=base64_encode("alumno");
        //matricula
        $id=base64_decode($this->input->get($var));

        $data = array();
        //Datos del alumno
        $data['alumno'] = $this->expediente->get_expediente($id);
        $data['cliente'] = $this->expediente->get_expediente_complemento($id);
        //var_dump($data['cliente']);
        if (isset($data['cliente']) && isset($data['alumno'])) {
        $data['pagos'] = $this->expediente->get_pagos($data['cliente']['idCliente']);
        $data['materias'] = $this->expediente->id_plataforma($id);
        //Saldos
        $insc = $this->expediente->get_saldos($data['cliente']['idCliente'],23);
        $cole = $this->expediente->get_saldos($data['cliente']['idCliente'],22);
        $rein = $this->expediente->get_saldos($data['cliente']['idCliente'],24);
        $titu = $this->expediente->get_saldos($data['cliente']['idCliente'],25);

        $data['insc']=$data['alumno']['inscripcion']-$insc;
        $data['cole']=$data['alumno']['colegiatura']-$cole;
        $data['rein']=$data['alumno']['reinscripcion']-$rein;
        $data['titu']=$data['alumno']['titulacion']-$titu;
        //Formato de fecha
        $dia=date('j',strtotime($data['alumno']['fecha_registro']));
            $months_meses = array(
            'January'=>'Enero',
            'February'=>'Febrero',
            'March'=>'Marzo',
            'April'=>'Abril',
            'May'=>'Mayo',
            'June'=>'Junio',
            'July'=>'Julio',
            'August'=>'Agosto',
            'September'=>'Septiembre',
            'October'=>'Octubre',
            'November'=>'Noviembre',
            'December'=>'Diciembre'
            );
        $mes=$months_meses[date('F', strtotime($data['alumno']['fecha_registro']))];
        $anio=date('Y',strtotime($data['alumno']['fecha_registro']));
        $fecha=$dia." ".$mes." ".$anio ;

        $data['ingreso']=$fecha;
        }else {
          $data['matricula']=$id;
        }
        //Generales
        $data['titulo'] 		= "Expediente";
        $data['usuario'] 		= $this->usuarios->getUsuarios($this->idUsuario);
        $data['fecha'] 			= $this->fecha;
        $data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
        $data['configuracion']	= $this->configuracion->obtenerConfiguraciones(1);
        $data['menuActivo']		= 'alumnos';
        $data['subMenu']		= 'alumnos';
        $data['pagina']			= 'sie/alumnos/expediente';
        $data['permiso']		= $this->configuracion->obtenerPermisosBoton('64',$this->session->userdata('rol'));
        if($data['permiso'][0]->activo=='0')
        {
          $data['pagina']		= 'accesos/index';
        }
        $data["breadcumb"]		= '<li class="breadcrumb-item"><a href="'.base_url().'sie/index1">Sie</a></li><li class="breadcrumb-item active">Alumnos</li>';
        $this->load->view("sie/paginaPrincipal", $data);
    }

}
?>
