<?php
class Login extends CI_Controller
{
	protected $_csstyle;
 
	public function __construct()
	{
		parent::__construct();
		
		$this->config->load('style', TRUE);
		
		$this->_csstyle = $this->config->item('style');
		$this->load->model("modelousuario","modelousuario");
		$this->load->model("modelo_configuracion","configuracion");
	}

	/*public function index()
	{
		 $Data['csslogin']	= $this->_csstyle["csslogin"];
		 $Data['estilo']	= $this->configuracion->obtenerEstilo();
		 
		 $this->load->view("login/cabezera",$Data);
		 $this->load->view("login/login");
		 $this->load->view("login/pie");
		
		 $mensajes	="3";
		 $this->session->set_userdata('mensajes',$mensajes);
	}//fin de index*/
	
	public function index()
	{
		 $data['estilo']	= $this->configuracion->obtenerEstilo();
		 
		 if(sistemaActivo=='olyess')
		 {
			 $data['licencias']	= $this->configuracion->obtenerLicenciasActivas();
			 
			 $this->load->view("login/loginOlyess",$data);
		 }
		 else
		 {
			  $this->load->view("login/login",$data);
		 }
		

		 $mensajes	="3";
		 $this->session->set_userdata('mensajes',$mensajes);
	}
	
	public function loginAdmin()
	{
		$Data['csslogin']=$this->_csstyle["csslogin"];
		$this->load->view("loginAdmin/cabezera",$Data);
		$this->load->view("loginAdmin/login");
		$this->load->view("loginAdmin/pie");
		$mensajes="3";
		$this->session->set_userdata('mensajes',$mensajes);
	}

	
	public function recuperarPassword()
	{
		$Data['csslogin']=$this->_csstyle["csslogin"];
		$this->load->view("login/cabezera",$Data);
		$this->load->view("login/recuperar");
		$this->load->view("login/pie");
	}
	
	
	public function confirmacion($pass,$user)
	{
		$Data['csslogin']=$this->_csstyle["csslogin"];
		
		$data['cambiar']=$this->modelousuario->obtenerPassword($pass,$user);
		
		$this->load->view("login/cabezera",$Data);
		$this->load->view("login/confirmar",$data);
		$this->load->view("login/pie");
	}
	
	public function confirmarPassword()
	{
		if(!empty($_POST))
		{
			$cambiar=$this->modelousuario->cambiarPassword();
			print($cambiar);
		}
	}
   
   	public function accesoWeb()
	{
		$user = $this->input->post('username');
		$pass = $this->input->post('password');
		
		$redux = $this->redux_auth->login($user,$pass);
		
		#echo 'id: '. $this->session->userdata('id');
		
		$this->session->set_userdata('idUsuarioAdmin','');
		$licencia=$this->modelousuario->obtenerUsuario($this->session->userdata('id'));

		if($licencia!=null)
		{
			$this->session->set_userdata('idLicencia',$licencia->idLicencia);
			echo "1";
		}
		else
		{
			echo "0";
		}
	}
	
	public function acceso()
	{
		$Data['csslogin']	= $this->_csstyle["csslogin"];
		$Data['estilo']		= $this->configuracion->obtenerEstilo();
		
		$reglas['username'] = "required";
		$reglas['password'] = "required";
		
		$fields['username'] = 'usuario';
		$fields['password'] = 'password';
		
		$this->validation->set_fields($fields);
		$this->validation->set_rules($reglas);
		
		if ($this->validation->run() == FALSE)
		{
			$this->session->set_userdata('errorNotificacion','El nombre de usuario o contraseña son incorrectos');	
					
			redirect('login');
		}
		else
		{
			$user = $this->input->post('username');
			$pass = $this->input->post('password');
			
			$redux 	= $this->redux_auth->login($user,$pass);
			$anio	=date("Y");
		
			switch($redux)
			{
				case false: 
					$this->session->set_userdata('errorNotificacion','El nombre de usuario o contraseña son incorrectos');	
					
					redirect('login');
				break;
				case true:
				
				$this->session->set_userdata('idUsuarioAdmin','');
				#$licencia	= $this->modelousuario->obtenerUsuario($this->session->userdata('id'));
				$licencia	= $this->modelousuario->obtenerUsuarioLogin($user,$pass,$this->input->post('selectSucursal'));
				
				if($licencia!=null)
				{
					#$this->session->set_userdata('idLicencia',$licencia->idLicencia);
					
					$this->session->set_userdata('id',$licencia->idUsuario);
					$this->session->set_userdata('idLicencia',$licencia->idLicencia);
					
					$this->modelousuario->accesoUsuario($licencia); //Actualizar la fecha de acceso
					$this->session->set_userdata('mensajeRedisoft','1');
				}
				else
				{
					redirect('login/logout','refresh');
				}
				
				if($this->configuracion->comprobarHorario($licencia->idUsuario)==0)
				{
					$this->session->set_userdata('errorNotificacion','El dia y horario de acceso no estan disponibles para el usuario');	
					
					redirect('login');
				}

				redirect(base_url()."principal/index/","refresh");
				
				
				switch($this->redux_auth->id_logged_in_role())
				{
					case 0: 	
					redirect(base_url()."principal/index/","refresh");
					break;
					
					case 1: 
					redirect(base_url()."principal/index/","refresh");
					break;
					
					case 2:
					
					break;
				}//Fin del switch
				
				break; //break==true
				
			}//fin del switch 
		}//Else de datos no introducidos correctamente
	}//Fin de acceso
 
 //*** Funcion para acceso desde aplicaciones mobiles iOS/Android esto

	public function accesoMobil()
	{
		
		$user = $this->input->get('username');
		$pass = $this->input->get('password');
		
		if (empty($user) || empty($pass))
		{
			$data =array("errorID"=>"1","message"=>"Ingrese la informacion solicitada","nombre"=>"","apellidoPaterno"=>"","idRol"=>"");
			echo json_encode($data);
		}
		else
		{
			
			$redux 	= $this->redux_auth->login($user,$pass);
			$anio	=date("Y");
			switch($redux)
			{
				case false: 
					$data =array("errorID"=>"2","message"=>"El nombre de usuario o clave son incorrectos","nombre"=>"","apellidoPaterno"=>"","idRol"=>"");
					echo json_encode($data);
				break;
				case true:
					$usuario=$this->modelousuario->obtenerUsuarioMobil($user,$pass,"1");
					if($usuario!=null)
					{
						$usuario->errorID="5";
						$usuario->message="fine";
						echo json_encode($usuario);
					}
					else
					{
						$data =
							[
								"errorID"=>"3",
								"message"=>"Usuario inactivo",
								"nombre"=>"",
								"apellidoPaterno"=>"",
								"idRol"=>""
							];
						echo json_encode($data);
					}
				break; //break==true
				
			}//fin del switch 
		}//Else de datos no introducidos correctamente
	
	}//Fin de accesoMobil
 
 
 
 
//********* Salir del Sistema
	public function logout()
	{
		if(isset($_SESSION))
		{
			#$this->session->sess_destroy();
		}
		$this->session->unset_userdata("conexionGmail");
		$this->session->unset_userdata('idLicencia');
		$this->session->unset_userdata('id');
		$this->session->unset_userdata('calendario');
		$this->redux_auth->logout();
		
		redirect(base_url().'login','refresh');
	}
	
	function enviarConfirmacion()
	{
		if(!empty($_POST))
		{
			$password=$this->modelousuario->obtenerPasswordCorreo();
			$configuracion=$this->configuracion->obtenerConfiguracion();
			
			if($password!=null)
			{
				#$email="licfloresdejesus@gmail.com";
				#$nombre='Mauricio Flores';
				
				$email=$configuracion['correo'];
				$nombre=$configuracion['nombre_empresa'];
				
				//$to="licfloresdejesus@gmail.com";
				$to=$this->input->post('correo');
				
				$this->load->library('email');
				$this->email->from($email,$nombre);
				#$this->email->to($this->system_library->settings['request_email']);
				$this->email->to($to);
				
				$asunto='Hola de click en este link para recuperar su contraseña: ';
				
				$asunto.=base_url()."login/confirmacion/".$password->password."/".$password->username; 
				
				$this->email->subject('Recuperar password');
				$this->email->message
				(
					$asunto
				);
				
				if (!$this->email->send())
				{
					print("0");
				}
				else
				{
					print("1");
				}
					
			}
			else
			{
				print("2");
			}
		}
	}//function

	public function matarToken()
	{		
		$this->googleplus->revokeToken();
		$this->session->unset_userdata("conexionGmail");
		
		redirect('dashboard','refresh');
	}
}
?>