<?php
class Dashboard extends CI_Controller
{
	private $_template;
	protected $_fechaActual;
	protected $_iduser;
	protected $_csstyle;
	protected $_jss;	
	protected $idLicencia;
	protected $cuota;
	protected $idRol;
	
	function __construct()
	{
		parent::__construct();
		
		if(!$this->redux_auth->logged_in())
		{
 			redirect(base_url().'login');
 		}
		
		$this->config->load('style', TRUE);
		$this->config->load('js',TRUE);
		
		$datestring   			= "%Y-%m-%d %H:%i:%s";
		$this->_fechaActual 	= mdate($datestring,now());
	    $this->_iduser 			= $this->session->userdata('id');
		$this->idLicencia 		= $this->session->userdata('idLicencia');
		$this->idRol 			= $this->session->userdata('rol');
		$this->_csstyle 		= $this->config->item('style');
		$this->_jss				= $this->config->item('js');
		
		$this->load->model("modelousuario","modelousuario");
		$this->load->model("modelo_configuracion","configuracion");
		$this->load->model("dashboard_modelo","dashboard");
		$this->load->model("modeloclientes","clientes");
		$this->load->model("reportes_model","reportes");
		$this->load->model("crm_modelo","crm");
		
		$this->configuracion->accesoUsuario(); //CONTROL DE ACCESOS
		$this->cuota	= $this->configuracion->comprobarCuota(); //COMPROBAR CUOTA DE DISCO
 	}
	
	public function index()
	{
		$Data['title']			= "Panel de Administración";	
		$Data['cassadmin']		= $this->_csstyle["cassadmin"];
		$Data['csmenu']			= $this->_csstyle["csmenu"];
		$Data['csui']			= $this->_csstyle["csui"];
		$Data['csvalidate']		= $this->_csstyle["csvalidate"];
		$Data['Jry']			= $this->_jss['jquery'];	  	 	
		$Data['Jqui']			= $this->_jss['jqueryui'];   
		$Data['Jquical']		= $this->_jss['jquerycal'];
		$Data['nameusuario']	= $this->modelousuario->getUsuarios($this->_iduser);
		$Data['Fecha_actual']	= $this->_fechaActual;
		$Data['menuActivo'] 	= 'calendario';
		$Data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
		$Data['conectados']		= $this->configuracion->obtenerUsuariosConectados(); //USUARIOS CONECTADOS
		
		$usuario				= $this->configuracion->obtenerUsuario($this->_iduser);
		$rol					= $this->configuracion->obtenerRol($usuario->idRol); 
		
		
		$this->load->view("cabezera",$Data);
		$this->load->view('header',$Data);
		$this->load->view("principal",$Data);
		#-------------------------------------DETECTAR LOS MENUS ACTIVOS------------------------------------------#
		
		$data['permiso']	=$this->configuracion->obtenerPermisosBoton('59',$this->session->userdata('rol'));
		
		if($data['permiso'][0]->activo=='0')
		{
			$this->load->view('accesos/index');
			$this->load->view("pie",$Data);
			return;
		}
		
		$data['idUsuario']		= $this->_iduser;
		$data["breadcumb"]		= 'Calendario';

		$this->load->view('dashboard/index',$data);
		$this->load->view("pie",$Data);		
	}

	public function obtenerRegistros()
	{
		$data['fechaActual']	= $this->input->post('fecha');
		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('62',$this->session->userdata('rol'));

		$this->load->view('dashboard/obtenerRegistrosSemanal',$data);
	}

	public function obtenerDetalleSeguimiento()
	{
		$data['registro']		= $this->crm->obtenerDetalleSeguimiento($this->input->post('idDetalle'));
		$data['seguimiento']	= $this->clientes->obtenerSeguimiento($data['registro']->idSeguimiento);

		$this->load->view('dashboard/obtenerDetalleSeguimiento',$data);
	}

	public function formularioSeguimientoTablero()
	{
		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('62',$this->session->userdata('rol'));
		
		$data['status']			= $this->configuracion->obtenerStatus(1);
		$data['estatus']		= $this->configuracion->obtenerEstatus(0);
		$data['servicios']		= $this->configuracion->obtenerServicios(1);
		$data['promotores']		= $this->configuracion->obtenerResponsables(0,0,1);
		$data['responsables']	= $this->configuracion->obtenerResponsables();
		$data['folio']			= obtenerFolioSeguimiento($this->crm->obtenerFolioSeguimientoCliente(0));
		$dias					= $this->reportes->obtenerDiferenciaFechas(date('Y-m-d'),$this->input->post('fecha'),'day');
		$data['idRol']			= $this->idRol;
		$data['idUsuario']		= $this->_iduser;
		$data['fecha']			= $dias>=0?$this->input->post('fecha'):date('Y-m-d');
		$data['hora']			= $this->input->post('hora');
		
		$this->load->view('dashboard/formularioSeguimientoProspectos',$data);
	}

	public function calendario()
	{
		$permiso		= $this->configuracion->obtenerPermisosBoton(70,$this->session->userdata('rol'));

		if($permiso[0]->activo=='0')
		{
			redirect('principal/permisosUsuario','refresh');
		}

		redirect($this->google->loginUrl(),'refresh');
	}

	public function conexionGmail()
    {
		$permiso		= $this->configuracion->obtenerPermisosBoton(70,$this->session->userdata('rol'));

        $code = $this->input->get('code', true);
       
	    $this->google->login($code);

		$this->session->set_userdata("conexionGmail","1");

		redirect(base_url().'dashboard', 'refresh');
    }
}
?>
