<?php
class Cobranza extends CI_Controller
{
	protected $_fechaActual;
	protected $_iduser;
	protected $_csstyle;
    protected $_tables;
    protected $_role;
	protected $idTienda;
	protected $cuota;
	protected $orden;
	protected $fecha;
	protected $precios;

	function __construct()
	{
		parent::__construct();

		if( ! $this->redux_auth->logged_in() )
		{
 			redirect(base_url().'login');
 		}

		$this->config->load('datatables', TRUE);
		$this->config->load('style', TRUE);
		$this->config->load('js',TRUE);

		$this->_jss				= $this->config->item('js');
		$datestring   			= "%Y-%m-%d %H:%i:%s";
	    $this->_fechaActual 	= date('Y-m-d H:i:s');
		$this->_iduser 			= $this->session->userdata('id');
		$this->_role 			= $this->session->userdata('role');
		$this->_tables 			= $this->config->item('datatables');
		$this->_csstyle 		= $this->config->item('style');
		$this->fecha 			= date('Y-m-d');

		$this->perPage = 20;

		$this->load->model("crm_modelo","crm");
		$this->load->model("bancos_model","bancos");
	 	$this->load->model("modeloclientes","clientes");
        $this->load->model("modelousuario","modelousuario");
		$this->load->model("facturacion_modelo","facturacion");
		$this->load->model("inventarioproductos_modelo","inventarioProductos");
		$this->load->model("inventario_model","inventario");
		$this->load->model("modelo_configuracion","configuracion");
		$this->load->model("ventas_model","ventas");
		$this->load->model("previa_modelo","previa");
		$this->load->model("facturaventa_modelo","facturaVenta");
		$this->load->model("reportes_model","reportes");
		$this->load->model("tiendas_modelo","tiendas");
		$this->load->model("arreglos_modelo","arreglos");
		$this->load->model("contabilidad_modelo","contabilidad");
		$this->load->model("temporal_modelo","temporal");

		$this->load->model("ventas_modelo","ventasmodelo");
		$this->load->model("ventas_model","ventas");
		$this->load->model("catalogos_modelo","catalogos");

		$this->load->model("importar_modelo","importar");
		$this->load->model("cobranza_modelo","cobranza");
		$this->load->model('estatus_modelo','estatus');

		$this->idTienda 		= $this->session->userdata('idTiendaActiva');

		$this->configuracion->accesoUsuario(); //CONTROL DE ACCESOS
		$this->cuota	= $this->configuracion->comprobarCuota(); //COMPROBAR CUOTA DE DISCO

		$this->precios	= $this->session->userdata('precios');

  	}

	public function index()
	{
		$Data['title']			= "Panel de Administración";
		$Data['cassadmin']		= $this->_csstyle["cassadmin"];
		$Data['csmenu']			= $this->_csstyle["csmenu"];
		$Data['csvalidate']		= $this->_csstyle["csvalidate"];
		$Data['csui']			= $this->_csstyle["csui"];
		$Data['nameusuario']	= $this->modelousuario->getUsuarios($this->_iduser);
		$Data['Fecha_actual']	= $this->_fechaActual;
		$Data['Jry']			= $this->_jss['jquery'];
		$Data['jFicha_cliente']	= $this->_jss['jFicha_cliente'];
		$Data['Jquical']		= $this->_jss['jquerycal'];
		$Data['Jqui']			= $this->_jss['jqueryui'];
		#$Data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
		$Data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
		$Data['menuActivo']		= 'cobranza';
		$Data['conectados']		= $this->configuracion->obtenerUsuariosConectados(); //USUARIOS CONECTADOS

		$this->load->view("cabezera",$Data);
		$this->load->view('header',$Data);
		$this->load->view("principal",$Data);

		#----------------------------------PERMISOS------------------------------------#

		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('69',$this->session->userdata('rol'));


		if($data['permiso'][0]->activo=='0')
		{
			$this->load->view('accesos/index');
			$this->load->view("pie",$Data);

			return;
		}

		$data['zonas']			= $this->configuracion->obtenerZonas();
		$data['servicios']		= $this->configuracion->obtenerServicios(1);
		$data['responsables']	= $this->configuracion->obtenerResponsables();
		$data['grupos']			= $this->clientes->agruparClientesRegistro();
		$data["breadcumb"]		= 'Cobranza';

		$this->load->view("clientes/cobranza/index",$data);
		$this->load->view("pie",$Data);
	}

	public function obtenerCobranza($limite=0)
	{
		$criterio		= trim($this->input->post('criterio'));
		$idStatus		= $this->input->post('idStatus');
		$idServicio		= $this->input->post('idServicio');
		$fecha			= $this->input->post('fecha');
		$idResponsable	= $this->input->post('idResponsable');
		$idTipo			= $this->input->post('idTipo');
		$fechaMes		= $this->input->post('mes');
		$idZona			= 0;
		$idPrograma		= $this->input->post('idPrograma');
		$idCampana		= $this->input->post('idCampana');
		$diaPago		= $this->input->post('diaPago');
		$matricula		= 1;
		$orden			= $this->input->post('orden');

		#----------------------------------PERMISOS------------------------------------#

		$data['permiso']		= $this->configuracion->obtenerPermisosBoton(69,$this->session->userdata('rol'));

		if($data['permiso'][0]->activo=='0')
		{
			$this->load->view('accesos/index');

			return;
		}

		#----------------------------------PAGINACION------------------------------------#
		$url		= base_url()."cobranza/obtenerCobranza/";
		$registros	= $this->clientes->contarClientes($criterio,$idStatus,$idServicio,$fecha,$idResponsable,$idTipo,$fechaMes,1,$idZona,$idPrograma,$diaPago,$idCampana,$matricula);
		$numero		= 20;
		$links		= 5;
		$uri		= 3;

		$paginador=$this->paginas->paginar($url,$registros,$numero,$links,$uri);
		$this->pagination->initialize($paginador);
		#---------------------------------------------------------------------------------#

		$data['zonas']			= $this->configuracion->obtenerZonas();
		$data['clientes']		= $this->clientes->obtenerClientesUsuario($numero,$limite,$criterio,$idStatus,$idServicio,$fecha,$idResponsable,$idTipo,$fechaMes,1,$idZona,$idPrograma,$diaPago,$idCampana,$matricula,$orden);

		$data['status']			= $this->configuracion->obtenerStatus(1);
		$data['servicios']		= $this->configuracion->obtenerServicios(1);
		$data['responsables']	= $this->configuracion->obtenerResponsables();
		$data['programas']		= $this->configuracion->obtenerProgramas();
		$data['campanas']		= $this->configuracion->obtenerCampanas();

		#$data['cliente']		= $this->clientes->obtenerCliente($idCliente);
		$data['zonas']			= $this->configuracion->obtenerZonas();
		#$data['idCliente']		= $idCliente;
		$data['idStatus']		= $idStatus;
		$data['idResponsable']	= $idResponsable;
		$data['idServicio']		= $idServicio;
		$data['idTipo']			= $idTipo;
		$data['fecha']			= $fecha;
		$data['inicio']  		= $limite+1;
		$data['fechaMes']		= $fechaMes;
		$data['idZona']			= $idZona;
		$data['idPrograma']		= $idPrograma;
		$data['idCampana']		= $idCampana;
		$data['tipoRegistro']	= $this->input->post('tipoRegistro');
		$data['diaPago']		= $diaPago;
		$data['registros']		= $registros;
		$data['matricula']		= $matricula;
		$data['orden']			= $orden;
		#$data["breadcumb"]		= sistemaActivo=='IEXE'?'Alumnos/Clientes':'Clientes';

		$this->load->view('clientes/cobranza/obtenerRegistros',$data);
	}

	public function diario()
	{
		$Data['title']			= "Panel de Administración";
		$Data['cassadmin']		= $this->_csstyle["cassadmin"];
		$Data['csmenu']			= $this->_csstyle["csmenu"];
		$Data['csvalidate']		= $this->_csstyle["csvalidate"];
		$Data['csui']			= $this->_csstyle["csui"];
		$Data['nameusuario']	= $this->modelousuario->getUsuarios($this->_iduser);
		$Data['Fecha_actual']	= $this->_fechaActual;
		$Data['Jry']			= $this->_jss['jquery'];

		$Data['Jquical']		= $this->_jss['jquerycal'];
		$Data['Jqui']			= $this->_jss['jqueryui'];
		#$Data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
		$Data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
		$Data['menuActivo']		= 'cobranza';
		$Data['conectados']		= $this->configuracion->obtenerUsuariosConectados(); //USUARIOS CONECTADOS

		$this->load->view("cabezera",$Data);
		$this->load->view('header',$Data);
		$this->load->view("principal",$Data);

		#----------------------------------PERMISOS------------------------------------#

		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('69',$this->session->userdata('rol'));

		if($data['permiso'][0]->activo=='0')
		{
			$this->load->view('accesos/index');
			$this->load->view("pie",$Data);

			return;
		}

		$data['seguimientos']		= $this->cobranza->obtenerSeguimientoDiario();
		$data['campanas']			= $this->configuracion->obtenerCampanas();
		$data['idUsuario']			= $this->_role!=1?$this->_iduser:0;
		$data['alertasPasado']		= null;

		/*if($data['seguimientos']==null)
		{
			$data['alertasPasado']		= $this->crm->obtenerSeguimientoAlertaPasadoFechas();
		}*/

		$data["breadcumb"]			= 'Cobranza diario';

		$this->load->view("clientes/cobranza/diario/index",$data);
		$this->load->view("pie",$Data);
	}

	public function obtenerSeguimientoDiario()
	{
		$idCliente					= $this->input->post('idCliente');

		$data['detalles']			= $this->cobranza->obtenerSeguimientoDiarioCliente($idCliente);
		$data['cliente']			= $this->clientes->obtenerCliente($idCliente);
		$data['temas']				= $this->cobranza->obtenerTemas();
		$data['contactos']			= $this->cobranza->obtenerContactos();
		$data['idCliente']			= $idCliente;
		$data['idRol']				= $this->_role;
		$data['permiso']			= $this->configuracion->obtenerPermisosBoton('69',$this->session->userdata('rol'));

		$this->load->view('clientes/cobranza/diario/obtenerSeguimientoDiario',$data);
	}

	public function obtenerSeguimientosDiarios()
	{
		$fecha						= $this->input->post('fecha');

		$data['seguimientos']		= $this->cobranza->obtenerSeguimientoDiarioFecha($fecha);
		$data['fecha']				= $fecha;

		$this->load->view('clientes/cobranza/diario/obtenerSeguimientosDiarios',$data);
	}

	public function registrarSeguimiento()
	{
		if(!empty($_POST))
		{
			echo json_encode($this->cobranza->registrarSeguimiento());
		}
		else
		{
			echo  json_encode(array("0",'Sin cambios'));
		}
	}

	public function seguimientoClienteCobranza()
	{
		$idCliente					= $this->input->post('idCliente');

		$data['cliente']			= $this->clientes->obtenerCliente($idCliente);

		$this->load->view('clientes/cobranza/seguimiento/seguimientoClienteCobranza',$data);
	}

	public function obtenerCrmCobranza($limite=0)
	{
		$idCliente		= trim($this->input->post('idCliente'));
		$inicio			= $this->input->post('inicio');
		$fin			= $this->input->post('fin');

		#----------------------------------PERMISOS------------------------------------#

		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('69',$this->session->userdata('rol'));


		if($data['permiso'][0]->activo=='0')
		{
			$this->load->view('accesos/index');

			return;
		}

		#----------------------------------PAGINACION------------------------------------#
		$url					= base_url()."cobranza/obtenerSeguimientoCliente/";
		$registros				= $this->cobranza->contarSeguimientoCliente($idCliente,$inicio,$fin);
		$numero					= 20;
		$links					= 5;
		$uri					= 3;

		$paginador				= $this->paginas->paginar($url,$registros,$numero,$links,$uri);
		$this->pagination->initialize($paginador);
		#---------------------------------------------------------------------------------#

		$data['registros']		= $this->cobranza->obtenerSeguimientoCliente($numero,$limite,$idCliente,$inicio,$fin);
		$data['numero']			= $registros;

		$data['idCliente']		= $idCliente;
		$data['inicio']			= $inicio;
		$data['fin']			= $fin;
		$data['limite']			= $limite+1;

		$this->load->view('clientes/cobranza/seguimiento/obtenerRegistros',$data);
	}

	public function obtenerEstatusCliente()
	{
		$idCliente					= $this->input->post('idCliente');

		$data['cliente']			= $this->clientes->obtenerCliente($idCliente);
		$data['estatus']			= $this->estatus->obtenerRegistros();

		$this->load->view('clientes/cobranza/estatus/obtenerEstatusCliente',$data);
	}

	public function editarEstatusCliente()
	{
		if(!empty($_POST))
		{
			echo json_encode($this->cobranza->editarEstatusCliente());
		}
		else
		{
			echo  json_encode(array("0",'Sin cambios'));
		}
	}

	public function reporte()
	{
		$Data['title']			= "Panel de Administración";
 		$Data['cassadmin']		= $this->_csstyle["cassadmin"];
 		$Data['csmenu']			= $this->_csstyle["csmenu"];
 		$Data['csvalidate']		= $this->_csstyle["csvalidate"];
 		$Data['csui']			= $this->_csstyle["csui"];
 		$Data['nameusuario']	= $this->modelousuario->getUsuarios($this->_iduser);
 		$Data['Fecha_actual']	= date('Y-m-d');
		$Data['primer_dia'] = date('Y-m-01');
 		$Data['Jry']			= $this->_jss['jquery'];

 		$Data['Jquical']		= $this->_jss['jquerycal'];
 		$Data['Jqui']			= $this->_jss['jqueryui'];

 		$Data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
 		$Data['menuActivo']		= 'reporte';
 		$Data['conectados']		= $this->configuracion->obtenerUsuariosConectados(); //USUARIOS CONECTADOS

 		$this->load->view("cabezera",$Data);
 		$this->load->view('header',$Data);
 		$this->load->view("principal",$Data);

 		#----------------------------------PERMISOS------------------------------------#
 		$data['permiso'] = $this->configuracion->obtenerPermisosBoton('69',$this->session->userdata('rol'));

 		if($data['permiso'][0]->activo=='0')
 		{
 			$this->load->view('accesos/index');
 			$this->load->view("pie",$Data);
 			return;
 		}

 		$data['idUsuario']			= $this->_role!=1?$this->_iduser:0;
 		$data['alertasPasado']		= null;
 		$data["breadcumb"]			= 'Reporte';
 		$this->load->view("clientes/cobranza/reporte/index",$data);
 		$this->load->view("pie",$Data);
	}

	public function obtener_reporte()
	{
	 //get rows count
 	 $conditions['returnType'] = 'count';
 	 $conditions['inicio'] = $this->input->post('inicio');
	 $conditions['fin'] = $this->input->post('fin');
	 $data['total']	=  $this->cobranza->reporte($conditions);
 	 $npagina=$this->input->post('nropagina');

 	 //limites de paginador
 	 $data['start'] = $conditions['start'] = ($npagina-1)*$this->perPage;
 	 $data['limit'] = $conditions['limit'] = $this->perPage;

	 //obtenemos la informacion
 	 $conditions['returnType'] = '';
	 $data['registros'] = $this->cobranza->reporte($conditions);

 	 echo json_encode($data);
	}

	public function exportar_reporte()
	{
		ini_set("memory_limit","1500M");
	  set_time_limit(0);
		$conditions['inicio'] = $this->input->post('inicio');
		$conditions['fin'] = $this->input->post('fin');
		$data['registros'] = $this->cobranza->reporte($conditions);
		$this->load->library('excel/PHPExcel');
    $this->load->view('clientes/cobranza/reporte/exportarCobranza',$data);
		//echo json_encode($data);
	}

}
?>
