<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Catalogos extends CI_Controller 
{
	protected $_jss;
	protected $_csstyle;
	protected $cuota;
	  
	public function __construct()
	{
		parent::__construct();
		
		$this->load->model('catalogos_modelo','catalogos');
		$this->load->model('modelo_configuracion','configuracion');
		$this->load->model('modelousuario','usuarios');
		$this->load->model('modeloclientes','clientes');
		#$this->load->model('facturacion_modelo','facturacion');
		
		if( ! $this->redux_auth->logged_in() )
		{
			redirect(base_url().'login');
		}
		
		$this->config->load('js',TRUE);
		$this->config->load('style', TRUE);
		
		$this->_fechaActual 	= mdate("%Y-%m-%d %H:%i:%s",now());
		$this->_iduser 			= $this->session->userdata('id');
		$this->_csstyle 		= $this->config->item('style');
		$this->_jss				= $this->config->item('js');
		
		$this->configuracion->accesoUsuario(); //CONTROL DE ACCESOS
		$this->cuota	= $this->configuracion->comprobarCuota(); //COMPROBAR CUOTA DE DISCO
	}
	
	//DEPARTAMENTOS
	public function departamentos()
	{
		$Data['title']			= "Panel de Administración";
		$Data['cassadmin']		= $this->_csstyle["cassadmin"];
		$Data['csmenu']			= $this->_csstyle["csmenu"];   
		$Data['csvalidate']		= $this->_csstyle["csvalidate"];
		$Data['csui']			= $this->_csstyle["csui"];
		$Data['Jry']			= $this->_jss['jquery'];
		$Data['Jqui']			= $this->_jss['jqueryui'];
		$Data['jvalidate']		= $this->_jss['jvalidate'];
		$Data['nameusuario']	= $this->usuarios->getUsuarios($this->_iduser);
		$Data['Fecha_actual']	= $this->_fechaActual;    
		$Data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
		$Data['menuActivo']		= 'configuracion'; 
		$Data['conectados']		= $this->configuracion->obtenerUsuariosConectados(); //USUARIOS CONECTADOS
		
		$this->load->view("cabezera",$Data);
		$this->load->view('header',$Data);
		$this->load->view("principal",$Data);
		
		#----------------------------------PERMISOS------------------------------------#
		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('50',$this->session->userdata('rol'));
		
		if($data['permiso'][0]->activo=='0')
		{
			$this->load->view('accesos/index');
			$this->load->view("pie",$Data);
			return;
		}
		
		$data["breadcumb"]		= 'Departamentos';
		
		$this->load->view("configuracion/departamentos/departamentos",$data);
		$this->load->view("pie",$Data);
	}
	
	public function obtenerDepartamentos()
	{
		$data['departamentos']		= $this->catalogos->obtenerDepartamentos();
		$data['permiso']			= $this->configuracion->obtenerPermisosBoton('50',$this->session->userdata('rol'));
		
		$this->load->view("configuracion/departamentos/obtenerDepartamentos",$data);
	}
	
	public function formularioDepartamentos()
	{
		$this->load->view("configuracion/departamentos/formularioDepartamentos");
	}
	
	public function obtenerDepartamento()
	{
		if(!empty ($_POST))
		{
			$data['departamento']	= $this->catalogos->obtenerDepartamento($this->input->post('idDepartamento'));
			
			$this->load->view("configuracion/departamentos/obtenerDepartamento",$data);
		}
	}
	
	public function registrarDepartamento()
	{
		if(!empty ($_POST))
		{
			if(!$this->cuota)
			{
				echo json_encode(array('0',mensajeCuota));
				return;
			}
			
			echo json_encode($this->catalogos->registrarDepartamento());
		}
		else
		{
			echo json_encode(array("0",errorRegistro));
		}
	}
	
	public function editarDepartamento()
	{
		if(!empty ($_POST))
		{
			echo json_encode($this->catalogos->editarDepartamento());
		}
		else
		{
			echo json_encode(array("0",errorRegistro));
		}
	}
	
	public function borrarDepartamento()
	{
		if (!empty($_POST))
		{
			#----------------------------------PERMISOS------------------------------------#
			$data['permiso']	= $this->configuracion->obtenerPermisosBoton('50',$this->session->userdata('rol'));
			
			if($data['permiso'][3]->activo=='0')
			{
				echo "0";
				return;
			}
	
			echo $this->catalogos->borrarDepartamento($this->input->post('idDepartamento'));
		}
		else
		{
			echo "0";
		}
	}
	
	//MARCAS
	public function marcas()
	{
		$Data['title']			= "Panel de Administración";
		$Data['cassadmin']		= $this->_csstyle["cassadmin"];
		$Data['csmenu']			= $this->_csstyle["csmenu"];   
		$Data['csvalidate']		= $this->_csstyle["csvalidate"];
		$Data['csui']			= $this->_csstyle["csui"];
		$Data['Jry']			= $this->_jss['jquery'];
		$Data['Jqui']			= $this->_jss['jqueryui'];
		$Data['jvalidate']		= $this->_jss['jvalidate'];
		$Data['nameusuario']	= $this->usuarios->getUsuarios($this->_iduser);
		$Data['Fecha_actual']	= $this->_fechaActual;    
		$Data['permisos']		= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
		$Data['menuActivo']		= 'configuracion'; 
		$Data['conectados']		= $this->configuracion->obtenerUsuariosConectados(); //USUARIOS CONECTADOS
		
		$this->load->view("cabezera",$Data);
		$this->load->view('header',$Data);
		$this->load->view("principal",$Data);
		
		#----------------------------------PERMISOS------------------------------------#
		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('50',$this->session->userdata('rol'));
		
		if($data['permiso'][0]->activo=='0')
		{
			$this->load->view('accesos/index');
			$this->load->view("pie",$Data);
			return;
		}
		
		$data["breadcumb"]		= 'Marcas';
		
		$this->load->view("configuracion/marcas/marcas",$data);
		$this->load->view("pie",$Data);
	}
	
	public function obtenerMarcas()
	{
		$data['marcas']			= $this->catalogos->obtenerMarcas();
		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('50',$this->session->userdata('rol'));
		
		$this->load->view("configuracion/marcas/obtenerMarcas",$data);
	}
	
	public function formularioMarcas()
	{
		$this->load->view("configuracion/marcas/formularioMarcas");
	}
	
	public function obtenerMarca()
	{
		if(!empty ($_POST))
		{
			$data['marca']	= $this->catalogos->obtenerMarca($this->input->post('idMarca'));
			
			$this->load->view("configuracion/marcas/obtenerMarca",$data);
		}
	}
	
	public function registrarMarca()
	{
		if(!empty ($_POST))
		{
			if(!$this->cuota)
			{
				echo json_encode(array('0',mensajeCuota));
				return;
			}
			
			echo json_encode($this->catalogos->registrarMarca());
		}
		else
		{
			echo json_encode(array("0",errorRegistro));
		}
	}
	
	public function editarMarca()
	{
		if(!empty ($_POST))
		{
			echo json_encode($this->catalogos->editarMarca());
		}
		else
		{
			echo json_encode(array("0",errorRegistro));
		}
	}
	
	public function borrarMarca()
	{
		if (!empty($_POST))
		{
			#----------------------------------PERMISOS------------------------------------#
			$data['permiso']	= $this->configuracion->obtenerPermisosBoton('50',$this->session->userdata('rol'));
			
			if($data['permiso'][3]->activo=='0')
			{
				echo "0";
				return;
			}
	
			echo $this->catalogos->borrarMarca($this->input->post('idMarca'));
		}
		else
		{
			echo "0";
		}
	}
	
	//VARIABLES
	#-----------------------------------------------------------------------------------------------------------------------------------------#
	public function variables()
	{
		#----------------------------------PERMISOS------------------------------------#
		$data['permiso']=$this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		
		/*if($data['permiso']->leer=='0' and $data['permiso']->escribir=='0')
		{
			redirect('principal/permisosUsuario','refresh');
			return;
		}*/
		
		$Data['title']				= "Panel de Administración";
		$Data['cassadmin']			= $this->_csstyle["cassadmin"];
		$Data['csmenu']				= $this->_csstyle["csmenu"];
		$Data['csvalidate']			= $this->_csstyle["csvalidate"];
		$Data['csui']				= $this->_csstyle["csui"];
		$Data['nameusuario']		= $this->usuarios->getUsuarios($this->_iduser);
		$Data['Fecha_actual']		= $this->fecha;
		$Data['Jry']				= $this->_jss['jquery'];
		$Data['Jqui']				= $this->_jss['jqueryui'];                  
		$Data['permisos']			= $this->configuracion->obtenerRolPermisos($this->session->userdata('rol'));
		$Data['menuActivo']			= 'variables'; 
		
		$this->load->view("cabezera",$Data);
		$this->load->view('header',$Data);    
		$this->load->view("principal",$Data);
		$this->load->view("inventarioProductos/variables/index",$data); //principal lista de clientes
		$this->load->view("pie",$Data);
	}

	public function obtenerVariables()
	{
		$data['permiso']		= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		$data['variables']		= $this->catalogos->obtenerVariables();
		
		$this->load->view("inventarioProductos/variables/obtenerVariables",$data);
	}
	
	public function formularioVariables()
	{
		$this->load->view("inventarioProductos/variables/formularioVariables");
	}
	
	public function obtenerVariable()
	{
		if (!empty($_POST))
		{
			$data['variable']	=$this->catalogos->obtenerVariable($this->input->post('idVariable'));
			$this->load->view("inventarioProductos/variables/obtenerVariable",$data);
		}
	}
	
	public function registrarVariable()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->registrarVariable();
		}
		else
		{
			echo "0";
		}
	}
	
	public function editarVariable()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->editarVariable();
		}
		else
		{
			echo "0";
		}
	}
	
	public function borrarVariable()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->borrarVariable($this->input->post('idVariable'),$this->input->post('tipo'));
		}
		else
		{
			echo "0";
		}
	}
	
	public function listaVariables()
	{
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		$data['variable']	= $this->catalogos->obtenerTipoVariable($this->input->post('tipo'));
		
		$this->load->view("inventarioProductos/variables/index",$data);
	}
	
	//AUTOCOMPLETADOS CATÁLOGOS
	
	public function obtenerCatalogos($tipo,$numero=0,$idLinea=0)
	{
		$datos = $this->catalogos->obtenerCatalogos($this->input->get('term'),$tipo,$numero,$idLinea);
		
		if($datos!=null)
		{
			foreach ($datos as $row)
			{
				$result[]= $row;
			}
			
			echo json_encode($result);
		}
	}
	
	//NIVELES
	
	public function listaNiveles1()
	{
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		
		$this->load->view("administracion/niveles/nivel1/index",$data);
	}

	public function obtenerNiveles1($limite=0)
	{
		$criterio				= $this->input->post('criterio');

		$Pag["base_url"]		= base_url()."catalogos/obtenerNiveles1/";
		$Pag["total_rows"]		= $this->catalogos->contarNiveles1($criterio);
		$Pag["per_page"]		= 10;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['niveles'] 		= $this->catalogos->obtenerNiveles1($Pag["per_page"],$limite,$criterio);
		$data['inicio']  		= $limite+1;

		$this->load->view("administracion/niveles/nivel1/obtenerNiveles",$data);
	}
	
	public function formularioNiveles1()
	{
		$this->load->view("administracion/niveles/nivel1/formularioNiveles");
	}
	
	public function obtenerNivel1()
	{
		if (!empty($_POST))
		{
			$data['nivel']	= $this->catalogos->obtenerNivel1($this->input->post('idNivel1'));
			
			$this->load->view("administracion/niveles/nivel1/obtenerNivel",$data);
		}
	}
	
	public function registrarNivel1()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->registrarNivel1();
		}
		else
		{
			echo "0";
		}
	}
	
	public function editarNivel1()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->editarNivel1();
		}
		else
		{
			echo "0";
		}
	}
	
	public function borrarNivel1()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->borrarNivel1($this->input->post('idNivel1'));
		}
		else
		{
			echo "0";
		}
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//NIVEL 2
	
	public function listaNiveles2()
	{
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		
		$this->load->view("administracion/niveles/nivel2/index",$data);
	}

	public function obtenerNiveles2($limite=0)
	{
		$criterio				= $this->input->post('criterio');

		$Pag["base_url"]		= base_url()."catalogos/obtenerNiveles2/";
		$Pag["total_rows"]		= $this->catalogos->contarNiveles2($criterio);
		$Pag["per_page"]		= 10;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['niveles'] 		= $this->catalogos->obtenerNiveles2($Pag["per_page"],$limite,$criterio);
		$data['inicio']  		= $limite+1;

		$this->load->view("administracion/niveles/nivel2/obtenerNiveles",$data);
	}
	
	public function formularioNiveles2()
	{
		$data['nivel1']	= $this->catalogos->obtenerNiveles1();
		
		$this->load->view("administracion/niveles/nivel2/formularioNiveles",$data);
	}
	
	public function obtenerNivel2()
	{
		if (!empty($_POST))
		{
			$data['nivel']	= $this->catalogos->obtenerNivel2($this->input->post('idNivel2'));
			
			$this->load->view("administracion/niveles/nivel2/obtenerNivel",$data);
		}
	}
	
	public function registrarNivel2()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->registrarNivel2();
		}
		else
		{
			echo "0";
		}
	}
	
	public function editarNivel2()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->editarNivel2();
		}
		else
		{
			echo "0";
		}
	}
	
	public function borrarNivel2()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->borrarNivel2($this->input->post('idNivel2'));
		}
		else
		{
			echo "0";
		}
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//NIVEL 3
	
	public function listaNiveles3()
	{
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		
		$this->load->view("administracion/niveles/nivel3/index",$data);
	}

	public function obtenerNiveles3($limite=0)
	{
		$criterio				= $this->input->post('criterio');

		$Pag["base_url"]		= base_url()."catalogos/obtenerNiveles3/";
		$Pag["total_rows"]		= $this->catalogos->contarNiveles3($criterio);
		$Pag["per_page"]		= 10;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['niveles'] 		= $this->catalogos->obtenerNiveles3($Pag["per_page"],$limite,$criterio);
		$data['inicio']  		= $limite+1;

		$this->load->view("administracion/niveles/nivel3/obtenerNiveles",$data);
	}
	
	public function formularioNiveles3()
	{
		$data['nivel2']	= $this->catalogos->obtenerNiveles2();
		
		$this->load->view("administracion/niveles/nivel3/formularioNiveles",$data);
	}
	
	public function obtenerNivel3()
	{
		if (!empty($_POST))
		{
			$data['nivel']	= $this->catalogos->obtenerNivel3($this->input->post('idNivel3'));
			
			$this->load->view("administracion/niveles/nivel3/obtenerNivel",$data);
		}
	}
	
	public function registrarNivel3()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->registrarNivel3();
		}
		else
		{
			echo "0";
		}
	}
	
	public function editarNivel3()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->editarNivel3();
		}
		else
		{
			echo "0";
		}
	}
	
	public function borrarNivel3()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->borrarNivel3($this->input->post('idNivel3'));
		}
		else
		{
			echo "0";
		}
	}
	
	
	//OBTENER NIVELES PARA REGISTRO
	
	public function obtenerNiveles1Catalogo()
	{
		#if (!empty($_POST))
		{
			$data['nivel']	= $this->catalogos->obtenerNiveles1();
			
			$this->load->view("administracion/niveles/nivel1/obtenerNivelesCatalogo",$data);
		}
	}
	
	public function obtenerNiveles2Catalogo()
	{
		if (!empty($_POST))
		{
			$data['nivel']	= $this->catalogos->obtenerNiveles2Catalogo($this->input->post('idNivel1'));
			
			$this->load->view("administracion/niveles/nivel2/obtenerNivelesCatalogo",$data);
		}
	}
	
	public function obtenerNiveles3catalogo()
	{
		if (!empty($_POST))
		{
			$data['nivel']	= $this->catalogos->obtenerNiveles3Catalogo($this->input->post('idNivel2'));
			
			$this->load->view("administracion/niveles/nivel3/obtenerNivelesCatalogo",$data);
		}
	}
	
	public function obtenerNiveles2Busqueda()
	{
		if (!empty($_POST))
		{
			$data['niveles']	= $this->catalogos->obtenerNiveles2Catalogo($this->input->post('idNivel1'));
			
			$this->load->view("administracion/niveles/nivel2/obtenerNiveles2Busqueda",$data);
		}
	}
	
	public function obtenerNiveles3Busqueda()
	{
		if (!empty($_POST))
		{
			$data['niveles']	= $this->catalogos->obtenerNiveles3Catalogo($this->input->post('idNivel2'));
			
			$this->load->view("administracion/niveles/nivel3/obtenerNiveles3Busqueda",$data);
		}
	}
	
	public function obtenerPadres()
	{
		$datos = $this->catalogos->obtenerPadres($this->input->get('term'));
		
		if($datos!=null)
		{
			foreach ($datos as $row)
			{
				$result[]= $row;
			}
			
			echo json_encode($result);
		}
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CONVENIOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
	public function listaConvenios()
	{
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		
		$this->load->view("catalogos/convenios/index",$data);
	}

	public function obtenerConvenios($limite=0)
	{
		$criterio				= $this->input->post('criterio');

		$Pag["base_url"]		= base_url()."catalogos/obtenerConvenios/";
		$Pag["total_rows"]		= $this->catalogos->contarConvenios($criterio);
		$Pag["per_page"]		= 10;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['registros'] 		= $this->catalogos->obtenerConvenios($Pag["per_page"],$limite,$criterio);
		$data['inicio']  		= $limite+1;

		$this->load->view("catalogos/convenios/obtenerRegistros",$data);
	}
	
	public function obtenerConveniosCatalogo()
	{
		$data['registros']	= $this->catalogos->obtenerConvenios();
			
		$this->load->view("catalogos/convenios/obtenerRegistrosCatalogo",$data);
	}
	
	public function formularioConvenios()
	{
		$this->load->view("catalogos/convenios/formularioRegistro");
	}
	
	public function obtenerConvenio()
	{
		if (!empty($_POST))
		{
			$data['registro']	= $this->catalogos->obtenerConvenio($this->input->post('idConvenio'));
			
			$this->load->view("catalogos/convenios/obtenerRegistro",$data);
		}
	}
	
	public function registrarConvenio()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->registrarConvenio();
		}
		else
		{
			echo "0";
		}
	}
	
	public function editarConvenio()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->editarConvenio();
		}
		else
		{
			echo "0";
		}
	}
	
	public function borrarConvenio()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->borrarConvenio($this->input->post('idConvenio'));
		}
		else
		{
			echo "0";
		}
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//DEPENDENCIAS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
	public function listaDependencias()
	{
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		
		$this->load->view("catalogos/dependencias/index",$data);
	}

	public function obtenerDependencias($limite=0)
	{
		$criterio				= $this->input->post('criterio');

		$Pag["base_url"]		= base_url()."catalogos/obtenerDependencias/";
		$Pag["total_rows"]		= $this->catalogos->contarDependencias($criterio);
		$Pag["per_page"]		= 10;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['registros'] 		= $this->catalogos->obtenerDependencias($Pag["per_page"],$limite,$criterio);
		$data['inicio']  		= $limite+1;

		$this->load->view("catalogos/dependencias/obtenerRegistros",$data);
	}
	
	public function obtenerDependenciasCatalogo()
	{
		$data['registros']	= $this->catalogos->obtenerDependencias();
			
		$this->load->view("catalogos/dependencias/obtenerRegistrosCatalogo",$data);
	}
	
	public function formularioDependencias()
	{
		$this->load->view("catalogos/dependencias/formularioRegistro");
	}
	
	public function obtenerDependencia()
	{
		if (!empty($_POST))
		{
			$data['registro']	= $this->catalogos->obtenerDependencia($this->input->post('idDependencia'));
			
			$this->load->view("catalogos/dependencias/obtenerRegistro",$data);
		}
	}
	
	public function registrarDependencia()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->registrarDependencia();
		}
		else
		{
			echo "0";
		}
	}
	
	public function editarDependencia()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->editarDependencia();
		}
		else
		{
			echo "0";
		}
	}
	
	public function borrarDependencia()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->borrarDependencia($this->input->post('idDependencia'));
		}
		else
		{
			echo "0";
		}
	}
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CARGOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
	public function listaCargos()
	{
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		
		$this->load->view("catalogos/cargos/index",$data);
	}

	public function obtenerCargos($limite=0)
	{
		$criterio				= $this->input->post('criterio');

		$Pag["base_url"]		= base_url()."catalogos/obtenerCargos/";
		$Pag["total_rows"]		= $this->catalogos->contarCargos($criterio);
		$Pag["per_page"]		= 10;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['registros'] 		= $this->catalogos->obtenerCargos($Pag["per_page"],$limite,$criterio);
		$data['inicio']  		= $limite+1;

		$this->load->view("catalogos/cargos/obtenerRegistros",$data);
	}
	
	public function obtenerCargosCatalogo()
	{
		$data['registros']	= $this->catalogos->obtenerCargos();
			
		$this->load->view("catalogos/cargos/obtenerRegistrosCatalogo",$data);
	}
	
	public function formularioCargos()
	{
		$this->load->view("catalogos/cargos/formularioRegistro");
	}
	
	public function obtenerCargo()
	{
		if (!empty($_POST))
		{
			$data['registro']	= $this->catalogos->obtenerCargo($this->input->post('idCargo'));
			
			$this->load->view("catalogos/cargos/obtenerRegistro",$data);
		}
	}
	
	public function registrarCargo()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->registrarCargo();
		}
		else
		{
			echo "0";
		}
	}
	
	public function editarCargo()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->editarCargo();
		}
		else
		{
			echo "0";
		}
	}
	
	public function borrarCargo()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->borrarCargo($this->input->post('idCargo'));
		}
		else
		{
			echo "0";
		}
	}
	
	
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//PAE
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
	public function listaPae()
	{
		$idCliente			= $this->input->post('idCliente');
		
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		$data['cliente'] 	= $this->clientes->obtenerCliente($idCliente);
		
		$this->load->view("catalogos/pae/index",$data);
	}

	public function obtenerPae($limite=0)
	{
		$criterio				= $this->input->post('criterio');
		$idCliente				= $this->input->post('idCliente');

		$Pag["base_url"]		= base_url()."catalogos/obtenerPae/";
		$Pag["total_rows"]		= $this->catalogos->contarPae($criterio,$idCliente);
		$Pag["per_page"]		= 10;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['registros'] 		= $this->catalogos->obtenerPae($Pag["per_page"],$limite,$criterio,$idCliente);
		$data['inicio']  		= $limite+1;

		$this->load->view("catalogos/pae/obtenerRegistros",$data);
	}
	
	public function obtenerPaeCatalogo()
	{
		$data['registros']	= $this->catalogos->obtenerPae();
			
		$this->load->view("catalogos/pae/obtenerRegistrosCatalogo",$data);
	}
	
	public function formularioPae()
	{
		$this->load->view("catalogos/pae/formularioRegistro");
	}
	
	public function obtenerRegistroPae()
	{
		if (!empty($_POST))
		{
			$data['registro']	= $this->catalogos->obtenerRegistroPae($this->input->post('idPae'));
			
			$this->load->view("catalogos/pae/obtenerRegistro",$data);
		}
	}
	
	public function registrarPae()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->registrarPae();
		}
		else
		{
			echo "0";
		}
	}
	
	public function editarPae()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->editarPae();
		}
		else
		{
			echo "0";
		}
	}
	
	public function borrarPae()
	{
		if (!empty($_POST))
		{
			echo $this->catalogos->borrarPae($this->input->post('idPae'));
		}
		else
		{
			echo "0";
		}
	}

	//FUENTES DE CONTACTO
	public function listaFuentes()
	{
		$data['permiso'] 	= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		
		$this->load->view("catalogos/fuentes/index",$data);
	}

	public function obtenerFuentes($limite=0)
	{
		$criterio				= $this->input->post('criterio');

		$Pag["base_url"]		= base_url()."catalogos/obtenerFuentes/";
		$Pag["total_rows"]		= $this->catalogos->contarFuentes($criterio);
		$Pag["per_page"]		= 10;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['registros'] 		= $this->catalogos->obtenerFuentes($Pag["per_page"],$limite,$criterio);
		$data['inicio']  		= $limite+1;

		$this->load->view("catalogos/fuentes/obtenerRegistros",$data);
	}
	
	public function obtenerFuentesCatalogo()
	{
		$data['registros']	= $this->catalogos->obtenerFuentes();
			
		$this->load->view("catalogos/fuentes/obtenerRegistrosCatalogo",$data);
	}
	
	public function formularioFuentes()
	{
		$this->load->view("catalogos/fuentes/formularioRegistro");
	}
	
	public function obtenerFuente()
	{
		if (!empty($_POST))
		{
			$data['registro']	= $this->catalogos->obtenerFuente($this->input->post('idFuente'));
			
			$this->load->view("catalogos/fuentes/obtenerRegistro",$data);
		}
	}
	
	public function registrarFuente()
	{
		if (!empty($_POST))
		{
			echo json_encode($this->catalogos->registrarFuente());
		}
		else
		{
			echo json_encode(array("0"));
		}
	}
	
	public function editarFuente()
	{
		if (!empty($_POST))
		{
			echo json_encode($this->catalogos->editarFuente());
		}
		else
		{
			echo json_encode(array("0"));
		}
	}
	
	public function borrarFuente()
	{
		if (!empty($_POST))
		{
			echo json_encode($this->catalogos->borrarFuente($this->input->post('idFuente')));
		}
		else
		{
			echo json_encode(array("0"));
		}
	}

	//PROPUESTAS
	public function listaPropuestas()
	{
		$data['permiso'] 		= $this->configuracion->obtenerPermisosBoton('19',$this->session->userdata('rol'));
		$data['idSeguimiento']	= $this->input->post('idSeguimiento');
		
		$this->load->view("catalogos/propuestas/index",$data);
	}

	public function obtenerPropuestas($limite=0)
	{
		$criterio				= $this->input->post('criterio');
		$idSeguimiento			= $this->input->post('idSeguimiento');

		$Pag["base_url"]		= base_url()."catalogos/obtenerPropuestas/";
		$Pag["total_rows"]		= $this->catalogos->contarPropuestas($criterio,$idSeguimiento);
		$Pag["per_page"]		= 100;
		$Pag["num_links"]		= 5;
		$Pag["uri_segment"]		= 3;
		
		$this->pagination->initialize($Pag);

		$data['registros'] 		= $this->catalogos->obtenerPropuestas($Pag["per_page"],$limite,$criterio,$idSeguimiento);
		$data['inicio']  		= $limite+1;

		$this->load->view("catalogos/propuestas/obtenerRegistros",$data);
	}
	
	public function obtenerPropuestasCatalogo()
	{
		$data['registros']	= $this->catalogos->obtenerPropuestas();
			
		$this->load->view("catalogos/propuestas/obtenerRegistrosCatalogo",$data);
	}
	
	public function formularioPropuestas()
	{
		$this->load->view("catalogos/propuestas/formularioRegistro");
	}
	
	public function obtenerPropuesta()
	{
		if (!empty($_POST))
		{
			$data['registro']	= $this->catalogos->obtenerPropuesta($this->input->post('idPropuesta'));
			
			$this->load->view("catalogos/propuestas/formularioEditar",$data);
		}
	}
	
	public function registrarPropuesta()
	{
		if (!empty($_POST))
		{
			echo json_encode($this->catalogos->registrarPropuesta());
		}
		else
		{
			echo json_encode(array("0"));
		}
	}
	
	public function editarPropuesta()
	{
		if (!empty($_POST))
		{
			echo json_encode($this->catalogos->editarPropuesta());
		}
		else
		{
			echo json_encode(array("0"));
		}
	}
	
	public function borrarPropuesta()
	{
		if (!empty($_POST))
		{
			echo json_encode($this->catalogos->borrarPropuesta($this->input->post('idPropuesta')));
		}
		else
		{
			echo json_encode(array("0"));
		}
	}

	//ARCHIVOS DE PROPUESTAS
	public function obtenerArchivosPropuesta()
	{
		$idPropuesta			= $this->input->post('idPropuesta');
		
		$data['idPropuesta']	= $idPropuesta;
		$data['archivos']		= $this->catalogos->obtenerArchivos($idPropuesta);
		
		$this->load->view('catalogos/propuestas/obtenerArchivos',$data);
	}
	
	public function registrarArchivo($idPropuesta=0)
	{
		if (!empty($_FILES)) 
		{
			$archivoTemporal	= $_FILES['file']['tmp_name'];

			//Validar tipos de archivos
			$extensiones 		= array('jpg','jpeg','gif','png','tif','bmp','pdf','doc','docx','xls','xlsx','txt','rar','zip','xps','oxps','xml');
			$archivo 			= pathinfo($_FILES['file']['name']);

			if (in_array($archivo['extension'],$extensiones)) 
			{
				$idArchivo	= $this->catalogos->registrarArchivo($idPropuesta,$_FILES['file']['name'],$_FILES['file']['size']);
				
				if($idArchivo>0)
				{
					move_uploaded_file($archivoTemporal,carpetaPropuestas.$idArchivo.'_'.$_FILES['file']['name']);

					if(file_exists(carpetaPropuestas.$idArchivo.'_'.$_FILES['file']['name']))
					{
						echo "1";
					}
					else
					{
						echo 'El comprobante no ha podido subir correctamente';
					}
				}
				else
				{
					echo 'Error al subir el comprobante';
				}
			} 
			else 
			{
				echo 'No se permiten estos archivos';
			}
		}
	} 

	public function borrarArchivoPropuesta()
	{
		if(!empty($_POST))
		{
			$idArchivo	=$this->input->post('idArchivo');

			echo $this->catalogos->borrarArchivo($idArchivo);
		}
	}
		
	function descargarArchivoPropuesta($idArchivo)
	{
		$this->load->helper('download');

		$registro	= $this->catalogos->obtenerArchivo($idArchivo);
		
		force_download($registro->nombre, file_get_contents(carpetaPropuestas.$registro->idArchivo.'_'.$registro->nombre)); 
	}

}
