<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Graph_client {
    private $token;
    private $version;

    public function __construct($config = [])
    {
        $this->token   = $config['access_token'] ?? getenv('META_TOKEN');
        $this->version = $config['version'] ?? 'v19.0';
    }

    public function get($path, $params = [])
    {
        $params['access_token'] = $this->token;
        $url = "https://graph.facebook.com/{$this->version}/{$path}?" . http_build_query($params);

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 20,
        ]);
        $out = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err || !$out) return null;
        $json = json_decode($out, true);
        return $json ?: null;
    }

    // /?ids=ID1,ID2&fields=name
    public function getNamesBulk(array $ids)
    {
        $ids = array_values(array_filter($ids));
        if (empty($ids)) return [];

        $resp = $this->get('', ['ids' => implode(',', $ids), 'fields' => 'name']);
        $out = [];
        if (is_array($resp)) {
            foreach ($ids as $id) $out[$id] = $resp[$id]['name'] ?? null;
        }
        return $out;
    }
}
