<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Webhook extends CI_Controller
{
    /**
     * ============================
     * Graph API via cURL (robusto)
     * ============================
     */
    private function graph_get($url)
    {
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 25,
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_SSL_VERIFYPEER => true,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_USERAGENT => 'IEXE-Webhook'
        ]);

        $response = curl_exec($ch);

        if ($response === false) {
            log_message('error', 'Graph API CURL error: ' . curl_error($ch));
        } else {
            $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if ($http >= 400) {
                log_message('error', 'Graph API HTTP '.$http.' response: '.$response);
            }
        }

        curl_close($ch);
        return $response;
    }

    public function index()
    {
        // ----------------------------------------------------------------
        // 1. VALIDACIÓN DEL WEBHOOK (SOLO LA PRIMERA VEZ) - NO TOCAR
        // Meta envía hub.mode / hub.verify_token / hub.challenge
        // PHP suele convertir puntos a guiones bajos.
        // ----------------------------------------------------------------
        $mode = isset($_GET['hub_mode']) ? $_GET['hub_mode'] : (isset($_GET['hub.mode']) ? $_GET['hub.mode'] : '');
        $token = isset($_GET['hub_verify_token']) ? $_GET['hub_verify_token'] : (isset($_GET['hub.verify_token']) ? $_GET['hub.verify_token'] : '');
        $challenge = isset($_GET['hub_challenge']) ? $_GET['hub_challenge'] : (isset($_GET['hub.challenge']) ? $_GET['hub.challenge'] : '');

        if ($mode === 'subscribe' && $token === 'iexe_crm_meta') {
            header('HTTP/1.1 200 OK');
            echo $challenge;
            exit;
        }

        // ----------------------------------------------------------------
        // 2. RECEPCIÓN DE UN NUEVO LEAD (POST REQUEST)
        // ----------------------------------------------------------------
        $input = file_get_contents('php://input');
        $data = json_decode($input, true);

        if (empty($data['entry'][0]['changes'][0]['value'])) {
            header('HTTP/1.1 200 OK');
            echo 'EVENT_RECEIVED';
            return;
        }

        $value = $data['entry'][0]['changes'][0]['value'];

        // Extraemos los IDs principales del webhook
        $lead_id    = isset($value['leadgen_id']) ? $value['leadgen_id'] : '';
        $form_id    = isset($value['form_id']) ? $value['form_id'] : '';
        $ad_id      = isset($value['ad_id']) ? $value['ad_id'] : '';
        $adgroup_id = isset($value['adgroup_id']) ? $value['adgroup_id'] : '';
        $page_id    = isset($value['page_id']) ? $value['page_id'] : '';
        $created_ts = isset($value['created_time']) ? $value['created_time'] : null;
        $created_at = $created_ts ? date('Y-m-d H:i:s', intval($created_ts)) : null;

        if (empty($lead_id)) {
            log_message('error', 'Webhook recibido sin leadgen_id. Payload: ' . $input);
            header('HTTP/1.1 200 OK');
            echo 'EVENT_RECEIVED';
            return;
        }

        // ⚠️ Recomendación: mover a config/env
        //$access_token = 'EAACmfJphrk8BQcUTMolKqQKXpNXVbc9ZC50ZBcYZAorlhPAansekfJbPnnAEVunFFPqP8PXEZAEyOd8R1Ce0Y60ZCcZAAB6llbVIUE8Udz3ZBaKXHzllcuOY6X5TWewKp2hBkP64PbEzhfSZAWZBTZA0ZAR4nCpE9IBZBtZAQUWXPFqwJ0pXIZByCNyuPyHwd2JcjUhD8i';
        
        $access_token = 'EAACmfJphrk8BQnvgPtdRc8ZCTnpaZAX4tMur3vjhP1FeK8lNNyQ0r0w9rB6ZCORPDrJgJ9SW9BPDrvaASaRHZA3DsPU2n2YmCEOvLlW9JLWsV0Bne1Ln71pKEVqdObNT1ZAxrfr9C3mbhByQz7ZBOblYu7AfFy6fyXLss7kOHZCuZAwZBAf9d5K5fGk4HbgZCYfJhZA';
        
        
        $this->load->database();

        // ----------------------------------------------------------------
        // 3. INSERT BASE EN leads_meta_webhook (evita duplicados)
        // ----------------------------------------------------------------
        $exists = $this->db->select('id')
            ->from('leads_meta_webhook')
            ->where('lead_id', $lead_id)
            ->limit(1)
            ->get()
            ->row_array();

        if (!$exists) {
            $this->db->insert('leads_meta_webhook', array(
                'lead_id'      => $lead_id,
                'form_id'      => $form_id,
                'ad_id'        => $ad_id,
                'adgroup_id'   => $adgroup_id,
                'page_id'      => $page_id,
                'created_time' => $created_at
            ));
        } else {
            // Si ya existe, al menos actualiza ids/created_time por si cambió algo
            $this->db->update('leads_meta_webhook', array(
                'form_id'      => $form_id,
                'ad_id'        => $ad_id,
                'adgroup_id'   => $adgroup_id,
                'page_id'      => $page_id,
                'created_time' => $created_at
            ), array('lead_id' => $lead_id));
        }

        $dataToUpdate = array();

        // ----------------------------------------------------------------
        // 4. OBTENER DATOS ADICIONALES USANDO GRAPH API (cURL)
        // ----------------------------------------------------------------

        // 4.1 AD / ADSET / CAMPAIGN + CREATIVE
        if (!empty($ad_id)) {
            $ad_url = "https://graph.facebook.com/v19.0/{$ad_id}?fields=name,adset{name},campaign{name,id},creative&access_token={$access_token}";
            $ad_response = $this->graph_get($ad_url);

            if ($ad_response) {
                $ad_details = json_decode($ad_response, true);

                if (!isset($ad_details['error'])) {
                    $dataToUpdate['ad_name']       = isset($ad_details['name']) ? $ad_details['name'] : '';
                    $dataToUpdate['adset_name']    = isset($ad_details['adset']['name']) ? $ad_details['adset']['name'] : '';
                    $dataToUpdate['campaign_name'] = isset($ad_details['campaign']['name']) ? $ad_details['campaign']['name'] : '';
                    $dataToUpdate['campaign_id']   = isset($ad_details['campaign']['id']) ? $ad_details['campaign']['id'] : '';

                    // Imagen desde creative (misma lógica que tu webhook, pero con cURL)
                    if (isset($ad_details['creative']['id'])) {
                        $creative_id = $ad_details['creative']['id'];

                        $image_fields = 'image_url,thumbnail_url,object_story_spec{link_data{picture},video_data{image_url}}';
                        $image_url_request = "https://graph.facebook.com/v19.0/{$creative_id}?fields={$image_fields}&access_token={$access_token}";
                        $image_response = $this->graph_get($image_url_request);

                        if ($image_response) {
                            $image_details = json_decode($image_response, true);
                            $imageUrlFound = '';

                            if (!empty($image_details['object_story_spec']['video_data']['image_url'])) {
                                $imageUrlFound = $image_details['object_story_spec']['video_data']['image_url'];
                            } elseif (!empty($image_details['image_url'])) {
                                $imageUrlFound = $image_details['image_url'];
                            } elseif (!empty($image_details['object_story_spec']['link_data']['picture'])) {
                                $imageUrlFound = $image_details['object_story_spec']['link_data']['picture'];
                            } elseif (!empty($image_details['thumbnail_url'])) {
                                $imageUrlFound = $image_details['thumbnail_url'];
                            }

                            if (!empty($imageUrlFound)) {
                                $dataToUpdate['ad_image_url'] = $imageUrlFound;
                            }
                        }
                    }
                } else {
                    log_message('error', 'Graph error ad_id '.$ad_id.': '.json_encode($ad_details['error']));
                }
            }
        }

        // 4.2 FORM NAME
        if (!empty($form_id)) {
            $form_url = "https://graph.facebook.com/v19.0/{$form_id}?fields=name&access_token={$access_token}";
            $form_response = $this->graph_get($form_url);

            if ($form_response) {
                $form_details = json_decode($form_response, true);
                if (!isset($form_details['error'])) {
                    $dataToUpdate['form_name'] = isset($form_details['name']) ? $form_details['name'] : '';
                } else {
                    log_message('error', 'Graph error form_id '.$form_id.': '.json_encode($form_details['error']));
                }
            }
        }

        // 4.3 PAGE NAME
        if (!empty($page_id)) {
            $page_url = "https://graph.facebook.com/v19.0/{$page_id}?fields=name&access_token={$access_token}";
            $page_response = $this->graph_get($page_url);

            if ($page_response) {
                $page_details = json_decode($page_response, true);
                if (!isset($page_details['error'])) {
                    $dataToUpdate['page_name'] = isset($page_details['name']) ? $page_details['name'] : '';
                } else {
                    log_message('error', 'Graph error page_id '.$page_id.': '.json_encode($page_details['error']));
                }
            }
        }

        // Actualizamos la fila en la base de datos con toda la información obtenida
        if (!empty($dataToUpdate)) {
            $this->db->update('leads_meta_webhook', $dataToUpdate, array('lead_id' => $lead_id));
        }

        // ----------------------------------------------------------------
        // 5. OBTENER LOS DATOS DEL FORMULARIO (NOMBRE, EMAIL, TEL, ETC.)
        // ----------------------------------------------------------------
        if (!empty($lead_id)) {
            $lead_url = "https://graph.facebook.com/v19.0/{$lead_id}?access_token={$access_token}";
            $lead_response = $this->graph_get($lead_url);

            if ($lead_response) {
                $leadDetails = json_decode($lead_response, true);

                if (!isset($leadDetails['error']) && !empty($leadDetails['field_data']) && is_array($leadDetails['field_data'])) {

                    // (Opcional pero útil) Evitar duplicados si Meta reintenta el mismo lead
                    $this->db->where('lead_id', $lead_id)->delete('leads_meta_fields');

                    foreach ($leadDetails['field_data'] as $field) {
                        $this->db->insert('leads_meta_fields', array(
                            'lead_id'     => $lead_id,
                            'field_name'  => isset($field['name']) ? $field['name'] : '',
                            'field_value' => (isset($field['values']) && is_array($field['values'])) ? implode(',', $field['values']) : ''
                        ));
                    }
                } else {
                    if (isset($leadDetails['error'])) {
                        log_message('error', 'Graph error lead_id '.$lead_id.': '.json_encode($leadDetails['error']));
                    } else {
                        log_message('error', 'Lead sin field_data (o vacío): '.$lead_id);
                    }
                }
            } else {
                log_message('error', 'Sin respuesta Graph para lead_id: '.$lead_id);
            }
        }

        // Respondemos a Meta para confirmar la recepción del evento
        header('HTTP/1.1 200 OK');
        echo 'EVENT_RECEIVED';
    }
}
