<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Forms extends CI_Controller
{
    public function index()
    {
        // --- CONFIGURACIÓN ---
        // Asegúrate de que estos valores sean correctos.
        $access_token  = 'EAACmfJphrk8BPK07ifhO2h2mDhaymTPzYxdF28zHUZAa1oBbXBRi5UHob0SPK1doI2CGHTPjw5HrJXul7vNGWrAZBzQy2LVmlwiXSgSpQ2EIlSKJW6abiRdWdbryvZBvOlvBlpSKO0Tzb6uPaWvpnXZC7eDyZAaBhB3IXd3HRiSGsjgbATRT2EBKXejOZBYJMl'; // Token largo con permiso ads_read
        $page_id       = '142145835862894'; // ID de tu página
        $ad_account_id = 'act_TU_AD_ACCOUNT_ID'; // <--- ¡MUY IMPORTANTE! REEMPLAZA ESTE VALOR

        // --- INICIALIZACIÓN ---
        $this->load->database();
        $form_ad_map = [];
        echo "Iniciando proceso de sincronización de formularios...<br>";

        // -------------------------------------------------------------------------
        // PASO 1: Obtener anuncios y crear el mapa de referencia
        // -------------------------------------------------------------------------
        echo "PASO 1: Obteniendo datos de anuncios desde la cuenta publicitaria ID: {$ad_account_id}...<br>";

        // Endpoint para obtener anuncios con los campos que necesitamos
        $ads_url = "https://graph.facebook.com/v19.0/{$ad_account_id}/ads?fields=name,campaign{name},lead_gen_form{id}&limit=500&access_token={$access_token}";
        
        $ads_response = file_get_contents($ads_url);

        // Verificamos si la llamada a la API falló
        if ($ads_response === FALSE) {
            die("<strong>Error Crítico:</strong> No se pudo conectar con la API de Anuncios de Facebook. Verifica la conexión a internet del servidor.");
        }

        $ads_data = json_decode($ads_response, true);

        // Verificamos si Facebook devolvió un error (ej. token inválido, permisos insuficientes)
        if (isset($ads_data['error'])) {
            die("<strong>Error de API (Anuncios):</strong> " . $ads_data['error']['message']);
        }

        if (!empty($ads_data['data'])) {
            echo "Se encontraron " . count($ads_data['data']) . " anuncios. Procesando...<br>";
            foreach ($ads_data['data'] as $ad) {
                if (isset($ad['lead_gen_form']['id'])) {
                    $form_id = $ad['lead_gen_form']['id'];
                    $form_ad_map[$form_id] = [
                        'ad_name'       => $ad['name'],
                        'campaign_name' => $ad['campaign']['name']
                    ];
                }
            }
            echo "Mapa de formularios y anuncios creado. Se mapearon " . count($form_ad_map) . " formularios únicos.<br>";
        } else {
            echo "Advertencia: No se encontraron anuncios con formularios de clientes potenciales en esta cuenta.<br>";
        }

        // -------------------------------------------------------------------------
        // PASO 2: Obtener todos los formularios de la página
        // -------------------------------------------------------------------------
        echo "<hr>PASO 2: Obteniendo la lista de formularios de la página ID: {$page_id}...<br>";
        $forms_url = "https://graph.facebook.com/v19.0/{$page_id}/leadgen_forms?access_token={$access_token}";
        
        $forms_response = file_get_contents($forms_url);

        if ($forms_response === FALSE) {
            die("<strong>Error Crítico:</strong> No se pudo conectar con la API de Formularios de Facebook.");
        }

        $forms_data = json_decode($forms_response, true);

        if (isset($forms_data['error'])) {
            die("<strong>Error de API (Formularios):</strong> " . $forms_data['error']['message']);
        }

        if (!empty($forms_data['data'])) {
            echo "Se encontraron " . count($forms_data['data']) . " formularios en total. Actualizando base de datos...<br>";
            $updates = 0;
            $inserts = 0;

            foreach ($forms_data['data'] as $form) {
                $form_id   = isset($form['id']) ? $form['id'] : '';
                $form_name = isset($form['name']) ? $form['name'] : '';
                $status    = isset($form['status']) && $form['status'] == 'ACTIVE' ? 1 : 0;

                // Usar el mapa para obtener campaign_name y ad_name
                $campaign_name = isset($form_ad_map[$form_id]) ? $form_ad_map[$form_id]['campaign_name'] : '';
                $ad_name       = isset($form_ad_map[$form_id]) ? $form_ad_map[$form_id]['ad_name'] : '';

                if ($form_id) {
                    $dataToSave = [
                        'form_id'       => $form_id,
                        'form_name'     => $form_name,
                        'campaign_name' => $campaign_name,
                        'ad_name'       => $ad_name,
                        'is_active'     => $status
                    ];

                    $existing = $this->db->get_where('meta_forms', ['form_id' => $form_id]);

                    if ($existing->num_rows() > 0) {
                        $this->db->update('meta_forms', $dataToSave, ['form_id' => $form_id]);
                        $updates++;
                    } else {
                        $this->db->insert('meta_forms', $dataToSave);
                        $inserts++;
                    }
                }
            }
            echo "<hr><strong>Proceso finalizado.</strong><br>";
            echo "Registros insertados: {$inserts}<br>";
            echo "Registros actualizados: {$updates}<br>";
        } else {
            echo "<strong>Finalizado:</strong> No se encontraron formularios en la página especificada.";
        }
    }
}
